/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.utils;

import ch.turic.Command;
import ch.turic.Program;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Unmarshaller {
    private final Map<Short, Class<?>> classRegistry = new HashMap();

    /*
     * Enabled aggressive exception aggregation
     */
    public Program deserialize(byte[] compressedData) {
        byte[] data = Unmarshaller.decompress(compressedData);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            Program program;
            try (DataInputStream input = new DataInputStream(bais);){
                int magic = input.readInt();
                if (magic != -891618626) {
                    throw new RuntimeException("Invalid magic number");
                }
                short version = input.readShort();
                if (version != 1) {
                    throw new RuntimeException("Unsupported version: " + version);
                }
                short count = input.readShort();
                for (short i = 0; i < count; i = (short)(i + 1)) {
                    String cname = input.readUTF();
                    this.classRegistry.put((short)(i + 1000), Class.forName(cname));
                }
                program = (Program)this.unmarshall(input);
            }
            return program;
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new RuntimeException("Failed to deserialize", e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] decompress(byte[] compressedData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object unmarshall(DataInputStream input) throws IOException, ReflectiveOperationException {
        String name;
        short marker = input.readShort();
        if (marker == 0) {
            return null;
        }
        if (marker == 999) {
            return this.unmarshall_array(input);
        }
        if (marker == 998) {
            return this.unmarshall_map(input);
        }
        Class<?> cls = this.classRegistry.get(marker);
        if (cls == null) {
            throw new ClassNotFoundException("Unknown class ID: " + marker);
        }
        return switch (name = cls.getCanonicalName()) {
            case "java.lang.String" -> input.readUTF();
            case "java.lang.Boolean" -> input.readBoolean();
            case "java.lang.Long" -> input.readLong();
            case "java.lang.Integer" -> input.readInt();
            case "java.lang.Double" -> input.readDouble();
            default -> {
                if (cls.isEnum()) {
                    String enumString = input.readUTF();
                    yield Enum.valueOf(cls, enumString);
                }
                Args args = new Args();
                int fieldCount = input.readShort();
                for (int i = 0; i < fieldCount; ++i) {
                    String fieldName = input.readUTF();
                    args.put(fieldName, this.unmarshall(input));
                }
                yield this.constructViaFactory(cls, args);
            }
        };
    }

    private Map<?, ?> unmarshall_map(DataInputStream input) throws IOException, ReflectiveOperationException {
        int size = input.readInt();
        HashMap<Object, Object> result = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = this.unmarshall(input);
            Object value = this.unmarshall(input);
            result.put(key, value);
        }
        return result;
    }

    private Object[] unmarshall_array(DataInputStream input) throws IOException, ReflectiveOperationException {
        int length = input.readInt();
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.unmarshall(input);
        }
        return result;
    }

    private Object constructViaFactory(Class<?> cls, Args fieldMap) {
        try {
            Method factory = cls.getDeclaredMethod("factory", Args.class);
            factory.setAccessible(true);
            if (!Modifier.isStatic(factory.getModifiers())) {
                throw new IllegalStateException(cls.getName() + " factory method must be static");
            }
            return factory.invoke(null, fieldMap);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Missing factory(Args) in " + cls.getName(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke factory in " + cls.getName(), e);
        }
    }

    public static class Args {
        private final Map<String, Object> args = new HashMap<String, Object>();

        public void put(String name, Object value) {
            this.args.put(name, value);
        }

        public <T> T get(String name, Class<T> targetClass) {
            return Args.cast(this.args.get(name), targetClass);
        }

        public boolean bool(String name) {
            return this.get(name, Boolean.class);
        }

        public String str(String name) {
            return this.get(name, String.class);
        }

        public Command command(String name) {
            return this.get(name, Command.class);
        }

        public Command[] commands() {
            return this.commands("commands");
        }

        public Command[] commands(String name) {
            return this.get(name, Command[].class);
        }

        private static <T> T cast(Object obj, Class<T> targetClass) {
            if (obj == null) {
                return null;
            }
            if (targetClass.isArray()) {
                Class<?> componentType = targetClass.getComponentType();
                if (!obj.getClass().isArray()) {
                    throw new ClassCastException("Cannot cast non-array to array of " + componentType.getName());
                }
                int length = Array.getLength(obj);
                Object result = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(obj, i);
                    Array.set(result, i, Args.cast(element, componentType));
                }
                return (T)result;
            }
            if (targetClass.isPrimitive()) {
                Object object;
                Object object2 = obj;
                Objects.requireNonNull(object2);
                Object object3 = object2;
                int n = 0;
                block11: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Number.class, Number.class, Number.class, Number.class, Number.class, Character.class, Boolean.class}, (Object)object3, n)) {
                        case 0: {
                            Number number = (Number)object3;
                            if (targetClass != Double.TYPE) {
                                n = 1;
                                continue block11;
                            }
                            object = number.doubleValue();
                            break block11;
                        }
                        case 1: {
                            Number number = (Number)object3;
                            if (targetClass != Float.TYPE) {
                                n = 2;
                                continue block11;
                            }
                            object = Float.valueOf(number.floatValue());
                            break block11;
                        }
                        case 2: {
                            Number number = (Number)object3;
                            if (targetClass != Long.TYPE) {
                                n = 3;
                                continue block11;
                            }
                            object = number.longValue();
                            break block11;
                        }
                        case 3: {
                            Number number = (Number)object3;
                            if (targetClass != Integer.TYPE) {
                                n = 4;
                                continue block11;
                            }
                            object = number.intValue();
                            break block11;
                        }
                        case 4: {
                            Number number = (Number)object3;
                            if (targetClass != Short.TYPE) {
                                n = 5;
                                continue block11;
                            }
                            object = number.shortValue();
                            break block11;
                        }
                        case 5: {
                            Number number = (Number)object3;
                            if (targetClass != Byte.TYPE) {
                                n = 6;
                                continue block11;
                            }
                            object = number.byteValue();
                            break block11;
                        }
                        case 6: {
                            Character c = (Character)object3;
                            if (targetClass != Character.TYPE) {
                                n = 7;
                                continue block11;
                            }
                            object = c;
                            break block11;
                        }
                        case 7: {
                            Boolean b = (Boolean)object3;
                            if (targetClass != Boolean.TYPE) {
                                n = 8;
                                continue block11;
                            }
                            object = obj;
                            break block11;
                        }
                        default: {
                            throw new ClassCastException("Cannot cast " + obj.getClass().getName() + " to " + targetClass.getName());
                        }
                    }
                    break;
                }
                return (T)object;
            }
            return targetClass.cast(obj);
        }
    }
}

