/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.cli;

import ch.turic.BadSyntax;
import ch.turic.Input;
import ch.turic.Repl;
import ch.turic.TuriFunction;
import ch.turic.TuriMacro;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Lexer;
import ch.turic.commands.Closure;
import ch.turic.commands.Macro;
import ch.turic.memory.Context;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class JLineRepl {
    public static void execute() throws IOException {
        Repl interpreter = new Repl();
        Terminal terminal = TerminalBuilder.builder().system(true).build();
        DefaultParser parser = new DefaultParser();
        DefaultHistory history = new DefaultHistory();
        LineReader reader = LineReaderBuilder.builder().appName("Turicum").terminal(terminal).completer((Completer)new StringsCompleter(() -> ((Repl)interpreter).completions())).parser((Parser)parser).history((History)history).build();
        String prompt = ">>> ";
        String morePrompt = "... ";
        String prefix = "";
        Throwable lastError = null;
        System.out.println("Turicum REPL with JLine (//help for more info)");
        StringBuilder buffer = new StringBuilder();
        SyntaxState state = SyntaxState.OK;
        ArrayList<Context> ctx_stack = new ArrayList<Context>();
        block10: while (true) {
            String line;
            try {
                String actualPrompt = switch (state.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 2 -> "ERROR, INPUT IGNORED\n" + prefix + ">>> ";
                    case 0 -> prefix + ">>> ";
                    case 1 -> prefix + "... ";
                };
                line = reader.readLine(actualPrompt);
            }
            catch (EndOfFileException | UserInterruptException e) {
                break;
            }
            String cmd = line.trim();
            if (cmd.startsWith("//") && cmd.endsWith("help") && cmd.substring(2, cmd.length() - 4).isBlank()) {
                System.out.println("\nTuricum REPL help screen\n\n//exit to exit the repl\n\n>>>    is the starting prompt\n...    is the continuation prompt\n{      starts a new context\n}      closes the current context (the context level is shown at the start of the prompt)\n//     to drop the current input and start a new one\n?      list the local variables (current frame)\n??     list all variables\n???    list all frames and global variables\n//help this help screen\n");
                continue;
            }
            if (cmd.startsWith("//") && cmd.endsWith("exit") && cmd.substring(2, cmd.length() - 4).isBlank()) break;
            if (cmd.equals("//")) {
                buffer.setLength(0);
                state = SyntaxState.OK;
                continue;
            }
            if (cmd.startsWith("??")) {
                int i;
                int n = i = cmd.equals("???") ? 0 : 1;
                while (true) {
                    if (i > ctx_stack.size()) continue block10;
                    Context context = i < ctx_stack.size() ? (Context)ctx_stack.get(i) : interpreter.ctx;
                    System.out.printf("Frame #%s:%n", i);
                    for (String k : context.allFrameKeys()) {
                        JLineRepl.printVariable(k, context);
                    }
                    ++i;
                }
            }
            if (line.trim().equals("?")) {
                if (!buffer.isEmpty() && lastError != null) {
                    System.out.println(lastError.getMessage());
                    continue;
                }
                Iterator i = interpreter.ctx.allFrameKeys().iterator();
                while (true) {
                    if (!i.hasNext()) continue block10;
                    String k = (String)i.next();
                    JLineRepl.printVariable(k, interpreter.ctx);
                }
            }
            lastError = null;
            buffer.append(line);
            cmd = buffer.toString();
            if (cmd.matches("\\{+")) {
                state = SyntaxState.OK;
                prefix = JLineRepl.openContexts(cmd.length(), ctx_stack, interpreter, buffer);
                continue;
            }
            if (cmd.matches("}+")) {
                if (ctx_stack.isEmpty()) {
                    state = SyntaxState.DROP_DEAD;
                } else {
                    state = SyntaxState.OK;
                    prefix = JLineRepl.closeContexts(cmd.length(), interpreter, ctx_stack);
                }
                buffer.setLength(0);
                continue;
            }
            buffer.append("\n");
            state = JLineRepl.countBraces(buffer.toString());
            if (state == SyntaxState.DROP_DEAD) {
                buffer.setLength(0);
                continue;
            }
            if (state != SyntaxState.OK || buffer.isEmpty()) continue;
            try {
                System.out.println(JLineRepl.formatValue(interpreter.execute(buffer.toString())));
                history.add(buffer.toString());
                buffer.setLength(0);
            }
            catch (BadSyntax bs) {
                if (interpreter.lexes.hasNext()) {
                    System.out.println(bs.getMessage());
                    buffer.setLength(0);
                    state = SyntaxState.DROP_DEAD;
                    lastError = null;
                    continue;
                }
                state = SyntaxState.NOT_READY;
                lastError = bs;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                buffer.setLength(0);
                state = SyntaxState.DROP_DEAD;
            }
        }
    }

    private static String openContexts(int num, ArrayList<Context> ctx_stack, Repl interpreter, StringBuilder buffer) {
        for (int i = 0; i < num; ++i) {
            ctx_stack.add(interpreter.ctx);
            interpreter.ctx = interpreter.ctx.wrap();
        }
        String prefix = JLineRepl.calculatePrefix(ctx_stack);
        buffer.setLength(0);
        return prefix;
    }

    private static String closeContexts(int num, Repl interpreter, ArrayList<Context> ctx_stack) {
        for (int i = 0; i < num; ++i) {
            interpreter.ctx = ctx_stack.removeLast();
        }
        String prefix = JLineRepl.calculatePrefix(ctx_stack);
        return prefix;
    }

    private static String calculatePrefix(ArrayList<Context> ctx_stack) {
        int num = ctx_stack.size();
        if (num > 5) {
            return "{" + num + "{";
        }
        return "{".repeat(num);
    }

    private static void printVariable(String k, Context context) {
        String value = JLineRepl.formatValue(context.get(k));
        System.out.printf("%s: %s\n", k, value);
    }

    private static String formatValue(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TuriMacro.class, TuriFunction.class, Closure.class, Macro.class}, (Object)object, n)) {
            case 0 -> {
                TuriMacro ignored = (TuriMacro)object;
                yield "built-in";
            }
            case 1 -> {
                TuriFunction ignored = (TuriFunction)object;
                yield "built-in";
            }
            case 2 -> {
                Closure ignored = (Closure)object;
                yield "fn()";
            }
            case 3 -> {
                Macro ignored = (Macro)object;
                yield "macro fn()";
            }
            case -1 -> "none";
            default -> value.toString();
        };
    }

    private static SyntaxState countBraces(String s) {
        try {
            LexList lexes = Lexer.analyze((ch.turic.analyzer.Input)((ch.turic.analyzer.Input)Input.fromString((String)s)));
            ArrayList<Lex> braces = new ArrayList<Lex>();
            while (lexes.hasNext()) {
                if (lexes.is(new String[]{"{", "(", "["})) {
                    braces.add(lexes.next());
                    continue;
                }
                if (lexes.is(new String[]{"}", ")", "]"})) {
                    if (braces.isEmpty()) {
                        return SyntaxState.DROP_DEAD;
                    }
                    Lex lastB = (Lex)braces.removeLast();
                    if (lexes.is(new String[]{"}"}) && !lastB.text().equals("{") || lexes.is(new String[]{")"}) && !lastB.text().equals("(") || lexes.is(new String[]{"]"}) && !lastB.text().equals("[")) {
                        return SyntaxState.DROP_DEAD;
                    }
                    lexes.next();
                    continue;
                }
                lexes.next();
            }
            return braces.isEmpty() ? SyntaxState.OK : SyntaxState.NOT_READY;
        }
        catch (BadSyntax e) {
            return SyntaxState.NOT_READY;
        }
    }

    private static enum SyntaxState {
        OK,
        NOT_READY,
        DROP_DEAD;

    }
}

