/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.analyzer.Input;

class Escape {
    private static final String escapes = "btnfr\"'\\`";
    private static final String escaped = "\b\t\n\f\r\"'\\`";

    Escape() {
    }

    private static char octal(Input in, int maxLen) {
        int occ = 0;
        for (int i = maxLen; i > 0 && !in.isEmpty() && in.charAt(0) >= '0' && in.charAt(0) <= '7'; --i) {
            occ = 8 * occ + in.charAt(0) - 48;
            in.skip(1);
        }
        return (char)occ;
    }

    private static char hex(Input in, int maxLen) {
        int hx = 0;
        for (int i = maxLen; i > 0 && !in.isEmpty() && (in.charAt(0) >= '0' && in.charAt(0) <= '9' || in.charAt(0) >= 'A' && in.charAt(0) <= 'F' || in.charAt(0) >= 'a' && in.charAt(0) <= 'f'); --i) {
            char ch = in.charAt(0);
            hx = 16 * hx;
            if (ch >= '0' && ch <= '9') {
                hx += ch - 48;
            } else if (ch >= 'A' && ch <= 'F') {
                hx += ch - 65 + 10;
            } else if (ch >= 'a' && ch <= 'f') {
                hx += ch - 97 + 10;
            }
            in.skip(1);
        }
        return (char)hx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void handleEscape(Input input, StringBuilder output) throws BadSyntax {
        input.skip(1);
        BadSyntax.when(input.position, input.isEmpty(), "Source ended inside a string.", new Object[0]);
        char nextCh = input.charAt(0);
        int esindex = escapes.indexOf(nextCh);
        if (esindex == -1) {
            if (nextCh >= '0' && nextCh <= '3') {
                output.append(Escape.octal(input, 3));
                return;
            } else if (nextCh >= '4' && nextCh <= '7') {
                output.append(Escape.octal(input, 2));
                return;
            } else {
                if (nextCh != 'u') throw new BadSyntax(input.position, "Invalid escape sequence in string: \\" + nextCh, new Object[0]);
                input.skip(1);
                output.append(Escape.hex(input, 4));
            }
            return;
        } else {
            output.append(escaped.charAt(esindex));
            input.skip(1);
        }
    }

    static void handleNormalCharacter(Input input, StringBuilder output) throws BadSyntax {
        char ch = input.charAt(0);
        BadSyntax.when(input.position, ch == '\n' || ch == '\r', () -> String.format("String not terminated before eol:\n%s...", input.substring(1, Math.min(input.length(), 60))));
        output.append(ch);
        input.skip(1);
    }

    static void handleNormalMultiLineStringCharacter(Input input, StringBuilder output) {
        char ch = input.charAt(0);
        if (ch == '\n' || ch == '\r') {
            Escape.normalizedNewLines(input, output);
        } else {
            output.append(ch);
            input.skip(1);
        }
    }

    private static void normalizedNewLines(Input input, StringBuilder output) {
        char ch = input.charAt(0);
        int countNewLines = 0;
        while (!(input.isEmpty() || ch != '\n' && ch != '\r')) {
            if (ch == '\n') {
                ++countNewLines;
            }
            input.skip(1);
            if (input.isEmpty()) continue;
            ch = input.charAt(0);
        }
        if (countNewLines == 0) {
            ++countNewLines;
        }
        output.append("\n".repeat(countNewLines));
    }
}

