/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.Analyzer;
import ch.turic.analyzer.BinaryExpressionAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.OptionListAnalyzer;
import ch.turic.commands.AsyncEvaluation;
import ch.turic.commands.AwaitEvaluation;
import java.util.Map;
import java.util.Set;

public class ExpressionAnalyzer
extends AbstractAnalyzer {
    public static final Analyzer INSTANCE = new ExpressionAnalyzer();
    private static final Set<String> ASYNC_OPTIONS = Set.of("in", "out", "steps", "time");
    private static final Set<String> AWAIT_OPTIONS = Set.of("time");

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        if (lexes.isKeyword()) {
            switch (lexes.peek().text()) {
                case "async": {
                    Map<String, Command> asyncOptions = this.getOptions(lexes, "Async", ASYNC_OPTIONS);
                    return new AsyncEvaluation(this.analyze(lexes), asyncOptions);
                }
                case "await": {
                    Map<String, Command> awaitOptions = this.getOptions(lexes, "await", AWAIT_OPTIONS);
                    return new AwaitEvaluation(this.analyze(lexes), awaitOptions);
                }
            }
        }
        return BinaryExpressionAnalyzer.INSTANCE.analyze(lexes);
    }

    private Map<String, Command> getOptions(LexList lexes, String forWhat, Set<String> OPTIONS) {
        Map<String, Command> asyncOptions;
        lexes.next();
        if (lexes.peek().text().equals("[")) {
            lexes.next();
            asyncOptions = OptionListAnalyzer.analyze(lexes, OPTIONS);
            BadSyntax.when(lexes, !lexes.peek().text().equals("]"), "%s options should be closed with ']'", forWhat);
            lexes.next();
        } else {
            asyncOptions = Map.of();
        }
        return asyncOptions;
    }
}

