/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.AssignmentList;
import ch.turic.analyzer.BlockAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.ParameterDefinition;
import ch.turic.commands.BlockCommand;
import ch.turic.commands.FunctionDefinition;
import ch.turic.commands.ParameterList;
import ch.turic.commands.TypeDeclaration;

public class FunctionDefinitionAnalyzer
extends AbstractAnalyzer {
    public static final FunctionDefinitionAnalyzer INSTANCE = new FunctionDefinitionAnalyzer();

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        BlockCommand block;
        TypeDeclaration[] returnType;
        String fn;
        if (lexes.is("(")) {
            fn = null;
        } else {
            BadSyntax.when(lexes, !lexes.isIdentifier(), "function name or '(' expected after fn. You cannot omit the '()' for anonymous function.", new Object[0]);
            fn = lexes.next().text();
        }
        boolean hasParens = lexes.is("(");
        if (hasParens) {
            lexes.next();
        }
        ParameterList arguments = hasParens || lexes.isNot("{") ? ParameterDefinition.INSTANCE.analyze(lexes) : ParameterList.EMPTY;
        if (hasParens) {
            ExecutionException.when(lexes.isNot(")"), "Function parameter list is opened, but not closed using parenthesis", new Object[0]);
            lexes.next();
        }
        if (lexes.is(":")) {
            lexes.next();
            returnType = AssignmentList.getTheTypeDefinitions(lexes);
        } else {
            returnType = AssignmentList.EMPTY_TYPE;
        }
        if (lexes.is("=")) {
            BadSyntax.when(lexes, !hasParens, "use must use parenthesis in function definition when using '=expression' as body", new Object[0]);
            lexes.next();
            Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            block = new BlockCommand(new Command[]{expression}, false);
        } else if (lexes.is(";")) {
            BadSyntax.when(lexes, !hasParens, "use must use parenthesis in initialized without body", new Object[0]);
            BadSyntax.when(lexes, !"init".equals(fn), "Only initializer can have no body", new Object[0]);
            block = new BlockCommand(new Command[0], false);
        } else {
            block = (BlockCommand)BlockAnalyzer.INSTANCE.analyze(lexes);
        }
        return new FunctionDefinition(fn, arguments, returnType, block);
    }
}

