/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.analyzer.Pos;

public class Input
implements ch.turic.Input,
CharSequence {
    public final Pos position;
    private final StringBuilder builder;

    public Input(StringBuilder builder, String fn) {
        String[] lines = builder.toString().split("\n", -1);
        this.position = new Pos(fn, lines);
        this.builder = builder;
    }

    @Override
    public String toString() {
        return this.builder.toString();
    }

    public String substring(int start, int end) {
        return this.builder.substring(start, end);
    }

    @Override
    public boolean isEmpty() {
        return this.builder.isEmpty();
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public char charAt(int index) {
        return this.builder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.builder.subSequence(start, end);
    }

    public int startsWith(String ... s) {
        for (int i = 0; i < s.length; ++i) {
            if (s[i].length() > this.builder.length() || !this.builder.subSequence(0, s[i].length()).equals(s[i])) continue;
            return i;
        }
        return -1;
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public String fetchHexNumber() {
        StringBuilder output = new StringBuilder();
        while (this.length() > 0 && Input.isHex(this.charAt(0))) {
            output.append(this.charAt(0));
            this.skip(1);
        }
        return output.toString();
    }

    public String fetchNumber() {
        StringBuilder output = new StringBuilder();
        while (this.length() > 0 && (Character.isDigit(this.charAt(0)) || this.charAt(0) == '_')) {
            output.append(this.charAt(0));
            this.skip(1);
        }
        return output.toString();
    }

    public String fetchId() {
        StringBuilder output = new StringBuilder();
        if (this.length() > 0 && Input.validId1stChar(this.charAt(0))) {
            while (this.length() > 0 && Input.validIdChar(this.charAt(0))) {
                output.append(this.charAt(0));
                this.skip(1);
            }
        } else {
            while (this.length() > 0 && !Character.isWhitespace(this.charAt(0))) {
                output.append(this.charAt(0));
                this.skip(1);
            }
        }
        return output.toString();
    }

    public void skip(int numberOfCharacters) {
        if (this.builder.charAt(0) == '\n') {
            ++this.position.line;
            this.position.column = 0;
        } else {
            this.position.column += numberOfCharacters;
        }
        this.builder.delete(0, numberOfCharacters);
    }

    static boolean validId1stChar(char c) {
        return c == '_' || Character.isAlphabetic(c);
    }

    static boolean validIdChar(char c) {
        return Input.validId1stChar(c) || Character.isDigit(c);
    }
}

