/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.classes;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.Input;
import ch.turic.LngCallable;
import ch.turic.TuriClass;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Lexer;
import ch.turic.analyzer.ProgramAnalyzer;
import ch.turic.builtins.classes.TuriMethod;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.commands.Conditional;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.Context;
import ch.turic.memory.LngList;
import ch.turic.utils.CaseFolder;
import ch.turic.utils.StringUtils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TuriString
implements TuriClass {
    @Override
    public Class<?> forClass() {
        return String.class;
    }

    @Override
    public LngCallable getMethod(Object target, String identifier) {
        if (!(target instanceof String)) {
            throw new ExecutionException("Target object is not a String, this is an internal error", new Object[0]);
        }
        String string = (String)target;
        return switch (identifier) {
            case "to_string" -> new TuriMethod<String>(args -> String.format("%s", string));
            case "length" -> new TuriMethod<Long>(args -> string.length());
            case "after" -> new TuriMethod<String>(args -> {
                String afterWhat = String.valueOf(args[0]);
                int pos = string.indexOf(afterWhat);
                if (pos < 0) {
                    return "";
                }
                return string.substring(pos + afterWhat.length());
            });
            case "before" -> new TuriMethod<String>(args -> {
                String beforeWhat = String.valueOf(args[0]);
                int pos = string.indexOf(beforeWhat);
                if (pos < 0) {
                    return "";
                }
                return string.substring(0, pos);
            });
            case "pad_left" -> new TuriMethod<String>(args -> {
                FunUtils.ArgumentsHolder arguments = FunUtils.args("pad_left", args, Object[].class);
                String pad = arguments.at(1).getOr(" ");
                ExecutionException.when(pad.isEmpty(), "cannot pad with empty string", new Object[0]);
                int n = arguments.at(0).intValue();
                if (n <= string.length()) {
                    return string;
                }
                int k = (n - string.length()) / pad.length();
                return pad.repeat(k) + string;
            });
            case "pad_right" -> new TuriMethod<String>(args -> {
                FunUtils.ArgumentsHolder arguments = FunUtils.args("pad_right", args, Object[].class);
                String pad = arguments.at(1).getOr(" ");
                ExecutionException.when(pad.isEmpty(), "cannot pad with empty string", new Object[0]);
                int n = arguments.at(0).intValue();
                if (n <= string.length()) {
                    return string;
                }
                int k = (n - string.length()) / pad.length();
                return string + pad.repeat(k);
            });
            case "between" -> new TuriMethod<String>(args -> {
                String afterWhat = String.valueOf(args[0]);
                String beforeWhat = String.valueOf(args[1]);
                int endIndex = string.indexOf(beforeWhat);
                int pos2 = string.indexOf(afterWhat);
                if (endIndex < 0 || pos2 < 0) {
                    return "";
                }
                int beginIndex = pos2 + afterWhat.length();
                if (endIndex <= beginIndex) {
                    return "";
                }
                return string.substring(beginIndex, endIndex);
            });
            case "lines" -> new TuriMethod<LngList>(args -> {
                LngList list = new LngList();
                list.array.addAll(Arrays.asList(string.split("\n", -1)));
                return list;
            });
            case "words" -> new TuriMethod<LngList>(args -> {
                LngList list = new LngList();
                list.array.addAll(Arrays.asList(string.split("\\W+", -1)));
                return list;
            });
            case "turi_lex" -> new TuriMethod<LexList>(args -> Lexer.analyze((ch.turic.analyzer.Input)Input.fromString(string)));
            case "execute" -> (context, args) -> {
                Context ctx = FunUtils.ctx(context);
                ProgramAnalyzer analyzer = new ProgramAnalyzer();
                Command code = analyzer.analyze(Lexer.analyze((ch.turic.analyzer.Input)Input.fromString(string)));
                Object result = code.execute(ctx);
                if (result instanceof Conditional.Result) {
                    Conditional.Result res = (Conditional.Result)result;
                    return res.result();
                }
                return result;
            };
            case "url_encode" -> new TuriMethod<String>(args -> URLEncoder.encode(string, StandardCharsets.UTF_8));
            case "url_decode" -> new TuriMethod<String>(args -> URLDecoder.decode(string, StandardCharsets.UTF_8));
            case "md5" -> new TuriMethod<String>(args -> StringUtils.digest(string, "MD5"));
            case "sha_1" -> new TuriMethod<String>(args -> StringUtils.digest(string, "SHA-1"));
            case "sha_256" -> new TuriMethod<String>(args -> StringUtils.digest(string, "SHA-256"));
            case "sha_512" -> new TuriMethod<String>(args -> StringUtils.digest(string, "SHA-512"));
            case "digest" -> new TuriMethod<String>(args -> StringUtils.digest(string, String.valueOf(args[0])));
            case "base64" -> new TuriMethod<String>(args -> {
                Base64.Encoder encoder = Base64.getEncoder();
                return encoder.encodeToString(string.getBytes(StandardCharsets.UTF_8));
            });
            case "from_base64" -> new TuriMethod<LngList>(args -> {
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] bytes = decoder.decode(string);
                LngList list = new LngList();
                for (byte aByte : bytes) {
                    list.array.add(aByte);
                }
                return list;
            });
            case "from_base64_str" -> new TuriMethod<String>(args -> {
                Base64.Decoder decoder = Base64.getDecoder();
                return new String(decoder.decode(string), StandardCharsets.UTF_8);
            });
            case "contains" -> new TuriMethod<Boolean>(args -> {
                String arg = FunUtils.arg("contains", args, String.class);
                return string.contains(arg);
            });
            case "contains_regex" -> new TuriMethod<Boolean>(args -> {
                String arg = FunUtils.arg("contains_regex", args, String.class);
                Pattern pattern = Pattern.compile(arg);
                return pattern.matcher(string).find();
            });
            case "matches" -> new TuriMethod<Boolean>(args -> {
                String arg = FunUtils.arg("matches", args, String.class);
                Pattern pattern = Pattern.compile(arg);
                return pattern.matcher(string).matches();
            });
            case "matches_glob" -> new TuriMethod<Boolean>(args -> {
                String arg = FunUtils.arg("matches_glob", args, String.class);
                return StringUtils.matches(arg, string);
            });
            case "is_blank" -> new TuriMethod<Boolean>(args -> string.isBlank());
            case "is_not_blank" -> new TuriMethod<Boolean>(args -> !string.isBlank());
            case "is_empty" -> new TuriMethod<Boolean>(args -> string.isEmpty());
            case "is_not_empty" -> new TuriMethod<Boolean>(args -> !string.isEmpty());
            case "is_numeric" -> new TuriMethod<Boolean>(args -> string.matches("^[-+]?\\d+(\\.\\d+)?([eE][-+]?\\d+)?$"));
            case "is_not_numeric" -> new TuriMethod<Boolean>(args -> !string.matches("^[-+]?\\d+(\\.\\d+)?([eE][-+]?\\d+)?$"));
            case "is_digit" -> new TuriMethod<Boolean>(args -> string.matches("^\\d+$"));
            case "is_not_digit" -> new TuriMethod<Boolean>(args -> !string.matches("^\\d+$"));
            case "is_alpha" -> new TuriMethod<Boolean>(args -> string.matches("^[a-zA-Z]+$"));
            case "is_not_alpha" -> new TuriMethod<Boolean>(args -> !string.matches("^[a-zA-Z]+$"));
            case "is_alphanumeric" -> new TuriMethod<Boolean>(args -> string.matches("^[a-zA-Z0-9]+$"));
            case "is_not_alphanumeric" -> new TuriMethod<Boolean>(args -> !string.matches("^[a-zA-Z0-9]+$"));
            case "is_hex" -> new TuriMethod<Boolean>(args -> string.matches("^(0x)?[a-fA-F0-9]+$"));
            case "is_not_hex" -> new TuriMethod<Boolean>(args -> !string.matches("^(0x)?[a-fA-F0-9]+$"));
            case "int" -> new TuriMethod<Long>(args -> Long.parseLong(string.strip()));
            case "float" -> new TuriMethod<Double>(args -> Double.parseDouble(string.strip()));
            case "number" -> new TuriMethod<Long>(args -> {
                Object number = FunUtils.arg("number", args);
                int radix = Cast.toLong(number).intValue();
                return Long.parseLong(string.strip(), radix);
            });
            case "hex" -> new TuriMethod<Long>(args -> {
                String hexString = string.strip();
                if (hexString.startsWith("0x") || hexString.startsWith("0X")) {
                    return Long.parseLong(hexString.substring(2), 16);
                }
                return Long.parseLong(hexString, 16);
            });
            case "substring" -> new TuriMethod<String>(args -> {
                FunUtils.ArgumentsHolder arguments = FunUtils.args("substring", args, Long.class, Object[].class);
                int beginIndex = arguments.at(0).intValue();
                if (beginIndex < 0) {
                    int n = -beginIndex / string.length();
                    beginIndex += (n + 1) * string.length();
                }
                if (beginIndex >= string.length()) {
                    return "";
                }
                if (arguments.N == 1) {
                    return string.substring(beginIndex);
                }
                if (arguments.N == 2) {
                    int endIndex = arguments.at(1).intValue();
                    if (endIndex < 0) {
                        int n = -endIndex / string.length();
                        endIndex += (n + 1) * string.length();
                    }
                    if (endIndex > string.length()) {
                        return string.substring(beginIndex);
                    }
                    return string.substring(beginIndex, endIndex);
                }
                throw new ExecutionException("substring() needs one or two arguments", new Object[0]);
            });
            case "remove_prefix" -> new TuriMethod<String>(args -> {
                String prefix = String.valueOf(args[0]);
                if (string.startsWith(prefix)) {
                    return string.substring(prefix.length());
                }
                return string;
            });
            case "remove_postfix" -> new TuriMethod<String>(args -> {
                String postfix = String.valueOf(args[0]);
                if (string.endsWith(postfix)) {
                    return string.substring(0, string.length() - postfix.length());
                }
                return string;
            });
            case "count_substring" -> new TuriMethod<Long>(args -> {
                String substr = String.valueOf(args[0]);
                int i = 0;
                long count = 0L;
                while ((i = string.indexOf(substr, i)) >= 0) {
                    i += substr.length();
                    ++count;
                }
                return count;
            });
            case "count_substring_overlap" -> new TuriMethod<Long>(args -> {
                String substr = String.valueOf(args[0]);
                int i = 0;
                long count = 0L;
                while ((i = string.indexOf(substr, i)) >= 0) {
                    ++i;
                    ++count;
                }
                return count;
            });
            case "left" -> new TuriMethod<String>(args -> {
                int endIndex = Cast.toLong(args[0]).intValue();
                if (endIndex > string.length()) {
                    return string;
                }
                return string.substring(0, endIndex);
            });
            case "right" -> new TuriMethod<String>(args -> {
                int n = Cast.toLong(args[0]).intValue();
                if (n >= string.length()) {
                    return string;
                }
                return string.substring(string.length() - n);
            });
            case "replace_all" -> new TuriMethod<String>(args -> string.replaceAll(String.valueOf(args[0]), String.valueOf(args[1])));
            case "quote" -> new TuriMethod<String>(args -> string.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("\"", "\\\""));
            case "reverse" -> new TuriMethod<String>(args -> new StringBuilder(string).reverse().toString());
            case "chop" -> new TuriMethod<String>(args -> {
                if (string.isEmpty()) {
                    return "";
                }
                return string.substring(0, string.length() - 1);
            });
            case "chomp" -> new TuriMethod<String>(args -> string.endsWith("\n") ? string.substring(0, string.length() - 1) : string);
            case "times" -> new TuriMethod<String>(args -> string.repeat(Cast.toLong(args[0]).intValue()));
            case "lower_case" -> new TuriMethod<String>(args -> string.toLowerCase());
            case "upper_case" -> new TuriMethod<String>(args -> string.toUpperCase());
            case "swap_case" -> new TuriMethod<String>(args -> StringUtils.swapCase(string));
            case "capitalize" -> new TuriMethod<String>(args -> {
                if (string.isEmpty()) {
                    return "";
                }
                if (string.length() == 1) {
                    return string.toUpperCase();
                }
                return string.substring(0, 1).toUpperCase() + string.substring(1);
            });
            case "title" -> new TuriMethod<String>(args -> StringUtils.toTitleCase(string));
            case "casefold" -> new TuriMethod<String>(args -> CaseFolder.casefold(string));
            case "trim" -> new TuriMethod<String>(args -> string.trim());
            case "strip" -> new TuriMethod<String>(args -> string.strip());
            case "strip_leading" -> new TuriMethod<String>(args -> string.stripLeading());
            case "strip_trailing" -> new TuriMethod<String>(args -> string.stripTrailing());
            case "strip_indent" -> new TuriMethod<String>(args -> string.stripIndent());
            case "starts_with" -> new TuriMethod<Boolean>(args -> string.startsWith(args[0].toString()));
            case "ends_with" -> new TuriMethod<Boolean>(args -> string.endsWith(args[0].toString()));
            case "partition" -> new TuriMethod<LngList>(args -> {
                String separator = FunUtils.arg("partition", args, String.class);
                LngList result = new LngList();
                result.addAll(List.of(StringUtils.partition(string, separator)));
                return result;
            });
            case "partition_regex" -> new TuriMethod<LngList>(args -> {
                String separator = FunUtils.arg("partition_regex", args, String.class);
                LngList result = new LngList();
                result.addAll(List.of(StringUtils.partitionRegex(string, separator)));
                return result;
            });
            case "split" -> new TuriMethod<LngList>(args -> {
                String splitter = ((Object[])args).length == 0 ? "\n" : args[0].toString();
                int limit = ((Object[])args).length < 2 ? -1 : Cast.toLong(args[1]).intValue();
                LngList list = new LngList();
                list.array.addAll(Arrays.asList(string.split(splitter, limit)));
                return list;
            });
            case "bytes" -> new TuriMethod<LngList>(args -> {
                byte[] bytes;
                LngList list = new LngList();
                for (byte b : bytes = string.getBytes(StandardCharsets.UTF_8)) {
                    list.array.add(b);
                }
                return list;
            });
            case "join" -> new TuriMethod<String>(args -> {
                if (((Object[])args).length != 1) {
                    throw new ExecutionException("join() needs one argument, a list", new Object[0]);
                }
                Object patt0$temp = args[0];
                if (patt0$temp instanceof LngList) {
                    LngList list = (LngList)patt0$temp;
                    return list.array.stream().map(Object::toString).collect(Collectors.joining(string));
                }
                throw new ExecutionException("join() needs one argument, a list. '%s' is not a list", args[0]);
            });
            case "char_at" -> new TuriMethod<String>(args -> "" + string.charAt(Cast.toLong(args[0]).intValue()));
            case "safe_char_at" -> new TuriMethod<String>(args -> {
                Long arg = FunUtils.arg("safe_char_at", args, Long.class);
                int index = arg.intValue();
                if (index < 0 || index >= string.length()) {
                    return "";
                }
                return "" + string.charAt(index);
            });
            case "index_of" -> new TuriMethod<Long>(args -> {
                FunUtils.ArgumentsHolder arguments = FunUtils.args("index_of", args, String.class, Object[].class);
                String str = arguments.at(0).as(String.class);
                if (arguments.N == 2) {
                    Integer index = arguments.at(1).as(Integer.class);
                    if (index < 0 || index >= str.length()) {
                        return null;
                    }
                    return string.indexOf(str, (int)index);
                }
                return string.indexOf(str);
            });
            case "last_index_of" -> new TuriMethod<Long>(args -> {
                FunUtils.ArgumentsHolder arguments = FunUtils.args("index_of", args, String.class, Object[].class);
                String str = arguments.at(0).as(String.class);
                if (arguments.N == 2) {
                    Integer index = arguments.at(1).as(Integer.class);
                    if (index < 0 || index >= str.length()) {
                        return null;
                    }
                    return string.lastIndexOf(str, (int)index);
                }
                return string.lastIndexOf(str);
            });
            default -> null;
        };
    }
}

