/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.memory.ClassContext;
import ch.turic.memory.LngClass;
import ch.turic.memory.LngObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class IsType
implements TuriFunction {
    private static final String[] packages;

    @Override
    public String name() {
        return "is_type";
    }

    @Override
    public Object call(Context context, Object[] arguments) throws ExecutionException {
        FunUtils.ArgumentsHolder args = FunUtils.args(this.name(), arguments, Object.class, Object.class);
        Object obj = args.at(0).get();
        Object type = args.at(1).get();
        if (!(obj instanceof LngObject)) {
            return IsType.isJavaType(obj, type);
        }
        LngObject lngObject = (LngObject)obj;
        if (type instanceof String) {
            String typeName = (String)type;
            return IsType.isType(lngObject.lngClass(), typeName);
        }
        if (type instanceof LngClass) {
            LngClass lngClass = (LngClass)type;
            return IsType.isType(lngObject.lngClass(), lngClass);
        }
        return false;
    }

    private static boolean isJdkType(String typeName) {
        for (String p : packages) {
            if (!typeName.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJavaType(Object obs, Object type) {
        if (type instanceof String) {
            String typeName = (String)type;
            try {
                if (typeName.startsWith("java.") && !IsType.isJdkType(typeName)) {
                    typeName = typeName.substring(5);
                }
                Class<?> klass = Class.forName(typeName);
                return klass.isInstance(obs);
            }
            catch (ClassNotFoundException e) {
                throw new ExecutionException("'%s' is not a valid Java type", typeName);
            }
        }
        throw new ExecutionException("Type " + String.valueOf(type) + " is not a string", new Object[0]);
    }

    private static boolean isType(LngClass lngClass, LngClass type) {
        if (lngClass.equals(type)) {
            return true;
        }
        for (LngClass p : ((ClassContext)lngClass.context()).parents()) {
            if (!IsType.isType(p, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isType(LngClass lngClass, String type) {
        if (lngClass == null) {
            return false;
        }
        if (lngClass.name().equals(type)) {
            return true;
        }
        for (LngClass p : ((ClassContext)lngClass.context()).parents()) {
            if (!IsType.isType(p, type)) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (Package p : Package.getPackages()) {
            if (!p.getName().startsWith("java.")) continue;
            list.add((CallSite)((Object)(p.getName() + ".")));
        }
        packages = (String[])list.toArray(String[]::new);
    }
}

