/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.builtins.functions.Jsonify;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import java.lang.runtime.SwitchBootstraps;

public class JsonifyBeauty
implements TuriFunction {
    @Override
    public String name() {
        return "jsonify_beauty";
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        FunUtils.ArgumentsHolder args = FunUtils.args(this.name(), arguments, Object.class, FunUtils.ArgumentsHolder.optional(Long.class), FunUtils.ArgumentsHolder.optional(Long.class));
        return JsonifyBeauty.jsonify(args.at(0).get(), 0, args.at(1).as(Long.class, 4L).intValue(), args.at(2).as(Long.class, 60L).intValue());
    }

    private static String jsonify(Object object, int tab, int tabsize, int margin) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LngObject.class, LngList.class, String.class}, (Object)object2, n)) {
            case 0 -> {
                LngObject lngObject = (LngObject)object2;
                yield JsonifyBeauty.jsonifyObject(lngObject, tab, tabsize, margin);
            }
            case 1 -> {
                LngList lngList = (LngList)object2;
                yield JsonifyBeauty.jsonifyList(lngList, tab, tabsize, margin);
            }
            case 2 -> {
                String s = (String)object2;
                yield Jsonify.jsonifyString(s);
            }
            case -1 -> JsonifyBeauty.jsonifyNull(tab, tabsize, margin);
            default -> JsonifyBeauty.jsonifyAny(object, tab, tabsize, margin);
        };
    }

    static String jsonifyFlat(Object object) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LngObject.class, LngList.class, String.class}, (Object)object2, n)) {
            case 0 -> {
                LngObject lngObject = (LngObject)object2;
                yield JsonifyBeauty.jsonifyObjectFlat(lngObject);
            }
            case 1 -> {
                LngList lngList = (LngList)object2;
                yield JsonifyBeauty.jsonifyListFlat(lngList);
            }
            case 2 -> {
                String s = (String)object2;
                yield Jsonify.jsonifyString(s);
            }
            case -1 -> "null";
            default -> object.toString();
        };
    }

    private static String spc(int tab) {
        return " ".repeat(tab);
    }

    private static String jsonifyNull(int tab, int tabsize, int margin) {
        return "null";
    }

    private static String jsonifyAny(Object s, int tab, int tabsize, int margin) {
        return s.toString();
    }

    private static String jsonifyList(LngList list, int tab, int tabsize, int margin) {
        String s = JsonifyBeauty.jsonifyListFlat(list);
        if (tab + s.length() < margin) {
            return s;
        }
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        tab += tabsize;
        for (Object element : list) {
            sb.append(sep).append("\n").append(JsonifyBeauty.spc(tab));
            sb.append(JsonifyBeauty.jsonify(element, tab, tabsize, margin));
            sep = ",";
        }
        sb.append("\n");
        sb.append(JsonifyBeauty.spc(tab -= tabsize)).append("]");
        return sb.toString();
    }

    private static String jsonifyListFlat(LngList list) {
        StringBuilder sb = new StringBuilder("[ ");
        String sep = "";
        for (Object element : list) {
            sb.append(sep).append(JsonifyBeauty.jsonifyFlat(element));
            sep = ", ";
        }
        sb.append("]");
        return sb.toString();
    }

    private static String jsonifyObject(LngObject object, int tab, int tabsize, int margin) {
        String s = JsonifyBeauty.jsonifyObjectFlat(object);
        if (tab + s.length() < margin) {
            return s;
        }
        StringBuilder sb = new StringBuilder("{");
        String sep = "";
        tab += tabsize;
        for (String key : object.fields()) {
            sb.append(sep).append("\n").append(JsonifyBeauty.spc(tab));
            sb.append("\"").append(key).append("\": ");
            sb.append(JsonifyBeauty.jsonify(object.getField(key), tab + key.length() + 4, tabsize, margin));
            sep = ",";
        }
        sb.append("\n");
        sb.append(JsonifyBeauty.spc(tab -= tabsize)).append("}");
        return sb.toString();
    }

    private static String jsonifyObjectFlat(LngObject object) {
        StringBuilder sb = new StringBuilder("{");
        String sep = "";
        for (String key : object.fields()) {
            sb.append(sep).append("\"").append(key).append("\": ").append(JsonifyBeauty.jsonifyFlat(object.getField(key)));
            sep = ", ";
        }
        sb.append("}");
        return sb.toString();
    }
}

