/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.commands.Closure;
import ch.turic.commands.FunctionCall;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.Context;
import ch.turic.memory.HasContext;
import ch.turic.memory.HasFields;
import ch.turic.memory.HasIndex;
import ch.turic.memory.LngClass;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class LngObject
implements HasFields,
HasIndex,
HasContext {
    public static final String TO_STRING_METHOD = "to_string";
    final LngClass lngClass;
    final Context context;
    public final AtomicBoolean pinned = new AtomicBoolean(false);

    public LngObject(LngClass lngClass, Context context) {
        this.lngClass = lngClass;
        this.context = context;
    }

    public static LngObject newEmpty(Context context) {
        return new LngObject(null, context.open());
    }

    @Override
    public void setField(String name, Object value) {
        ExecutionException.when(this.pinned.get(), "You cannot change a pinned object", new Object[0]);
        this.context.local(name, value);
    }

    @Override
    public Object getField(String name) throws ExecutionException {
        Object value = this.context.getLocal(name);
        if (value != null) {
            return value;
        }
        if (this.lngClass != null) {
            return this.lngClass.getField(name);
        }
        return null;
    }

    @Override
    public Set<String> fields() {
        return this.context.keys();
    }

    @Override
    public void setIndex(Object index, Object value) throws ExecutionException {
        ExecutionException.when(this.pinned.get(), "You cannot change a pinned object", new Object[0]);
        this.setField(index.toString(), value);
    }

    @Override
    public Object getIndex(Object index) throws ExecutionException {
        return this.getField(index.toString());
    }

    @Override
    public Iterator<Object> iterator() {
        throw new ExecutionException("You cannot iterate over the field values.", new Object[0]);
    }

    @Override
    public Context context() {
        return this.context;
    }

    public LngClass lngClass() {
        return this.lngClass;
    }

    public boolean instanceOf(LngClass lngClass) {
        if (lngClass == null) {
            return true;
        }
        return this.lngClass.assignableTo(lngClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LngObject lngObject = (LngObject)o;
        Object method = this.getField("==");
        if (method instanceof Closure) {
            Context ctx;
            Closure lngEquals = (Closure)method;
            ExecutionException.when(!lngEquals.parameters().fitOperator(), "Operator methods must have exactly one argument", new Object[0]);
            FunctionCall.ArgumentEvaluated[] argValues = new FunctionCall.ArgumentEvaluated[]{new FunctionCall.ArgumentEvaluated(null, o)};
            if (lngEquals.wrapped() == null) {
                ctx = this.context.wrap(this.context());
            } else {
                ctx = this.context.wrap(lngEquals.wrapped());
                ctx.let0("this", this);
                ctx.let0("cls", this.lngClass);
            }
            FunctionCall.freezeThisAndCls(ctx);
            FunctionCall.defineArgumentsInContext(ctx, this.context, lngEquals.parameters(), argValues, true);
            return Cast.toBoolean(lngEquals.execute(ctx));
        }
        if (!Objects.equals(this.lngClass, lngObject.lngClass)) {
            return false;
        }
        IdentityHashMap compared = new IdentityHashMap();
        HashSet<String> allKeys = new HashSet<String>(this.context.keys());
        allKeys.addAll(lngObject.fields());
        compared.put(lngObject, null);
        compared.put(this, null);
        for (String key : allKeys) {
            Object thisField = this.getField(key);
            Object thatField = lngObject.getField(key);
            if (!(compared.containsKey(thisField) || compared.containsKey(thatField) || Objects.equals(thisField, thatField))) {
                return false;
            }
            compared.put(thisField, null);
            compared.put(thatField, null);
        }
        return true;
    }

    public int hashCode() {
        return this.computeHashCode(new IdentityHashMap<Object, Boolean>());
    }

    private int computeHashCode(Map<Object, Boolean> visited) {
        if (visited.containsKey(this)) {
            return 0;
        }
        visited.put(this, true);
        int result = Objects.hashCode(this.lngClass);
        for (String key : this.context.keys()) {
            int fieldHash;
            if ("==".equals(key)) continue;
            Object value = this.getField(key);
            if (visited.containsKey(value)) {
                fieldHash = 0;
            } else if (value instanceof LngObject) {
                LngObject obj = (LngObject)value;
                fieldHash = obj.computeHashCode(visited);
            } else {
                fieldHash = Objects.hashCode(value);
            }
            result = 31 * result + fieldHash;
        }
        return result;
    }

    public String toString() {
        Object to_string = this.getField(TO_STRING_METHOD);
        if (to_string == null) {
            StringBuilder builder = new StringBuilder("{");
            String sep = "";
            try {
                for (String key : this.context().keys()) {
                    Object object = this.context().get(key);
                    if (object == this) continue;
                    builder.append(sep).append(key).append(": ").append(object);
                    sep = ", ";
                }
                builder.append("}");
                return builder.toString();
            }
            catch (ConcurrentModificationException cme) {
                throw new ExecutionException(cme, "ConcurrentModification exception while to_string() the object.");
            }
        }
        if (!(to_string instanceof Closure)) {
            throw new ExecutionException("output handler does not have '%s()' method", TO_STRING_METHOD);
        }
        Closure closure = (Closure)to_string;
        return Objects.requireNonNullElse(closure.callAsMethod(this.context, this, TO_STRING_METHOD, new Object[0]), "none").toString();
    }
}

