/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CmdParser {
    private final Map<String, String> keys = new HashMap<String, String>();
    private final List<String> values = new ArrayList<String>();

    public static CmdParser parse(String[] parts, Set<String> parameters) {
        CmdParser it = new CmdParser();
        for (String part : parts) {
            boolean partIsKey = false;
            while (part.startsWith("-")) {
                part = part.substring(1);
                partIsKey = true;
            }
            int eq = part.indexOf("=");
            if (eq == -1) {
                if (part.isEmpty()) continue;
                if (partIsKey) {
                    it.keys.put(CmdParser.findIt(part, parameters), "true");
                    continue;
                }
                it.values.add(part);
                continue;
            }
            String key = part.substring(0, eq);
            String value = part.substring(eq + 1);
            String realKey = CmdParser.findIt(key, parameters);
            if (it.keys.containsKey(realKey)) {
                throw new IllegalArgumentException("The key " + realKey + " is defined more than once");
            }
            it.keys.put(realKey, value);
        }
        return it;
    }

    private static String findIt(String key, Set<String> set) {
        if (set == null) {
            return key;
        }
        ArrayList<String> commandsFound = new ArrayList<String>();
        for (String s : set) {
            if (!s.toLowerCase().startsWith(key.toLowerCase())) continue;
            commandsFound.add(s);
        }
        if (commandsFound.size() == 1) {
            return (String)commandsFound.getFirst();
        }
        if (commandsFound.isEmpty()) {
            throw new IllegalArgumentException(key + " is not an allowed parameter");
        }
        throw new IllegalArgumentException("Parameter " + key + " is ambiguous. It matches " + String.join((CharSequence)",", commandsFound) + ".");
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.keys.get(key));
    }

    public Optional<String> get(int i) {
        if (i < this.values.size()) {
            return Optional.ofNullable(this.values.get(i));
        }
        return Optional.empty();
    }
}

