/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.ExecutionException;
import ch.turic.analyzer.Pos;
import ch.turic.memory.HasFields;
import java.util.Set;

public class Lex
implements HasFields {
    Type type;
    String text;
    final Pos position;
    boolean atLineStart;
    public final boolean interpolated;

    public Pos position() {
        return this.position;
    }

    public boolean atLineStart() {
        return this.atLineStart;
    }

    public String text() {
        return this.text;
    }

    public Type type() {
        return this.type;
    }

    public Lex(Type type, String text, boolean atLineStart, Pos position, boolean interpolated) {
        this.type = type;
        this.text = text;
        this.atLineStart = atLineStart;
        this.position = position.clone();
        this.interpolated = interpolated;
    }

    public Lex(Type type, String text, boolean atLineStart, Pos position) {
        this(type, text, atLineStart, position, false);
    }

    public String toString() {
        return String.format("Lex{types=%s, text='%s'}", new Object[]{this.type, this.text});
    }

    @Override
    public void setField(String name, Object value) throws ExecutionException {
        switch (name) {
            case "type": {
                this.type = (Type)((Object)value);
                break;
            }
            case "text": {
                this.text = (String)value;
                break;
            }
            case "atLineStart": {
                this.atLineStart = (Boolean)value;
                break;
            }
            default: {
                throw new ExecutionException("Unknown field: " + name, new Object[0]);
            }
        }
    }

    @Override
    public Object getField(String name) throws ExecutionException {
        return switch (name) {
            case "type" -> this.type;
            case "text" -> this.text;
            case "atLineStart" -> Boolean.valueOf(this.atLineStart);
            default -> throw new ExecutionException("Unknown field: " + name, new Object[0]);
        };
    }

    @Override
    public Set<String> fields() {
        return Set.of("type", "text", "atLineStart");
    }

    public boolean is(String ... textAlternatives) {
        if (this.type != Type.RESERVED) {
            return false;
        }
        for (String s : textAlternatives) {
            if (!this.text().equals(s)) continue;
            return true;
        }
        return false;
    }

    public static enum Type {
        IDENTIFIER,
        RESERVED,
        STRING,
        INTEGER,
        FLOAT;

    }
}

