/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.classes;

import ch.turic.ExecutionException;
import ch.turic.LngCallable;
import ch.turic.TuriClass;
import ch.turic.builtins.classes.TuriMethod;
import ch.turic.commands.operators.Cast;

public class TuriLong
implements TuriClass {
    @Override
    public Class<?> forClass() {
        return Long.class;
    }

    @Override
    public LngCallable getMethod(Object target, String identifier) {
        if (!(target instanceof Long)) {
            throw new ExecutionException("Wrong target type, need Long, probably internal error", new Object[0]);
        }
        Long num = (Long)target;
        return switch (identifier) {
            case "to_string" -> new TuriMethod<String>(args -> String.format("%s", num));
            case "times" -> new TuriMethod<Object>(args -> this.times(num, args[0]));
            case "hex" -> new TuriMethod<String>(args -> String.format("0x%X", num));
            default -> null;
        };
    }

    private Object times(Long num, Object arg) {
        if (Cast.isLong(arg)) {
            return Cast.toLong(arg) * Cast.toLong(num);
        }
        if (Cast.isDouble(arg)) {
            return Cast.toDouble(arg) * Cast.toDouble(num);
        }
        return arg.toString().repeat(Cast.toLong(num).intValue());
    }
}

