/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.memory.LngList;
import java.util.Optional;

public class Glob
implements TuriFunction {
    @Override
    public String name() {
        return "_glob";
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        FunUtils.ArgumentsHolder args = FunUtils.args(this.name(), arguments, String.class, FunUtils.ArgumentsHolder.optional(String.class), Boolean.class);
        Object pattern = args.at(0).as(String.class);
        Optional<String> pathOpt = args.at(1).optional(String.class);
        Boolean recursive = args.at(2).as(Boolean.class);
        if (pathOpt.isPresent()) {
            Object path = pathOpt.get();
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            pattern = (String)path + (String)pattern;
        }
        LngList result = new LngList();
        try {
            result.addAll(ch.turic.utils.Glob.glob((String)pattern, recursive));
        }
        catch (Exception e) {
            throw new ExecutionException(e, "Error, while globbing file names in glob(): '" + e.getMessage() + "'");
        }
        return result;
    }
}

