/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JavaMethodCall
implements TuriFunction {
    @Override
    public String name() {
        return "java_call";
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        FunUtils.ArgumentsHolder args = FunUtils.args(this.name(), arguments, Object.class, String.class, Object[].class);
        String methodName = args.at(1).as(String.class);
        Tuple tuple = JavaMethodCall.getKlassAndObject(args);
        Class<?> klass = tuple.klass();
        Object object = tuple.object();
        for (Method method : klass.getMethods()) {
            if (!method.getName().equals(methodName) || method.isSynthetic() || (method.isVarArgs() ? method.getParameterCount() <= args.N - 2 : method.getParameterCount() != args.N - 2)) continue;
            int i = 2;
            if (method.isVarArgs()) {
                Class<?> pType;
                int j = 0;
                while (j < method.getParameterTypes().length - 1 && (pType = method.getParameterTypes()[j]).isAssignableFrom(args.at((int)i).type)) {
                    ++j;
                    ++i;
                }
                TypeDescriptor.OfField lastPType = method.getParameterTypes()[method.getParameterTypes().length - 1].arrayType();
                while (i < args.N && ((Class)lastPType).isAssignableFrom(args.at((int)i).type)) {
                    ++i;
                }
            } else {
                for (Class<?> pType : method.getParameterTypes()) {
                    if (!JavaMethodCall.isAssignable(pType, args.at(i).get())) break;
                    ++i;
                }
            }
            if (i != args.N) continue;
            try {
                if (method.isVarArgs()) {
                    Object[] javaArgs = new Object[method.getParameterCount()];
                    int k = 2;
                    int h = 0;
                    while (h < method.getParameterCount() - 1) {
                        javaArgs[h++] = args.at(k++).get();
                    }
                    Class<?> varargComponentType = method.getParameterTypes()[method.getParameterCount() - 1].getComponentType();
                    Object varargs = Array.newInstance(varargComponentType, args.N - k);
                    int v = 0;
                    while (k < args.N) {
                        Array.set(varargs, v, args.at(k).get());
                        ++k;
                        ++v;
                    }
                    javaArgs[h] = varargs;
                    return method.invoke(object, javaArgs);
                }
                Object[] ajavArgs = args.tail(2);
                return method.invoke(object, ajavArgs);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                throw new ExecutionException(cause, "Exception while executing method call '" + methodName + "'", new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ExecutionException("Cannot invoke method '" + methodName + "'.", new Object[]{e});
            }
        }
        throw new ExecutionException("Cannot find method '" + methodName + "'.", new Object[0]);
    }

    private static boolean isAssignable(Class<?> parameterType, Object arg) {
        if (arg == null) {
            return !parameterType.isPrimitive();
        }
        Class<?> argClass = arg.getClass();
        if (parameterType.isPrimitive()) {
            return switch (parameterType.getName()) {
                case "boolean" -> {
                    if (argClass == Boolean.class) {
                        yield true;
                    }
                    yield false;
                }
                case "byte" -> {
                    if (argClass == Byte.class) {
                        yield true;
                    }
                    yield false;
                }
                case "char" -> {
                    if (argClass == Character.class) {
                        yield true;
                    }
                    yield false;
                }
                case "short" -> {
                    if (argClass == Short.class) {
                        yield true;
                    }
                    yield false;
                }
                case "int" -> {
                    if (argClass == Integer.class) {
                        yield true;
                    }
                    yield false;
                }
                case "long" -> {
                    if (argClass == Long.class) {
                        yield true;
                    }
                    yield false;
                }
                case "float" -> {
                    if (argClass == Float.class) {
                        yield true;
                    }
                    yield false;
                }
                case "double" -> {
                    if (argClass == Double.class) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return parameterType.isAssignableFrom(argClass);
    }

    static Tuple getKlassAndObject(FunUtils.ArgumentsHolder args) throws ExecutionException {
        Object object;
        Class<?> klass;
        if (args.at(0).is_a(String.class)) {
            String className = args.at(0).as(String.class);
            try {
                klass = Class.forName(className);
                object = null;
            }
            catch (ClassNotFoundException ex) {
                throw new ExecutionException("Cannot find class '" + className + "'.", new Object[]{ex});
            }
        } else {
            object = args.at(0).get();
            klass = object.getClass();
        }
        return new Tuple(klass, object);
    }

    record Tuple(Class<?> klass, Object object) {
    }
}

