/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlFormat
implements TuriFunction {
    private static final ErrorHandler SILENT_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };

    @Override
    public String name() {
        return "xml_format";
    }

    @Override
    public Object call(Context context, Object[] arguments) throws ExecutionException {
        ch.turic.memory.Context ctx = FunUtils.ctx(context);
        Object arg = FunUtils.arg(this.name(), arguments);
        String input = String.valueOf(arg);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(SILENT_HANDLER);
            Document doc = db.parse(new InputSource(new StringReader(input)));
            return XmlFormat.formatDocument(doc, 4);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new ExecutionException("There was an XML exception formatting XML", new Object[]{e});
        }
    }

    public static String formatDocument(Document doc, int tabsize) throws TransformerException {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "" + tabsize);
        StringWriter out = new StringWriter();
        XmlFormat.trimDocument(doc);
        tf.transform(new DOMSource(doc), new StreamResult(out));
        return ((Object)out).toString();
    }

    private static void trimDocument(Document doc) {
        Element root = doc.getDocumentElement();
        XmlFormat.trimNode(root);
    }

    private static void trimNode(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                if (!child.getTextContent().trim().isEmpty()) continue;
                child.setTextContent("");
                continue;
            }
            XmlFormat.trimNode(child);
        }
    }
}

