/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.Closure;
import ch.turic.commands.FunctionCall;
import ch.turic.commands.Macro;
import ch.turic.commands.ParameterList;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.LngClass;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import ch.turic.utils.NullableOptional;
import java.util.Set;

public sealed interface ClosureOrMacro
extends Command,
HasFields
permits Closure, Macro {
    public static final Set<String> SPECIAL_VARIABLES = Set.of("this", "cls", "me", "it", ".");

    private static Context prepareListContext(Context context, String methodName, LngList lngList, FunctionCall.ArgumentEvaluated[] argValues, ClosureOrMacro it) {
        Context ctx;
        HasFields fp = lngList.getFieldProvider();
        if (fp instanceof LngObject) {
            LngObject lngObject = (LngObject)fp;
            ctx = ClosureOrMacro.prepareObjectContext(context, lngObject, methodName, argValues, it);
        } else if (fp instanceof LngClass) {
            LngClass lngClass = (LngClass)fp;
            ctx = ClosureOrMacro.getClassContext(context, methodName, lngClass, argValues, it);
        } else {
            throw new ExecutionException("List field provider is neither object nor class", new Object[0]);
        }
        ctx.let0("it", lngList);
        return ctx;
    }

    private static Context prepareObjectContext(Context context, LngObject lngObject, String methodName, FunctionCall.ArgumentEvaluated[] argValues, ClosureOrMacro it) {
        Context ctx = it.wrapped() == null ? context.wrap(lngObject.context()) : context.wrap(it.wrapped());
        ctx.let0("this", lngObject);
        ctx.let0("cls", lngObject.lngClass());
        ctx.let0(".", methodName);
        ctx.setCaller(context);
        FunctionCall.freezeThisAndCls(ctx);
        ctx.freeze(".");
        FunctionCall.defineArgumentsInContext(ctx, context, it.parameters(), argValues, true);
        return ctx;
    }

    private static Context getClassContext(Context context, String methodName, LngClass lngClass, FunctionCall.ArgumentEvaluated[] argValues, ClosureOrMacro it) {
        Context ctx = context.wrap(lngClass.context());
        ctx.let0(".", methodName);
        ctx.freeze(".");
        if ("init".equals(methodName)) {
            ctx.let0("this", context.getLocal("this"));
            ctx.let0("cls", lngClass);
            FunctionCall.freezeThisAndCls(ctx);
            FunctionCall.defineArgumentsInContext(ctx, context, it.parameters(), argValues, false);
        } else {
            FunctionCall.defineArgumentsInContext(ctx, context, it.parameters(), argValues, true);
        }
        return ctx;
    }

    public static NullableOptional<Object> callTheMethod(Context context, HasFields obj, String methodName, FunctionCall.ArgumentEvaluated[] argValues, ClosureOrMacro it) {
        LngList lngList;
        if (obj instanceof LngObject) {
            LngObject lngObject = (LngObject)obj;
            Context ctx = ClosureOrMacro.prepareObjectContext(context, lngObject, methodName, argValues, it);
            return NullableOptional.of(it.execute(ctx));
        }
        if (obj instanceof LngList && (lngList = (LngList)obj).hasFieldProvider()) {
            Context ctx = ClosureOrMacro.prepareListContext(context, methodName, lngList, argValues, it);
            return NullableOptional.of(it.execute(ctx));
        }
        if (obj instanceof LngClass) {
            LngClass lngClass = (LngClass)obj;
            Context ctx = ClosureOrMacro.getClassContext(context, methodName, lngClass, argValues, it);
            if (methodName.equals("init") && context.containsLocal("this")) {
                Object resultObject = it.execute(ctx);
                context.mergeVariablesFrom(ctx, SPECIAL_VARIABLES);
                return NullableOptional.of(resultObject);
            }
            return NullableOptional.of(it.execute(ctx));
        }
        return NullableOptional.empty();
    }

    public ParameterList parameters();

    public Context wrapped();

    public NullableOptional<Object> methodCall(Context var1, HasFields var2, String var3, FunctionCall.Argument[] var4);

    public FunctionCall.ArgumentEvaluated[] evaluateArguments(Context var1, FunctionCall.Argument[] var2);

    public String name();

    @Override
    default public void setField(String name, Object value) throws ExecutionException {
        throw new ExecutionException("You cannot set fields of a closure or a macro", new Object[0]);
    }

    @Override
    default public Set<String> fields() {
        return Set.of("name");
    }

    @Override
    default public Object getField(String name) throws ExecutionException {
        switch (name) {
            case "name": {
                break;
            }
            default: {
                throw new ExecutionException("You cannot get field '%s' of a closure or a macro.", name);
            }
        }
        return this.name();
    }
}

