/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.LngCallable;
import ch.turic.TuriClass;
import ch.turic.builtins.classes.TuriNone;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Closure;
import ch.turic.commands.ClosureOrMacro;
import ch.turic.commands.FieldAccess;
import ch.turic.commands.Identifier;
import ch.turic.commands.Macro;
import ch.turic.commands.ParameterList;
import ch.turic.commands.TypeDeclaration;
import ch.turic.memory.AsyncStreamHandler;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.JavaObject;
import ch.turic.memory.LeftValue;
import ch.turic.memory.LngClass;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import ch.turic.memory.Spread;
import ch.turic.utils.NullableOptional;
import ch.turic.utils.Unmarshaller;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Iterator;

public class FunctionCall
extends AbstractCommand {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public final Command object;
    public final Argument[] arguments;

    public Argument[] arguments() {
        return this.arguments;
    }

    public Command object() {
        return this.object;
    }

    public FunctionCall(Command object, Argument[] arguments) {
        this.arguments = arguments;
        this.object = object;
    }

    public static FunctionCall factory(Unmarshaller.Args args) {
        return new FunctionCall(args.command("object"), args.get("arguments", Argument[].class));
    }

    @Override
    public Object _execute(Context context) throws ExecutionException {
        Command myObject = this.myFunctionObject(context);
        if (myObject instanceof FieldAccess) {
            LngCallable callable;
            ClosureOrMacro command;
            NullableOptional<Object> nullableOptionalResult;
            FieldAccess fieldAccess = (FieldAccess)myObject;
            HasFields obj = LeftValue.toObject(fieldAccess.object().execute(context));
            Object function = FunctionCall.getMethod(context, obj, fieldAccess.identifier());
            if (function instanceof ClosureOrMacro && (nullableOptionalResult = (command = (ClosureOrMacro)function).methodCall(context, obj, fieldAccess.identifier(), this.arguments())).isPresent()) {
                return nullableOptionalResult.get();
            }
            if (function instanceof LngClass) {
                LngClass lngClass = (LngClass)function;
                return lngClass.newInstance(obj, context, this.arguments);
            }
            if (function instanceof LngCallable.LngCallableClosure) {
                callable = (LngCallable.LngCallableClosure)function;
                return callable.call(context, this.bareValues(Closure.evaluateClosureArguments(context, this.arguments)));
            }
            if (function instanceof LngCallable.LngCallableMacro) {
                callable = (LngCallable.LngCallableMacro)function;
                return callable.call(context, this.bareValues(Macro.evaluateMacroArguments(context, this.arguments)));
            }
            throw new ExecutionException("It is not possible to invoke %s.%s() as %s.%s()", obj, function, fieldAccess.object(), fieldAccess.identifier());
        }
        Object function = myObject.execute(context);
        if (function instanceof ClosureOrMacro) {
            ClosureOrMacro command = (ClosureOrMacro)function;
            ArgumentEvaluated[] argValues = command.evaluateArguments(context, this.arguments);
            Context ctx = context.wrap(command.wrapped());
            ctx.setCaller(context);
            ctx.let0("me", function);
            ctx.freeze("me");
            ctx.let0(".", command.name());
            ctx.freeze(".");
            FunctionCall.defineArgumentsInContext(ctx, context, command.parameters(), argValues, true);
            return command.execute(ctx);
        }
        if (function instanceof LngClass) {
            LngClass lngClass = (LngClass)function;
            return lngClass.newInstance(null, context, this.arguments);
        }
        if (function instanceof LngCallable.LngCallableClosure) {
            LngCallable.LngCallableClosure callable = (LngCallable.LngCallableClosure)function;
            return callable.call(context, this.bareValues(Closure.evaluateClosureArguments(context, this.arguments)));
        }
        if (function instanceof LngCallable.LngCallableMacro) {
            LngCallable.LngCallableMacro callable = (LngCallable.LngCallableMacro)function;
            return callable.call(context, this.bareValues(Macro.evaluateMacroArguments(context, this.arguments)));
        }
        throw new ExecutionException("It is not possible to invoke '%s' because its value is '%s' and not something I can invoke.It is a f5g %s", this.object, function, function == null ? "null" : function.getClass().getName());
    }

    private Object[] bareValues(ArgumentEvaluated[] arguments) {
        Object[] result = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            result[i] = arguments[i].value;
        }
        return result;
    }

    public static void defineArgumentsInContext(Context ctx, Context callerContext, ParameterList pList, ArgumentEvaluated[] argValues, boolean freeze) {
        int i;
        boolean[] filled = new boolean[pList.parameters().length];
        LngList rest = new LngList();
        LngObject meta = LngObject.newEmpty(ctx);
        Object closure = null;
        for (i = 0; i < argValues.length; ++i) {
            ArgumentEvaluated arg = argValues[i];
            if (i == argValues.length - 1 && pList.closure() != null && arg.id() == null) {
                boolean allMadatoryPositionalsDone = true;
                for (int j = 0; j < pList.parameters().length; ++j) {
                    if (pList.parameters()[j].type() == ParameterList.Parameter.Type.NAMED_ONLY) continue;
                    allMadatoryPositionalsDone = allMadatoryPositionalsDone && filled[j];
                }
                if (allMadatoryPositionalsDone) {
                    closure = arg.value;
                    break;
                }
            }
            if (argValues[i].id == null) {
                FunctionCall.addPositionalParameter(ctx, pList, arg, rest, meta, filled, freeze);
                continue;
            }
            FunctionCall.addNamedParameter(ctx, pList, arg, meta, filled, false);
        }
        for (i = 0; i < pList.parameters().length; ++i) {
            if (filled[i]) continue;
            ParameterList.Parameter parameter = pList.parameters()[i];
            if (parameter.defaultExpression() == null) {
                throw new ExecutionException("Parameter '%s' is not defined", parameter.identifier());
            }
            Object value = parameter.defaultExpression().execute(callerContext);
            ctx.defineTypeChecked(parameter.identifier(), value, FunctionCall.calculateTypeNames(ctx, parameter.types()));
            if (!freeze) continue;
            ctx.freeze(parameter.identifier());
        }
        if (pList.rest() != null) {
            ctx.let0(pList.rest(), rest);
            if (freeze) {
                ctx.freeze(pList.rest());
            }
        }
        if (pList.meta() != null) {
            ctx.let0(pList.meta(), meta);
            if (freeze) {
                ctx.freeze(pList.meta());
            }
        }
        if (pList.closure() != null) {
            ctx.let0(pList.closure(), closure);
            if (freeze) {
                ctx.freeze(pList.closure());
            }
        }
    }

    private static void addNamedParameter(Context ctx, ParameterList pList, ArgumentEvaluated argValue, LngObject meta, boolean[] filled, boolean lenient) {
        if (argValue.value instanceof Spread) {
            throw new ExecutionException("Named argument cannot be spread", new Object[0]);
        }
        for (int j = 0; j < pList.parameters().length; ++j) {
            ParameterList.Parameter parameter = pList.parameters()[j];
            if (!parameter.identifier().equals(argValue.id.name())) continue;
            if (parameter.type() == ParameterList.Parameter.Type.POSITIONAL_ONLY) {
                if (pList.meta() != null) {
                    meta.setField(argValue.id.name(), argValue.value);
                    return;
                }
                throw new ExecutionException("The parameter '%s' is positional only, specified by name and there is no {meta} parameter.", parameter.identifier());
            }
            if (filled[j]) {
                throw new ExecutionException("Parameter '%s' is already defined", argValue.id.name());
            }
            filled[j] = true;
            ctx.defineTypeChecked(parameter.identifier(), argValue.value, FunctionCall.calculateTypeNames(ctx, parameter.types()));
            return;
        }
        if (pList.meta() != null) {
            meta.setField(argValue.id.name(), argValue.value);
            return;
        }
        if (!lenient) {
            throw new ExecutionException("The parameter '%s' is not defined and there is no {meta} parameter", argValue.id.name());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addPositionalParameter(Context ctx, ParameterList pList, ArgumentEvaluated argValue, LngList rest, LngObject meta, boolean[] filled, boolean freeze) {
        Object object = argValue.value;
        if (object instanceof Spread) {
            int n;
            Object list;
            Spread spread = (Spread)object;
            try {
                Object object2;
                object = list = (object2 = spread.array());
                n = 0;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            block7: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HasFields.class, Iterable.class}, (Object)object, n)) {
                    case -1: {
                        return;
                    }
                    case 0: {
                        HasFields it = (HasFields)object;
                        if (list instanceof LngList || list instanceof AsyncStreamHandler) {
                            n = 1;
                            continue block7;
                        }
                        Iterator<String> iterator = it.fields().iterator();
                        while (iterator.hasNext()) {
                            String name = iterator.next();
                            Object value = it.getField(name);
                            FunctionCall.addNamedParameter(ctx, pList, new ArgumentEvaluated(new Identifier(name), value), meta, filled, true);
                        }
                        return;
                    }
                    case 1: {
                        Iterable it = (Iterable)object;
                        Iterator iterator = it.iterator();
                        while (iterator.hasNext()) {
                            Object o = iterator.next();
                            FunctionCall.addPositionalParameter(ctx, pList, new ArgumentEvaluated(null, o), rest, meta, filled, freeze);
                        }
                        return;
                    }
                }
                break;
            }
            throw new ExecutionException("You can only spread objects and lists, not '%s'", list);
        }
        int index = 0;
        while (true) {
            if (index >= pList.parameters().length) {
                if (pList.rest() == null) {
                    throw new ExecutionException("Too many parameters and there is no [rest] specified", new Object[0]);
                }
                rest.array.add(argValue.value);
                return;
            }
            if (pList.parameters()[index].type() != ParameterList.Parameter.Type.NAMED_ONLY && !filled[index]) {
                String id = pList.parameters()[index].identifier();
                ctx.defineTypeChecked(id, argValue.value, FunctionCall.calculateTypeNames(ctx, pList.parameters()[index].types()));
                if (freeze) {
                    ctx.freeze(id);
                }
                filled[index] = true;
                return;
            }
            ++index;
        }
    }

    public static void freezeThisAndCls(Context ctx) {
        if (ctx.contains("this")) {
            ctx.freeze("this");
        }
        FunctionCall.freezeCls(ctx);
    }

    public static void freezeCls(Context ctx) {
        if (ctx.contains("cls")) {
            ctx.freeze("cls");
        }
    }

    private static Object getMethod(Context context, HasFields obj, String identifier) {
        HasFields hasFields = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JavaObject.class}, (Object)hasFields, n)) {
            case -1 -> null;
            case 0 -> {
                JavaObject jo = (JavaObject)hasFields;
                if (jo.object() == null) {
                    yield TuriNone.INSTANCE.getMethod(null, identifier);
                }
                TuriClass turi = FunctionCall.getTuriClass(context, jo);
                if (turi != null) {
                    yield turi.getMethod(jo.object(), identifier);
                }
                yield jo.getField(identifier);
            }
            default -> {
                Object method = obj.getField(identifier);
                if (method == null) {
                    yield obj.getField(".");
                }
                yield method;
            }
        };
    }

    public static TuriClass getTuriClass(Context context, JavaObject jo) {
        TuriClass turi = context.globalContext.getTuriClass(jo.object().getClass());
        if (turi == null) {
            for (Class<?> papi = jo.object().getClass(); papi != null && (turi = context.globalContext.getTuriClass(papi)) == null; papi = papi.getSuperclass()) {
                Class<?> face;
                Class<?>[] classArray = papi.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (turi = context.globalContext.getTuriClass(face = classArray[i])) == null; ++i) {
                }
                if (turi != null) break;
            }
        }
        return turi;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Command myFunctionObject(Context context) {
        LngObject lngObject;
        Object clsObject;
        Command command = this.object;
        if (!(command instanceof Identifier)) return this.object;
        Identifier id = (Identifier)command;
        if (!context.contains("this")) {
            if (!context.contains("cls")) return this.object;
        }
        Object thisObject = context.contains("this") ? context.get("this") : null;
        Object object = clsObject = context.contains("cls") ? context.get("cls") : null;
        if (thisObject instanceof LngObject && (lngObject = (LngObject)thisObject).context().containsLocal(id.name())) {
            return new FieldAccess(new Identifier("this"), id.name(), false);
        }
        if (!(clsObject instanceof LngClass)) return this.object;
        LngClass lngClass = (LngClass)clsObject;
        if (!lngClass.context().containsLocal(id.name())) return this.object;
        return new FieldAccess(new Identifier("cls"), id.name(), false);
    }

    public static String[] calculateTypeNames(Context ctx, TypeDeclaration[] types) {
        if (types != null) {
            return (String[])Arrays.stream(types).map(t -> t.calculateTypeName(ctx)).toArray(String[]::new);
        }
        return EMPTY_STRING_ARRAY;
    }

    public record Argument(Identifier id, Command expression) {
        public static Argument factory(Unmarshaller.Args args) {
            return new Argument(args.get("id", Identifier.class), args.command("expression"));
        }
    }

    public record ArgumentEvaluated(Identifier id, Object value) {
    }
}

