/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Closure;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.Context;
import ch.turic.memory.LeftValue;
import ch.turic.memory.LngObject;
import ch.turic.utils.Unmarshaller;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class IncrementDecrement
extends AbstractCommand {
    final LeftValue leftValue;
    final boolean increment;
    final boolean post;

    public static IncrementDecrement factory(Unmarshaller.Args args) {
        return new IncrementDecrement(args.get("leftValue", LeftValue.class), args.bool("increment"), args.bool("post"));
    }

    public IncrementDecrement(LeftValue leftValue, boolean increment, boolean post) {
        this.leftValue = leftValue;
        this.increment = increment;
        this.post = post;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        ctx.step();
        AtomicReference result = new AtomicReference();
        Function<Object, Object> converter = this.increment ? x -> this.applyDelta(ctx, x, result, 1) : x -> this.applyDelta(ctx, x, result, -1);
        Object newValue = this.leftValue.reassign(ctx, converter);
        Object oldValue = result.get();
        return this.post ? oldValue : newValue;
    }

    private Object applyDelta(Context ctx, Object value, AtomicReference<Object> result, int delta) throws ExecutionException {
        LngObject lngObject;
        Object method;
        String operator;
        result.set(value);
        if (Cast.isLong(value)) {
            return Cast.toLong(value) + (long)delta;
        }
        if (Cast.isDouble(value)) {
            return Cast.toDouble(value) + (double)delta;
        }
        String string = operator = delta > 0 ? "++" : "--";
        if (value instanceof LngObject && (method = (lngObject = (LngObject)value).getField(operator)) != null) {
            if (!(method instanceof Closure)) {
                throw new ExecutionException(String.format("%s is not a valid %s operator", method, operator), new Object[0]);
            }
            Closure operation = (Closure)method;
            return operation.callAsMethod(ctx, lngObject, operator, new Object[0]);
        }
        throw new ExecutionException("Cannot apply operator %s on value '%s'", operator, value);
    }
}

