/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.operators.AbstractOperator;
import ch.turic.commands.operators.Cast;
import ch.turic.commands.operators.Operator;
import ch.turic.memory.Context;
import ch.turic.memory.LngList;

@Operator.Symbol(value=">>")
public class ShiftRight
extends AbstractOperator {
    private static double shr(double value, double shiftAmount) {
        long shift = Cast.toLong(shiftAmount);
        if (shift < 0L) {
            throw new ExecutionException("Shift amount must be non-negative", new Object[0]);
        }
        double factor = 1.0;
        double powerOfTwo = 2.0;
        while (shift != 0L) {
            if ((shift & 1L) != 0L) {
                factor *= powerOfTwo;
            }
            powerOfTwo *= powerOfTwo;
            shift >>= 1;
        }
        return value / factor;
    }

    @Override
    public Object binaryOp(Context ctx, Object op1, Command right) throws ExecutionException {
        Object op2 = right.execute(ctx);
        if (op1 instanceof CharSequence) {
            CharSequence s1 = (CharSequence)op1;
            String s2 = op2.toString();
            int len = Math.max(s1.length(), s2.length());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i < s1.length()) {
                    sb.append(s1.charAt(i));
                }
                if (i >= s2.length()) continue;
                sb.append(s2.charAt(i));
            }
            return sb.toString();
        }
        if (op1 instanceof LngList) {
            LngList list1 = (LngList)op1;
            if (op2 instanceof LngList) {
                LngList list2 = (LngList)op2;
                int len = Math.max(list1.array.size(), list2.array.size());
                LngList result = new LngList(list1.getFieldProvider());
                for (int i = 0; i < len; ++i) {
                    if (i < list1.array.size()) {
                        result.array.add(list1.array.get(i));
                    }
                    if (i >= list2.array.size()) continue;
                    result.array.add(list2.array.get(i));
                }
                return result;
            }
        }
        return this.binary("shr", op1, op2, (a, b) -> a >> (int)b.longValue(), ShiftRight::shr);
    }
}

