/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.builtins.classes.TuriMethod;
import ch.turic.memory.BlockingQueueChannel;
import ch.turic.memory.Channel;
import ch.turic.memory.HasFields;
import ch.turic.memory.NameGen;
import ch.turic.memory.Yielder;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncStreamHandler
extends CompletableFuture<Object>
implements Yielder,
AutoCloseable,
Iterable<Object>,
Future<Object>,
HasFields {
    private final BlockingQueueChannel<Object> toChildQueue;
    private final BlockingQueueChannel<Object> toParentQueue;
    private final Iterator<Object> parentIterator;
    private String name;
    private CompletableFuture<Channel.Message<?>> future;

    public CompletableFuture<Channel.Message<?>> future() {
        return this.future;
    }

    public AsyncStreamHandler(int outQueueSize, int inQueueSize) {
        this.toChildQueue = new BlockingQueueChannel(outQueueSize);
        this.toParentQueue = new BlockingQueueChannel(inQueueSize);
        this.parentIterator = this.toParentQueue.iterator();
        this.name = NameGen.generateName();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.toParent().iterator();
    }

    public Channel<Object> toChild() {
        return this.toChildQueue;
    }

    public Channel<Object> toParent() {
        return this.toParentQueue;
    }

    @Override
    public void close() {
        this.toParent().close();
        this.toChild().close();
    }

    public void setFuture(CompletableFuture<Channel.Message<?>> future) {
        this.future = future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public Channel.Message<?> get() throws ExecutionException {
        try {
            return this.future.get();
        }
        catch (CancellationException ce) {
            throw new ExecutionException("Task stopped.", new Object[0]);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public Channel.Message<?> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.future.get(timeout, unit);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public void setField(String name, Object value) throws ExecutionException {
        throw new ExecutionException("You cannot set a field on an asynch object", new Object[0]);
    }

    @Override
    public Object getField(String name) throws ExecutionException {
        return switch (name) {
            case "name" -> new TuriMethod<String>(() -> this.name);
            case "is_done" -> new TuriMethod<Boolean>(this.future::isDone);
            case "is_cancelled" -> new TuriMethod<Boolean>(this.future::isCancelled);
            case "stop" -> new TuriMethod<Object>(x -> {
                this.future.cancel(true);
                this.toParent().close();
                this.toChild().close();
                return null;
            });
            case "is_err" -> new TuriMethod<Boolean>(() -> {
                try {
                    return this.future.isDone() && this.future.get().isException();
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            });
            case "get_err" -> new TuriMethod<Object>(() -> {
                try {
                    if (this.future.isDone() && this.future.get().isException()) {
                        return this.future.get()._get();
                    }
                    throw new ExecutionException("get_err on a non erring task.", new Object[0]);
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            });
            case "get" -> new TuriMethod<Object>(() -> {
                try {
                    return this.future.get().get();
                }
                catch (InterruptedException | java.util.concurrent.ExecutionException e) {
                    throw new ExecutionException("Execution exception while waiting for thread %s", e.getMessage());
                }
            });
            case "close" -> new TuriMethod<Object>(() -> {
                this.toChild().close();
                return null;
            });
            case "send" -> new TuriMethod<Object>(args -> {
                for (Object arg : args) {
                    this.toChild().send(Channel.Message.of(arg));
                }
                return null;
            });
            case "set_name" -> new TuriMethod<Object>(args -> {
                for (Object arg : args) {
                    this.name = String.valueOf(arg);
                }
                return null;
            });
            case "has_next" -> new TuriMethod<Boolean>(this.parentIterator::hasNext);
            case "next" -> new TuriMethod<Object>(this.parentIterator::next);
            default -> throw new ExecutionException("Unknown method %s", name);
        };
    }

    @Override
    public Set<String> fields() {
        return Set.of();
    }
}

