/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.memory.Channel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public class ChannelIterator<T>
implements Channel<T>,
Iterator<T> {
    private final Channel<T> channel;
    private Channel.Message<T> nextItem;
    private boolean hasNextMessage = true;
    private boolean nextCached = false;

    public ChannelIterator(Channel<T> channel) {
        this.channel = channel;
    }

    @Override
    public void send(Channel.Message<T> message) throws ExecutionException {
        this.channel.send(message);
    }

    @Override
    public boolean trySend(Channel.Message<T> message) throws ExecutionException {
        return this.channel.trySend(message);
    }

    @Override
    public boolean trySend(Channel.Message<T> message, long time, TimeUnit unit) throws ExecutionException {
        return this.channel.trySend(message, time, unit);
    }

    @Override
    public Channel.Message<T> receive() throws ExecutionException {
        return this.channel.receive();
    }

    @Override
    public Channel.Message<T> tryReceive() throws ExecutionException {
        return this.channel.tryReceive();
    }

    @Override
    public Channel.Message<T> tryReceive(long time, TimeUnit unit) throws ExecutionException {
        return this.channel.tryReceive(time, unit);
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public boolean isClosed() {
        return this.channel.isClosed();
    }

    @Override
    public boolean hasNext() {
        if (this.nextCached) {
            return this.hasNextMessage;
        }
        this.nextItem = this.channel.receive();
        this.hasNextMessage = !this.nextItem.isCloseMessage();
        this.nextCached = true;
        return this.hasNextMessage;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Channel has exhausted");
        }
        this.nextCached = false;
        return this.nextItem.get();
    }
}

