/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.HasFields;
import ch.turic.memory.HasIndex;
import ch.turic.memory.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class LngList
implements HasIndex,
HasFields {
    public final ArrayList<Object> array = new ArrayList();
    public final AtomicBoolean pinned = new AtomicBoolean(false);
    private final HasFields fieldProvider;

    public LngList() {
        this(null);
    }

    public LngList(HasFields fieldProvider) {
        this.fieldProvider = fieldProvider;
    }

    public HasFields getFieldProvider() {
        return this.fieldProvider;
    }

    public boolean hasFieldProvider() {
        return this.fieldProvider != null;
    }

    public void add(Object value) {
        this.array.add(value);
    }

    public void addAll(Collection<?> values) {
        this.array.addAll(values);
    }

    @Override
    public void setIndex(Object index, Object value) throws ExecutionException {
        ExecutionException.when(this.pinned.get(), "Cannot change a pinned list.", new Object[0]);
        if (Cast.isLong(index)) {
            int indexValue = Cast.toLong(index).intValue();
            if (indexValue < 0) {
                ExecutionException.when(this.array.size() + indexValue < 0, "Indexing error, %d is too small, %s-%s < %s.", indexValue, this.array.size(), -indexValue, 0);
                this.array.set(this.array.size() + indexValue, value);
                return;
            }
            this.array.ensureCapacity(indexValue + 1);
            while (indexValue >= this.array.size()) {
                this.array.add(null);
            }
            this.array.set(indexValue, value);
            return;
        }
        if (index instanceof Range) {
            ArrayList<Object> result;
            Range range = (Range)index;
            int start = range.getStart(this.array.size());
            int end = range.getEnd(this.array.size());
            if (end < start) {
                throw new ExecutionException("reverse range [%d .. %d] cannot be set.", start, end);
            }
            if (value instanceof Iterable) {
                int i;
                Iterable iterable = (Iterable)value;
                result = new ArrayList<Object>();
                for (i = 0; i < start; ++i) {
                    result.add(this.array.get(i));
                }
                for (Object obj : iterable) {
                    result.add(obj);
                }
                for (i = end; i < this.array.size(); ++i) {
                    result.add(this.array.get(i));
                }
            } else {
                throw new ExecutionException("You cannot insert '%s' into a list", value);
            }
            this.array.clear();
            this.array.addAll(result);
            return;
        }
        throw new ExecutionException("You cannot use '%s' as index", index);
    }

    @Override
    public Object getIndex(Object index) throws ExecutionException {
        if (Cast.isLong(index)) {
            int indexValue = Cast.toLong(index).intValue();
            ExecutionException.when(indexValue < 0, "Indexing error, %s < 0", indexValue);
            if (indexValue >= this.array.size()) {
                return null;
            }
            return this.array.get(indexValue);
        }
        if (index instanceof Range) {
            Range range = (Range)index;
            int start = range.getStart(this.array.size());
            int end = range.getEnd(this.array.size());
            LngList result = new LngList(this.fieldProvider);
            for (int i = start; i < end; ++i) {
                result.array.add(this.array.get(i));
            }
            return result;
        }
        throw new ExecutionException("You cannot use '%s' as index", index);
    }

    @Override
    public void setField(String name, Object value) throws ExecutionException {
        ExecutionException.when(this.pinned.get(), "Cannot set a field a pinned list.", new Object[0]);
        if (this.fieldProvider == null) {
            throw new ExecutionException("List is not tied.", new Object[0]);
        }
        this.fieldProvider.setField(name, value);
    }

    @Override
    public Object getField(String name) throws ExecutionException {
        if (this.fieldProvider == null) {
            throw new ExecutionException("List is not tied.", new Object[0]);
        }
        return this.fieldProvider.getField(name);
    }

    @Override
    public Set<String> fields() {
        return Set.of("length");
    }

    @Override
    public Iterator<Object> iterator() {
        return this.array.iterator();
    }

    public String toString() {
        return "[" + this.array.stream().map(s -> s == null ? "none" : s.toString()).collect(Collectors.joining(", ")) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LngList lngList = (LngList)o;
        if (this.array.size() != lngList.array.size()) {
            return false;
        }
        IdentityHashMap compared = new IdentityHashMap();
        compared.put(lngList, null);
        compared.put(this, null);
        for (int i = 0; i < this.array.size(); ++i) {
            Object thisField = this.array.get(i);
            Object thatField = lngList.array.get(i);
            if (compared.containsKey(thisField) || compared.containsKey(thatField) || Objects.equals(thisField, thatField)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.computeHashCode(new IdentityHashMap<Object, Boolean>());
    }

    private int computeHashCode(Map<Object, Boolean> visited) {
        if (visited.containsKey(this)) {
            return 0;
        }
        visited.put(this, true);
        int result = 1;
        for (Object item : this.array) {
            int n;
            if (visited.containsKey(item)) {
                result = 31 * result;
                continue;
            }
            if (item == null) {
                n = 0;
            } else if (item instanceof LngList) {
                LngList l = (LngList)item;
                n = l.computeHashCode(visited);
            } else {
                n = item.hashCode();
            }
            result = 31 * result + n;
        }
        return result;
    }
}

