/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.Analyzer;
import ch.turic.analyzer.AssignmentAnalyzer;
import ch.turic.analyzer.BreakAnalyzer;
import ch.turic.analyzer.ClassAnalyzer;
import ch.turic.analyzer.ContinueAnalyzer;
import ch.turic.analyzer.DieAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.FlowAnalyzer;
import ch.turic.analyzer.ForLoopAnalyzer;
import ch.turic.analyzer.FunctionDefinitionAnalyzer;
import ch.turic.analyzer.GlobalAnalyzer;
import ch.turic.analyzer.IfAnalyzer;
import ch.turic.analyzer.LetAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.PinAnalyzer;
import ch.turic.analyzer.PrimaryExpressionAnalyzer;
import ch.turic.analyzer.PrintAnalyzer;
import ch.turic.analyzer.ReturnAnalyzer;
import ch.turic.analyzer.TryCatchAnalyzer;
import ch.turic.analyzer.WhileLoopAnalyzer;
import ch.turic.analyzer.WithAnalyzer;
import ch.turic.analyzer.YieldAnalyzer;
import ch.turic.commands.FunctionCall;
import ch.turic.commands.FunctionCallOrCurry;
import ch.turic.commands.Identifier;
import java.util.HashMap;
import java.util.Map;

public class CommandAnalyzer
extends AbstractAnalyzer {
    public static final CommandAnalyzer INSTANCE = new CommandAnalyzer();
    private static final Map<String, Analyzer> analyzers = new HashMap<String, Analyzer>();

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        Command command;
        if (lexes.is(";")) {
            lexes.next();
            return null;
        }
        if (lexes.isKeyword() && (command = this.analyzeKeywordCommand(lexes)) != null) {
            return command;
        }
        Command assignmentCommand = this.tryToGetAssignment(lexes);
        if (assignmentCommand != null) {
            return assignmentCommand;
        }
        FunctionCall functionCallCommand = this.getParentheseslessFunctionCall(lexes);
        if (functionCallCommand != null) {
            return functionCallCommand;
        }
        Command expressionCommand = ExpressionAnalyzer.INSTANCE.analyze(lexes);
        Analyzer.checkCommandTermination(lexes);
        return expressionCommand;
    }

    private FunctionCall getParentheseslessFunctionCall(LexList lexes) {
        int position = lexes.getIndex();
        if (lexes.isIdentifier()) {
            String functionName = lexes.next().text();
            if (!lexes.hasNext() || lexes.peek().atLineStart()) {
                lexes.setIndex(position);
                return null;
            }
            if (lexes.isIdentifier() || lexes.isConstant() || lexes.is("{")) {
                FunctionCallOrCurry.Argument[] arguments = PrimaryExpressionAnalyzer.analyzeArguments(lexes, false, false);
                return new FunctionCall(new Identifier(functionName), arguments);
            }
        }
        lexes.setIndex(position);
        return null;
    }

    private Command tryToGetAssignment(LexList lexes) {
        int position = lexes.getIndex();
        Command assignmentCommand = AssignmentAnalyzer.INSTANCE.analyze(lexes);
        if (assignmentCommand != null) {
            Analyzer.checkCommandTermination(lexes);
            return assignmentCommand;
        }
        lexes.setIndex(position);
        return null;
    }

    private Command analyzeKeywordCommand(LexList lexes) throws BadSyntax {
        String keyword;
        return switch (keyword = lexes.peek().text()) {
            case "if", "while", "with", "for", "flow", "fn", "class" -> {
                lexes.next();
                yield analyzers.get(keyword).analyze(lexes);
            }
            case "pin", "global", "break", "continue", "die", "return", "yield", "print", "println", "try", "mut", "let" -> {
                lexes.next();
                Command command = analyzers.get(keyword).analyze(lexes);
                Analyzer.checkCommandTermination(lexes);
                yield command;
            }
            default -> null;
        };
    }

    static {
        analyzers.put("let", LetAnalyzer.INSTANCE);
        analyzers.put("mut", LetAnalyzer.INSTANCE_MUT);
        analyzers.put("pin", PinAnalyzer.INSTANCE);
        analyzers.put("global", GlobalAnalyzer.INSTANCE);
        analyzers.put("fn", FunctionDefinitionAnalyzer.INSTANCE);
        analyzers.put("class", ClassAnalyzer.INSTANCE);
        analyzers.put("if", IfAnalyzer.INSTANCE);
        analyzers.put("try", TryCatchAnalyzer.INSTANCE);
        analyzers.put("break", BreakAnalyzer.INSTANCE);
        analyzers.put("die", DieAnalyzer.INSTANCE);
        analyzers.put("continue", ContinueAnalyzer.INSTANCE);
        analyzers.put("return", ReturnAnalyzer.INSTANCE);
        analyzers.put("yield", YieldAnalyzer.INSTANCE);
        analyzers.put("print", PrintAnalyzer.INSTANCE);
        analyzers.put("println", PrintAnalyzer.INSTANCE_NL);
        analyzers.put("while", WhileLoopAnalyzer.INSTANCE);
        analyzers.put("with", WithAnalyzer.INSTANCE);
        analyzers.put("for", ForLoopAnalyzer.INSTANCE);
        analyzers.put("flow", FlowAnalyzer.INSTANCE);
    }
}

