/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.memory.LngObject;
import ch.turic.utils.StringUtils;
import java.util.Map;

public class Env
implements TuriFunction {
    @Override
    public String name() {
        return "env";
    }

    @Override
    public Object call(Context context, Object[] arguments) throws ExecutionException {
        ch.turic.memory.Context ctx = FunUtils.ctx(context);
        FunUtils.ArgumentsHolder args = FunUtils.args(this.name(), arguments, Object[].class);
        if (args.N > 1) {
            throw new ExecutionException("Turic function expects at most one argument", new Object[0]);
        }
        if (args.N == 0) {
            LngObject result = LngObject.newEmpty(ctx);
            for (Map.Entry<String, String> e : System.getenv().entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                result.setField(key, value);
            }
            return result;
        }
        String varName = args.at(0).as(String.class);
        if (varName.contains("*") || varName.contains("?")) {
            LngObject result = LngObject.newEmpty(ctx);
            for (Map.Entry<String, String> e : System.getenv().entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                if (!StringUtils.matches(varName, key)) continue;
                result.setField(key, value);
            }
            return result;
        }
        return System.getenv(varName);
    }
}

