/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.LngObject;
import java.util.Arrays;
import java.util.Optional;

public class FunUtils {
    private static final Argument UNDEFINED_ARGUMENT = new Argument("undefined", new Object(), 0){

        @Override
        public <T> T getOr(T defaultValue) {
            return defaultValue;
        }

        @Override
        public <T> T as(Class<T> t, T defaultValue) {
            return defaultValue;
        }
    };

    public static void needArg(String name, Object[] args) {
        ExecutionException.when(args.length == 0, "Function %s needs at least one argument.", name);
    }

    public static void noArg(String name, Object[] args) {
        ExecutionException.when(args.length > 1, "Built-in function %s needs no arguments", name);
    }

    public static void oneArgOpt(String name, Object[] args) {
        ExecutionException.when(args.length > 1, "Built-in function %s needs at most one argument", name);
    }

    public static Object arg(String name, Object[] args) {
        return FunUtils.arg(name, args, Object.class);
    }

    public static Object oneOrMoreArgs(String name, Object[] args) {
        ExecutionException.when(args.length == 0, "Built-in function '%s' needs exactly argument", name);
        return args[0];
    }

    public static void twoArgs(String name, Object[] args) {
        ExecutionException.when(args.length != 2, "Function %s needs two arguments.", name);
    }

    public static void twoPlusArgs(String name, Object[] args) {
        ExecutionException.when(args.length < 2, "Function %s needs at least two arguments.", name);
    }

    public static <T> T arg(String name, Object[] args, Class<T> type) {
        if (args.length != 1) {
            throw new ExecutionException("Built-in function '%s' needs exactly 1 argument.", name);
        }
        return (T)args[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArgumentsHolder args(String name, Object[] args, Object ... types) {
        int maxArgs;
        int minArgs = types.length;
        for (int j = types.length - 1; j >= 0; --j) {
            if (types[j] instanceof ArgumentsHolder.Optional) continue;
            minArgs = j;
            break;
        }
        int n = maxArgs = types[types.length - 1] == Object[].class ? Integer.MAX_VALUE : types.length;
        if (args.length < minArgs || args.length > maxArgs) {
            if (minArgs != maxArgs) {
                throw new ExecutionException("Built-in function '%s' needs minimum %s and maximum %s arguments.", name, minArgs, maxArgs);
            }
            throw new ExecutionException("Built-in function '%s' needs exactly %s argument%s.", name, minArgs, minArgs == 1 ? "" : "s");
        }
        int i = 0;
        while (true) {
            block24: {
                Object object;
                block25: {
                    Class type;
                    if (i >= types.length) {
                        return new ArgumentsHolder(args, name);
                    }
                    if (types[i] == Object[].class && i == types.length - 1) {
                        return new ArgumentsHolder(args, name);
                    }
                    if (types[i] == null) {
                        throw new IllegalArgumentException("Types array contains null element for '%s'.".formatted(name));
                    }
                    Object object2 = types[i];
                    if (!(object2 instanceof ArgumentsHolder.Optional)) break block25;
                    ArgumentsHolder.Optional optional = (ArgumentsHolder.Optional)object2;
                    try {
                        Class clazz;
                        type = clazz = optional.type();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (args.length <= i || args[i] == null) break block24;
                    types[i] = type;
                }
                if (!((object = types[i]) instanceof Class)) {
                    throw new ExecutionException("Types array contains unexpected type for '%s'.".formatted(name), new Object[0]);
                }
                Class klass = (Class)object;
                if (klass == ArgumentsHolder.LngLong.class) {
                    if (!Cast.isLong(args[i])) {
                        throw new ExecutionException("Built-in function '%s' %s argument needs to be a number", name, FunUtils.nth(i + 1));
                    }
                    args[i] = Cast.toLong(args[i]);
                } else if (klass == ArgumentsHolder.LngDouble.class) {
                    if (!Cast.isDouble(args[i])) {
                        throw new ExecutionException("Built-in function '%s' %s argument needs to be a floating point number", name, FunUtils.nth(i + 1));
                    }
                    args[i] = Cast.toDouble(args[i]);
                } else if (klass == ArgumentsHolder.LngNumber.class) {
                    if (Cast.isLong(args[i])) {
                        args[i] = Cast.toLong(args[i]);
                    } else {
                        if (!Cast.isDouble(args[i])) {
                            throw new ExecutionException("Built-in function '%s' %s argument needs to be a floating point or integer number", name, FunUtils.nth(i + 1));
                        }
                        args[i] = Cast.toDouble(args[i]);
                    }
                } else if (!klass.isInstance(args[i])) {
                    throw new ExecutionException("Built-in function '%s' %s argument needs to be a %s", name, FunUtils.nth(i + 1), klass.getSimpleName());
                }
            }
            ++i;
        }
    }

    private static String nth(int i) {
        Object[] objectArray = new Object[2];
        objectArray[0] = i;
        objectArray[1] = switch (i) {
            case 1 -> "st";
            case 2 -> "nd";
            case 3 -> "rd";
            default -> "th";
        };
        return String.format("%s-%s", objectArray);
    }

    public static void nArgs(String name, Object[] args, int n) {
        ExecutionException.when(args.length != n, "Function %s needs %d argument.", name, n);
    }

    public static LngObject lngObject(String name, Object arg) {
        if (arg instanceof LngObject) {
            return (LngObject)arg;
        }
        throw new ExecutionException("The argument to '%s()' has to be an object", name);
    }

    public static ch.turic.memory.Context ctx(Context context) {
        if (context instanceof ch.turic.memory.Context) {
            ch.turic.memory.Context ctx = (ch.turic.memory.Context)context;
            return ctx;
        }
        throw new ExecutionException("context must be a context of type ch.turic.memory.Context", new Object[0]);
    }

    public static class ArgumentsHolder {
        private final Argument[] arguments;
        private final Object[] args;
        public final int N;

        public ArgumentsHolder(Object[] arguments, String name) {
            this.args = arguments;
            this.arguments = new Argument[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                this.arguments[i] = new Argument(name, arguments[i], i + 1);
            }
            this.N = arguments.length;
        }

        public Argument at(int i) {
            if (i >= this.arguments.length) {
                return UNDEFINED_ARGUMENT;
            }
            return this.arguments[i];
        }

        public Object[] tail(int from) {
            return Arrays.copyOfRange(this.args, from, this.N);
        }

        public Argument last() {
            return this.arguments[this.arguments.length - 1];
        }

        public Argument first() {
            return this.arguments[0];
        }

        public static <T> Optional<T> optional(Class<T> type) {
            return new Optional<T>(type);
        }

        public record Optional<T>(Class<T> type) {
        }

        public static interface LngNumber {
        }

        public static interface LngDouble {
        }

        public static interface LngLong {
        }
    }

    public static class Argument {
        private final String name;
        private final Object value;
        private final int index;
        public final Class<?> type;

        public Argument(String name, Object value, int index) {
            this.name = name;
            this.value = value;
            this.index = index;
            this.type = value == null ? null : value.getClass();
        }

        public Object get() {
            return this.value;
        }

        public <T> T getOr(T defaultValue) {
            if (this.value == null) {
                return defaultValue;
            }
            if (!defaultValue.getClass().isInstance(this.value)) {
                throw new ExecutionException("Cannot cast argument %d of function '%s' to %s", this.index, this.name, defaultValue.getClass().getSimpleName());
            }
            return (T)this.value;
        }

        public double doubleValue() {
            return ((Number)this.value).doubleValue();
        }

        public int intValue() {
            return ((Number)this.value).intValue();
        }

        public <T> T as(Class<T> t) {
            if (!t.isInstance(this.value)) {
                throw new ExecutionException("Cannot cast argument %d of function '%s' to %s", this.index, this.name, t.getSimpleName());
            }
            return (T)this.value;
        }

        public <T> T as(Class<T> t, T defaultValue) {
            if (this.value == null) {
                return defaultValue;
            }
            if (!t.isInstance(this.value)) {
                throw new ExecutionException("Cannot cast argument %d of function '%s' to %s", this.index, this.name, t.getSimpleName());
            }
            return (T)this.value;
        }

        public <T> Optional<T> optional(Class<T> type) {
            if (this.value == null) {
                return Optional.empty();
            }
            if (!type.isInstance(this.value)) {
                throw new ExecutionException("Cannot cast argument %d of function '%s' to %s", this.index, this.name, type.getSimpleName());
            }
            return Optional.of(this.value);
        }

        public boolean isPresent() {
            return this != UNDEFINED_ARGUMENT;
        }

        public boolean is_a(Class<?> type) {
            return type.isInstance(this.value);
        }
    }
}

