/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import java.lang.runtime.SwitchBootstraps;

public class Jsonify
implements TuriFunction {
    @Override
    public String name() {
        return "jsonify";
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        Object object = FunUtils.arg(this.name(), arguments, Object.class);
        return Jsonify.jsonify(object);
    }

    private static String jsonify(Object object) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LngObject.class, LngList.class, String.class}, (Object)object2, n)) {
            case 0 -> {
                LngObject lngObject = (LngObject)object2;
                yield Jsonify.jsonifyObject(lngObject);
            }
            case 1 -> {
                LngList lngList = (LngList)object2;
                yield Jsonify.jsonifyList(lngList);
            }
            case 2 -> {
                String s = (String)object2;
                yield Jsonify.jsonifyString(s);
            }
            case -1 -> "null";
            default -> object.toString();
        };
    }

    static String jsonifyString(String s) {
        return "\"" + s.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("\"", "\\\"") + "\"";
    }

    private static String jsonifyList(LngList list) {
        StringBuilder sb = new StringBuilder("[");
        String sep = "";
        for (Object element : list) {
            sb.append(sep).append(Jsonify.jsonify(element));
            sep = ",";
        }
        sb.append("]");
        return sb.toString();
    }

    private static String jsonifyObject(LngObject object) {
        StringBuilder sb = new StringBuilder("{");
        String sep = "";
        for (String key : object.fields()) {
            sb.append(sep).append("\"").append(key).append("\":").append(Jsonify.jsonify(object.getField(key)));
            sep = ",";
        }
        sb.append("}");
        return sb.toString();
    }
}

