/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.BlockCommand;
import ch.turic.memory.ClassContext;
import ch.turic.memory.Context;
import ch.turic.memory.LngClass;
import ch.turic.utils.Unmarshaller;
import java.util.Objects;

public class ClassDefinition
extends AbstractCommand {
    final String className;
    final String[] parents;
    final BlockCommand body;
    public static final LngClass[] NO_PARENTS = new LngClass[0];

    public BlockCommand body() {
        return this.body;
    }

    public String className() {
        return this.className;
    }

    public String[] parents() {
        return this.parents;
    }

    public static ClassDefinition factory(Unmarshaller.Args args) {
        return new ClassDefinition(args.str("className"), args.get("parents", String[].class), args.get("body", BlockCommand.class));
    }

    public ClassDefinition(String className, String[] parents, BlockCommand body) {
        this.body = body;
        this.className = className;
        this.parents = parents;
    }

    @Override
    public Object _execute(Context context) throws ExecutionException {
        LngClass[] parentClasses = this.parents == null ? NO_PARENTS : new LngClass[this.parents.length];
        for (int i = 0; this.parents != null && i < this.parents.length; ++i) {
            LngClass lngParent;
            Object p = context.get(this.parents[i]);
            if (!(p instanceof LngClass)) {
                throw new ExecutionException("'" + this.parents[i] + "' is not defined or not a LngClass", new Object[0]);
            }
            parentClasses[i] = lngParent = (LngClass)p;
        }
        ClassContext ctx = new ClassContext(context, parentClasses);
        LngClass klass = new LngClass(ctx, Objects.requireNonNullElse(this.className, "#undefined"));
        ctx.local("cls", klass);
        this.body.execute(ctx);
        if (this.className != null) {
            context.local(this.className, klass);
        }
        return klass;
    }
}

