/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.ChainedClosureOrMacro;
import ch.turic.commands.ClosureOrMacro;
import ch.turic.commands.FunctionCallOrCurry;
import ch.turic.commands.ParameterList;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.LngClass;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import ch.turic.utils.NullableOptional;
import java.util.Set;

public abstract sealed class ClosureLike
extends AbstractCommand
implements Command,
HasFields,
Cloneable
permits ChainedClosureOrMacro, ClosureOrMacro {
    private static final Set<String> SPECIAL_VARIABLES = Set.of("this", "cls", "me", "it", ".");
    private FunctionCallOrCurry.ArgumentEvaluated[] curriedArguments = null;
    private HasFields curriedSelf = null;

    public abstract ParameterList parameters();

    public abstract Context wrapped();

    public abstract String[] returnType();

    public abstract NullableOptional<Object> methodCall(Context var1, HasFields var2, String var3, FunctionCallOrCurry.Argument[] var4);

    public abstract FunctionCallOrCurry.ArgumentEvaluated[] evaluateArguments(Context var1, FunctionCallOrCurry.Argument[] var2);

    public abstract String name();

    public ClosureLike clone() throws CloneNotSupportedException {
        return (ClosureLike)super.clone();
    }

    @Override
    public void setField(String name, Object value) throws ExecutionException {
        throw new ExecutionException("You cannot set fields of a closure or a macro", new Object[0]);
    }

    public FunctionCallOrCurry.ArgumentEvaluated[] getCurriedArguments() {
        return this.curriedArguments;
    }

    public HasFields getCurriedSelf() {
        return this.curriedSelf;
    }

    public void setCurriedArguments(FunctionCallOrCurry.ArgumentEvaluated[] curriedArguments) {
        this.curriedArguments = curriedArguments;
    }

    public void setCurriedSelf(HasFields curriedSelf) {
        this.curriedSelf = curriedSelf;
    }

    public ClosureLike curried(HasFields self, FunctionCallOrCurry.ArgumentEvaluated[] arguments) {
        if (self != null && this.getCurriedSelf() != null) {
            throw new ExecutionException("You cannot curry a method to different objects. How could it happen?", new Object[0]);
        }
        try {
            ClosureLike it = this.clone();
            it.setCurriedSelf(self);
            if (it.getCurriedArguments() == null) {
                it.setCurriedArguments(arguments);
            } else {
                FunctionCallOrCurry.ArgumentEvaluated[] newCurriedArguments = new FunctionCallOrCurry.ArgumentEvaluated[it.getCurriedArguments().length + arguments.length];
                System.arraycopy(this.getCurriedArguments(), 0, newCurriedArguments, 0, this.getCurriedArguments().length);
                System.arraycopy(arguments, 0, newCurriedArguments, this.getCurriedArguments().length, arguments.length);
                it.setCurriedArguments(newCurriedArguments);
            }
            return it;
        }
        catch (CloneNotSupportedException e) {
            throw new ExecutionException(e, "cloning failed while currying");
        }
    }

    public void curryThis(HasFields self, FunctionCallOrCurry.ArgumentEvaluated[] arguments) {
        if (self != null && this.curriedSelf != null) {
            throw new ExecutionException("You cannot curry a method to different objects. How could it happen?", new Object[0]);
        }
        this.setCurriedSelf(self);
        if (this.getCurriedArguments() == null) {
            this.setCurriedArguments(arguments);
        } else {
            FunctionCallOrCurry.ArgumentEvaluated[] newCurriedArguments = new FunctionCallOrCurry.ArgumentEvaluated[this.getCurriedArguments().length + arguments.length];
            System.arraycopy(this.getCurriedArguments(), 0, newCurriedArguments, 0, this.getCurriedArguments().length);
            System.arraycopy(arguments, 0, newCurriedArguments, this.getCurriedArguments().length, arguments.length);
            this.setCurriedArguments(newCurriedArguments);
        }
    }

    @Override
    public Set<String> fields() {
        return Set.of("name");
    }

    @Override
    public Object getField(String name) throws ExecutionException {
        if ("name".equals(name)) {
            return this.name();
        }
        throw new ExecutionException("You cannot get field '%s' of a closure or a macro.", name);
    }

    private static Context prepareListContext(Context context, String methodName, LngList lngList, FunctionCallOrCurry.ArgumentEvaluated[] argValues, ClosureLike it) {
        Context ctx;
        HasFields fp = lngList.getFieldProvider();
        if (fp instanceof LngObject) {
            LngObject lngObject = (LngObject)fp;
            ctx = ClosureLike.prepareObjectContext(context, lngObject, methodName, argValues, it);
        } else if (fp instanceof LngClass) {
            LngClass lngClass = (LngClass)fp;
            ctx = ClosureLike.getClassContext(context, methodName, lngClass, argValues, it);
        } else {
            throw new ExecutionException("List field provider is neither object nor class", new Object[0]);
        }
        ctx.let0("it", lngList);
        return ctx;
    }

    private static Context prepareObjectContext(Context context, LngObject lngObject, String methodName, FunctionCallOrCurry.ArgumentEvaluated[] argValues, ClosureLike it) {
        Context ctx = it.wrapped() == null ? context.wrap(lngObject.context()) : context.wrap(it.wrapped());
        ctx.let0("this", lngObject);
        ctx.let0("cls", lngObject.lngClass());
        ctx.let0(".", methodName);
        ctx.setCaller(context);
        FunctionCallOrCurry.freezeThisAndCls(ctx);
        ctx.freeze(".");
        FunctionCallOrCurry.defineArgumentsInContext(ctx, context, it.parameters(), argValues, true);
        return ctx;
    }

    private static Context getClassContext(Context context, String methodName, LngClass lngClass, FunctionCallOrCurry.ArgumentEvaluated[] argValues, ClosureLike it) {
        Context ctx = context.wrap(lngClass.context());
        ctx.let0(".", methodName);
        ctx.freeze(".");
        if ("init".equals(methodName)) {
            ctx.let0("this", context.getLocal("this"));
            ctx.let0("cls", lngClass);
            FunctionCallOrCurry.freezeThisAndCls(ctx);
            FunctionCallOrCurry.defineArgumentsInContext(ctx, context, it.parameters(), argValues, false);
        } else {
            FunctionCallOrCurry.defineArgumentsInContext(ctx, context, it.parameters(), argValues, true);
        }
        return ctx;
    }

    static NullableOptional<Object> callTheMethod(Context context, HasFields obj, String methodName, FunctionCallOrCurry.ArgumentEvaluated[] argValues, ClosureLike it) {
        LngList lngList;
        if (obj instanceof LngObject) {
            LngObject lngObject = (LngObject)obj;
            Context ctx = ClosureLike.prepareObjectContext(context, lngObject, methodName, argValues, it);
            return NullableOptional.of(it.execute(ctx));
        }
        if (obj instanceof LngList && (lngList = (LngList)obj).hasFieldProvider()) {
            Context ctx = ClosureLike.prepareListContext(context, methodName, lngList, argValues, it);
            return NullableOptional.of(it.execute(ctx));
        }
        if (obj instanceof LngClass) {
            LngClass lngClass = (LngClass)obj;
            Context ctx = ClosureLike.getClassContext(context, methodName, lngClass, argValues, it);
            if (methodName.equals("init") && context.containsLocal("this")) {
                Object resultObject = it.execute(ctx);
                context.mergeVariablesFrom(ctx, SPECIAL_VARIABLES);
                return NullableOptional.of(resultObject);
            }
            return NullableOptional.of(it.execute(ctx));
        }
        return NullableOptional.empty();
    }
}

