/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.BlockCommand;
import ch.turic.commands.BreakCommand;
import ch.turic.commands.Closure;
import ch.turic.commands.ClosureLike;
import ch.turic.commands.Conditional;
import ch.turic.commands.FunctionCallOrCurry;
import ch.turic.commands.Macro;
import ch.turic.commands.ParameterList;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.Variable;
import ch.turic.utils.NullableOptional;

public abstract sealed class ClosureOrMacro
extends ClosureLike
permits Closure, Macro {
    final String name;
    final ParameterList parameters;
    final Context wrapped;
    final String[] returnType;
    final BlockCommand command;

    @Override
    public String name() {
        return this.name;
    }

    public BlockCommand command() {
        return this.command;
    }

    @Override
    public ParameterList parameters() {
        return this.parameters;
    }

    @Override
    public Context wrapped() {
        return this.wrapped;
    }

    @Override
    public String[] returnType() {
        return this.returnType;
    }

    public ClosureOrMacro(String name, ParameterList parameters, Context wrapped, String[] returnType, BlockCommand command) {
        this.name = name;
        this.parameters = parameters;
        this.wrapped = wrapped;
        this.returnType = returnType;
        this.command = command;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        ctx.step();
        Object result = null;
        for (Command cmd : this.command.commands()) {
            Conditional.ReturnResult returnResult;
            ExecutionException.when(cmd instanceof BreakCommand, "You cannot break from a function or closure. Use Return", new Object[0]);
            result = cmd.execute(ctx);
            if (!(result instanceof Conditional.ReturnResult) || !(returnResult = (Conditional.ReturnResult)result).isDone()) continue;
            return returnResult.result();
        }
        if (ClosureOrMacro.isOfTypes(ctx, result, this.returnType)) {
            return result;
        }
        throw new ExecutionException("Cannot return from '%s' the value '%s' as it does not fit any of the accepted type of the macro (%s)", this.name, result, String.join((CharSequence)",", this.returnType));
    }

    private static boolean isOfTypes(Context ctx, Object value, String[] types) {
        if (types == null || types.length == 0) {
            return true;
        }
        for (String typeName : types) {
            Variable.Type type = Variable.getTypeFromName(ctx, typeName);
            if (!Variable.isFit(value, type.javaType(), type.lngClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public NullableOptional<Object> methodCall(Context context, HasFields obj, String methodName, FunctionCallOrCurry.Argument[] arguments) {
        FunctionCallOrCurry.ArgumentEvaluated[] argValues = this.evaluateArguments(context, arguments);
        return ClosureLike.callTheMethod(context, obj, methodName, argValues, this);
    }
}

