/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Identifier;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.Context;
import ch.turic.memory.NameGen;
import ch.turic.memory.Sentinel;
import ch.turic.utils.Unmarshaller;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class FlowCommand
extends AbstractCommand {
    private static final ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
    private final String flowId;
    private final Command exitCondition;
    private final Command limitExpression;
    private final Command timeoutExpression;
    private final Command resultExpression;
    private final Cell[] cells;
    private final Cell[] startCells;
    private final Map<String, Cell[]> dependentCells;

    private FlowCommand(String flowId, Command exitCondition, Command limitExpression, Command timeoutExpression, Command resultExpression, Cell[] cells, Cell[] startCells, Map<String, Cell[]> dependentCells) {
        this.flowId = flowId;
        this.exitCondition = exitCondition;
        this.limitExpression = limitExpression;
        this.timeoutExpression = timeoutExpression;
        this.resultExpression = resultExpression;
        this.cells = cells;
        this.startCells = startCells;
        this.dependentCells = dependentCells;
    }

    public static FlowCommand factory(Unmarshaller.Args args) {
        return new FlowCommand(args.str("flowId"), args.command("exitCondition"), args.command("limitExpression"), args.command("timeoutExpression"), args.command("resultExpression"), args.get("cells", Cell[].class), args.get("startCells", Cell[].class), args.get("dependentCells", Map.class));
    }

    public FlowCommand(String flowId, Command exitCondition, Command limitExpression, Command timeoutExpression, Command resultExpression, String[] cellIdentifiers, Command[] cellCommands) {
        this.dependentCells = new HashMap<String, Cell[]>();
        this.flowId = Objects.requireNonNullElse(flowId, "#unnamed");
        this.exitCondition = exitCondition;
        this.limitExpression = limitExpression;
        this.timeoutExpression = timeoutExpression;
        this.resultExpression = resultExpression;
        if (cellIdentifiers.length == 0) {
            throw new IllegalArgumentException("Invalid arguments for flow command");
        }
        if (cellCommands.length != cellIdentifiers.length) {
            throw new IllegalArgumentException("Invalid arguments for flow command, different number of identifiers and commands.");
        }
        this.cells = new Cell[cellIdentifiers.length];
        for (int i = 0; i < cellIdentifiers.length; ++i) {
            this.cells[i] = new Cell(cellIdentifiers[i], cellCommands[i]);
        }
        try {
            this.dependencyAnalysis();
            this.startCells = this.determineEntryCells();
            this.validateSchedulingOrderFromDependencies();
            Cell[] untouched = this.getUnreachableCells();
            if (untouched.length != 0) {
                StringBuilder sb = new StringBuilder("There are cells in flow '%s' which have no effect:\n".formatted(this.flowId));
                for (Cell ut : untouched) {
                    sb.append("%s, ".formatted(ut.id));
                }
                throw new ExecutionException(sb.substring(0, sb.length() - 2), new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException(e, "Dependency analysis failed on flow '%s'", flowId);
        }
    }

    private void dependencyAnalysis() throws IllegalAccessException {
        HashMap dependencies = new HashMap();
        HashSet<String> stateCellIds = new HashSet<String>();
        for (Cell value : this.cells) {
            stateCellIds.add(value.id);
        }
        for (Cell cell : this.cells) {
            Set identifiers = FlowCommand.getSubCommandsTransitive(cell.command, new HashSet<Object>()).stream().filter(c -> c instanceof Identifier).map(c -> (Identifier)c).map(Identifier::name).filter(stateCellIds::contains).collect(Collectors.toSet());
            for (String id : identifiers) {
                if (!dependencies.containsKey(id)) {
                    dependencies.put(id, new ArrayList());
                }
                ((List)dependencies.get(id)).add(cell);
            }
        }
        for (Map.Entry entry : dependencies.entrySet()) {
            this.dependentCells.put((String)entry.getKey(), (Cell[])((List)entry.getValue()).toArray(Cell[]::new));
        }
    }

    private Cell[] determineEntryCells() {
        HashSet<Cell> dependedUpon = new HashSet<Cell>();
        for (Cell[] deps : this.dependentCells.values()) {
            dependedUpon.addAll(Arrays.asList(deps));
        }
        ArrayList<Cell> startCells = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            if (dependedUpon.contains(cell)) continue;
            startCells.add(cell);
        }
        return (Cell[])startCells.toArray(Cell[]::new);
    }

    private void validateSchedulingOrderFromDependencies() throws ExecutionException {
        if (this.dependentCells.isEmpty()) {
            throw new RuntimeException("There are no dependencies defined for this flow command. It is an internal error.");
        }
        HashMap<String, Set<String>> dependencyMap = this.buildDepencencyMap();
        for (Cell cell : this.cells) {
            HashSet<String> alreadyChecked = new HashSet<String>();
            List<String> failurePath = this.dependencyMissing(cell.id, dependencyMap, alreadyChecked, new HashSet<String>(), Arrays.stream(this.startCells).map(c -> c.id).collect(Collectors.toSet()));
            if (failurePath.isEmpty()) continue;
            throw new ExecutionException("Invalid flow '%s': cell '%s' may depend on undefined state due to cyclic or misordered dependencies.\n[ %s ]", this.flowId, cell.id, String.join((CharSequence)" <- ", failurePath));
        }
    }

    private HashMap<String, Set<String>> buildDepencencyMap() {
        HashMap<String, Set<String>> dependencyMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Cell[]> entry : this.dependentCells.entrySet()) {
            String dependedOn = entry.getKey();
            for (Cell dependent : entry.getValue()) {
                dependencyMap.computeIfAbsent(dependent.id, k -> new HashSet()).add(dependedOn);
            }
        }
        return dependencyMap;
    }

    private List<String> dependencyMissing(String id, Map<String, Set<String>> depMap, Set<String> alreadyChecked, Set<String> path, Set<String> startCells) {
        if (startCells.contains(id)) {
            return List.of();
        }
        if (alreadyChecked.contains(id)) {
            return List.of();
        }
        if (!depMap.containsKey(id)) {
            return List.of();
        }
        if (!path.add(id)) {
            return new ArrayList<String>(List.of(id));
        }
        for (String dep : depMap.get(id)) {
            List<String> list = this.dependencyMissing(dep, depMap, alreadyChecked, path, startCells);
            if (list.isEmpty()) continue;
            list.add(id);
            return list;
        }
        path.remove(id);
        alreadyChecked.add(id);
        return List.of();
    }

    private long nextCounter(String id, Map<String, Long> counters) {
        return counters.computeIfAbsent(id, k -> 0L);
    }

    private Cell[] getUnreachableCells() {
        HashSet<Cell> reachableCells = new HashSet<Cell>();
        LinkedList<Cell> toVisit = new LinkedList<Cell>(Arrays.asList(this.startCells));
        while (!toVisit.isEmpty()) {
            Cell[] dependents;
            Cell current = toVisit.poll();
            if (!reachableCells.add(current) || (dependents = this.dependentCells.get(current.id)) == null) continue;
            toVisit.addAll(Arrays.asList(dependents));
        }
        return (Cell[])Arrays.stream(this.cells).filter(cell -> !reachableCells.contains(cell)).toArray(Cell[]::new);
    }

    private static Set<Object> getSubCommandsTransitive(Object command, Set<Object> commandsVisited) throws IllegalAccessException {
        if (commandsVisited.contains(command)) {
            return Set.of();
        }
        commandsVisited.add(command);
        HashSet<Object> fields = new HashSet<Object>();
        fields.add(command);
        for (Object field : FlowCommand.getSubCommands(command)) {
            fields.addAll(FlowCommand.getSubCommandsTransitive(field, commandsVisited));
        }
        return fields;
    }

    private static Set<Object> getSubCommands(Object command) throws IllegalAccessException {
        HashSet<Object> fields = new HashSet<Object>();
        for (Field f : FlowCommand.getFields(command)) {
            if (f.isSynthetic() || !FlowCommand.isATuricumClass(f)) continue;
            if (f.getType().isArray()) {
                f.setAccessible(true);
                Object array = f.get(command);
                if (array == null) continue;
                int length = Array.getLength(array);
                for (int i = 0; i < length; ++i) {
                    fields.add(Array.get(array, i));
                }
                continue;
            }
            f.setAccessible(true);
            Object value = f.get(command);
            if (value == null) continue;
            fields.add(value);
        }
        return fields;
    }

    private static boolean isATuricumClass(Field f) {
        return f.getType().getPackageName().startsWith("ch.turic") || f.getType().isArray() && f.getType().getComponentType().getPackageName().startsWith("ch.turic");
    }

    private static Field[] getFields(Object command) {
        HashSet<Field> fields = new HashSet<Field>(List.of(command.getClass().getDeclaredFields()));
        while (command.getClass().getSuperclass() != null && command.getClass().getSuperclass() != Object.class) {
            fields.addAll(List.of(command.getClass().getSuperclass().getDeclaredFields()));
            command = command.getClass().getSuperclass();
        }
        return (Field[])fields.toArray(Field[]::new);
    }

    @Override
    public Object _execute(Context context) throws ExecutionException {
        long timeout;
        Context ctx = context.wrap();
        HashMap<String, Long> stateCounters = new HashMap<String, Long>();
        HashSet<Cell> stoppedCells = new HashSet<Cell>();
        AtomicReference<Object> exception = new AtomicReference<Object>(null);
        long totalScheduled = 0L;
        boolean doExit = false;
        ExecutionException doException = null;
        long limit = this.limitExpression == null ? -1L : Cast.toLong(this.limitExpression.execute(ctx));
        if (this.timeoutExpression != null) {
            Double dT = Cast.toDouble(this.timeoutExpression.execute(ctx));
            timeout = Double.valueOf(1.0E9 * dT).longValue();
        } else {
            timeout = -1L;
        }
        long startTime = System.nanoTime();
        try {
            HashSet<CompletableFuture<CellWithResult>> tasksRunning = new HashSet<CompletableFuture<CellWithResult>>();
            for (Cell startCell : this.startCells) {
                CompletableFuture<CellWithResult> startTask = this.startTask(ctx, startCell, exception, this.nextCounter(startCell.id, stateCounters));
                tasksRunning.add(startTask);
            }
            this.updateAndScheduleStart(ctx, tasksRunning, stateCounters, exception, stoppedCells);
            block4: while (!tasksRunning.isEmpty()) {
                CompletableFuture.anyOf((CompletableFuture[])tasksRunning.toArray(CompletableFuture[]::new)).join();
                long currentTime = System.nanoTime();
                if (timeout >= 0L && timeout <= currentTime - startTime) {
                    doExit = true;
                    doException = new ExecutionException("Flow '%s' timed out after %s ms", this.flowId, timeout / 1000000L);
                }
                while (true) {
                    Exception e;
                    if ((e = (Exception)exception.get()) != null) {
                        if (e instanceof ExecutionException) {
                            ExecutionException ee = (ExecutionException)e;
                            throw ee;
                        }
                        throw new ExecutionException(exception.get(), "Exception while executing flow '%s'.", this.flowId);
                    }
                    Optional<CompletableFuture> task = tasksRunning.stream().filter(CompletableFuture::isDone).findAny();
                    if (task.isEmpty()) continue block4;
                    tasksRunning.remove(task.get());
                    CellWithResult cnR = (CellWithResult)task.get().get();
                    if (doExit || (doExit = this.isExitConditionMet(ctx)) || cnR == null) continue;
                    if (cnR.result == Sentinel.FINI) {
                        stoppedCells.add(cnR.cell);
                        this.updateStateCounter(ctx, cnR, stateCounters);
                        continue;
                    }
                    if (cnR.result == Sentinel.NON_MUTAT) continue;
                    int nr = this.updateAndScheduleNewTasks(ctx, cnR, tasksRunning, exception, stateCounters, stoppedCells);
                    totalScheduled += (long)nr;
                    if (limit < 0L) continue;
                    if ((long)nr >= limit) {
                        doExit = true;
                        doException = new ExecutionException("Task limit has been reached in flow '%s' command after %d tasks.", this.flowId, totalScheduled);
                        continue;
                    }
                    limit -= (long)nr;
                }
            }
        }
        catch (ExecutionException e) {
            ExecutionException newException = new ExecutionException("While in flow '%s': %s", this.flowId, e.getMessage());
            newException.setStackTrace(e.getStackTrace());
            throw newException;
        }
        catch (Exception e) {
            throw new ExecutionException(e, "There was an exception while executing the flow '%s'", this.flowId);
        }
        if (doException != null) {
            throw doException;
        }
        if (this.resultExpression != null) {
            return this.resultExpression.execute(ctx);
        }
        return null;
    }

    private void updateAndScheduleStart(Context ctx, HashSet<CompletableFuture<CellWithResult>> tasksRunning, HashMap<String, Long> stateCounters, AtomicReference<Exception> exception, HashSet<Cell> stoppedCells) throws InterruptedException, java.util.concurrent.ExecutionException {
        CompletableFuture.allOf((CompletableFuture[])tasksRunning.toArray(CompletableFuture[]::new)).join();
        ArrayList<Runnable> newTasksSchedulers = new ArrayList<Runnable>();
        for (CompletableFuture<CellWithResult> task : tasksRunning) {
            CellWithResult cnR = task.get();
            if (exception.get() != null) {
                return;
            }
            boolean updated = this.updateCellVariable(ctx, cnR, stateCounters);
            if (updated) {
                newTasksSchedulers.add(() -> this.scheduleNewTasks(ctx, cnR, tasksRunning, exception, stateCounters, stoppedCells));
                continue;
            }
            throw new ExecutionException("Updating initial value '%s' failed. Probably double defined in initial state in flow '%s'", cnR.cell.id, this.flowId);
        }
        for (Runnable schedule : newTasksSchedulers) {
            schedule.run();
        }
    }

    private boolean isExitConditionMet(Context ctx) {
        if (this.exitCondition == null) {
            return false;
        }
        try {
            return Cast.toBoolean(this.exitCondition.execute(ctx));
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    private int updateAndScheduleNewTasks(Context ctx, CellWithResult cnR, HashSet<CompletableFuture<CellWithResult>> tasksRunning, AtomicReference<Exception> exception, Map<String, Long> stateCounters, HashSet<Cell> stoppedCells) {
        boolean updated = this.updateCellVariable(ctx, cnR, stateCounters);
        if (updated) {
            return this.scheduleNewTasks(ctx, cnR, tasksRunning, exception, stateCounters, stoppedCells);
        }
        return 0;
    }

    private int scheduleNewTasks(Context ctx, CellWithResult cnR, HashSet<CompletableFuture<CellWithResult>> tasksRunning, AtomicReference<Exception> exception, Map<String, Long> stateCounters, HashSet<Cell> stoppedCells) {
        int newTasksScheduled = 0;
        Cell[] dCells = this.dependentCells.get(cnR.cell.id);
        if (dCells != null) {
            for (Cell cell : dCells) {
                if (stoppedCells.contains(cell)) continue;
                tasksRunning.add(this.startTask(ctx, cell, exception, this.nextCounter(cell.id, stateCounters)));
                ++newTasksScheduled;
            }
        }
        return newTasksScheduled;
    }

    private boolean updateCellVariable(Context ctx, CellWithResult cnR, Map<String, Long> stateCounters) {
        boolean updated;
        Object oldValue = ctx.getLocal(cnR.cell.id);
        boolean bl = updated = (!ctx.contains0(cnR.cell.id) || this.calculatedValueIsNew(cnR, oldValue)) && this.notStale(cnR, stateCounters);
        if (updated) {
            this.saveState(ctx, cnR, stateCounters);
        }
        return updated;
    }

    private void saveState(Context ctx, CellWithResult cnR, Map<String, Long> stateCounters) {
        ctx.let0(cnR.cell.id, cnR.result);
        this.updateStateCounter(ctx, cnR, stateCounters);
    }

    private void updateStateCounter(Context ctx, CellWithResult cnR, Map<String, Long> stateCounters) {
        stateCounters.computeIfPresent(cnR.cell.id, (k, v) -> v + 1L);
    }

    private boolean notStale(CellWithResult cnR, Map<String, Long> stateCounters) {
        return stateCounters.containsKey(cnR.cell.id) && stateCounters.get(cnR.cell.id).equals(cnR.counter);
    }

    private boolean calculatedValueIsNew(CellWithResult cnR, Object oldValue) {
        return oldValue == null && cnR.result != null || oldValue != null && !oldValue.equals(cnR.result);
    }

    private CompletableFuture<CellWithResult> startTask(Context ctx, Cell cell, AtomicReference<Exception> exception, long counter) {
        Context newThreadContext = ctx.thread();
        FlowCommand.copyVariables(ctx, newThreadContext);
        return CompletableFuture.supplyAsync(() -> {
            Thread.currentThread().setName(cell.id + ":" + NameGen.generateName());
            try {
                return new CellWithResult(cell.command.execute(newThreadContext), cell, counter);
            }
            catch (ExecutionException e) {
                ExecutionException newException = new ExecutionException("Exception in flow '%s' in thread %s %s", this.flowId, Thread.currentThread().getName(), e.getMessage());
                newException.setStackTrace(e.getStackTrace());
                exception.compareAndSet(null, newException);
                return null;
            }
            catch (Exception t) {
                ExecutionException newException = new ExecutionException(t, "Exception in flow '%s' thread %s ", this.flowId, Thread.currentThread().getName());
                exception.compareAndSet(null, newException);
                return null;
            }
        }, executor);
    }

    private static void copyVariables(Context source, Context target) {
        for (String key : source.allLocalKeys()) {
            target.let0(key, source.get(key));
            target.freeze(key);
        }
    }

    record Cell(String id, Command command) {
        public static Cell factory(Unmarshaller.Args args) {
            return new Cell(args.str("id"), args.command("command"));
        }
    }

    record CellWithResult(Object result, Cell cell, Long counter) {
        public static CellWithResult factory(Unmarshaller.Args args) {
            return new CellWithResult(args.get("result", Object.class), args.get("cell", Cell.class), args.get("counter", Long.class));
        }
    }
}

