/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.ExecutionException;
import ch.turic.commands.Conditional;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class Cast {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isLong(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Short.class, Byte.class, Character.class, CharSequence.class}, (Object)object2, n)) {
            case 0: {
                Long ignore = (Long)object2;
                return true;
            }
            case 1: {
                Integer ignore = (Integer)object2;
                return true;
            }
            case 2: {
                Short ignore = (Short)object2;
                return true;
            }
            case 3: {
                Byte ignore = (Byte)object2;
                return true;
            }
            case 4: {
                Character ignore = (Character)object2;
                return true;
            }
            case 5: {
                int start;
                CharSequence cs = (CharSequence)object2;
                if (cs.isEmpty()) {
                    return false;
                }
                int i = start = cs.charAt(0) == '+' || cs.charAt(0) == '-' ? 1 : 0;
                while (i < cs.length()) {
                    if (!Character.isDigit(cs.charAt(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            default: {
                return false;
            }
        }
    }

    public static boolean isDouble(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Short.class, Byte.class, Character.class, Double.class, Float.class, CharSequence.class}, (Object)object2, n)) {
            case 0 -> {
                Long ignore = (Long)object2;
                yield true;
            }
            case 1 -> {
                Integer ignore = (Integer)object2;
                yield true;
            }
            case 2 -> {
                Short ignore = (Short)object2;
                yield true;
            }
            case 3 -> {
                Byte ignore = (Byte)object2;
                yield true;
            }
            case 4 -> {
                Character ignore = (Character)object2;
                yield true;
            }
            case 5 -> {
                Double ignore = (Double)object2;
                yield true;
            }
            case 6 -> {
                Float ignore = (Float)object2;
                yield true;
            }
            case 7 -> {
                int i;
                CharSequence cs = (CharSequence)object2;
                if (cs.isEmpty()) {
                    yield false;
                }
                int v2 = i = cs.charAt(0) == '+' || cs.charAt(0) == '-' ? 1 : 0;
                while (i < cs.length() && cs.charAt(i) != '.') {
                    if (!Character.isDigit(cs.charAt(i))) {
                        yield false;
                    }
                    ++i;
                }
                if (i >= cs.length()) {
                    yield true;
                }
                if (cs.charAt(i) != '.') {
                    yield false;
                }
                ++i;
                while (i < cs.length() && cs.charAt(i) != 'e' && cs.charAt(i) != 'E') {
                    if (!Character.isDigit(cs.charAt(i))) {
                        yield false;
                    }
                    ++i;
                }
                if (i < cs.length() && cs.charAt(i) != 'e' && cs.charAt(i) != 'E') {
                    yield false;
                }
                if (++i >= cs.length()) {
                    yield false;
                }
                if ((i += cs.charAt(i) == '+' || cs.charAt(i) == '-' ? 1 : 0) >= cs.length()) {
                    yield false;
                }
                while (i < cs.length()) {
                    if (!Character.isDigit(cs.charAt(i))) {
                        yield false;
                    }
                    ++i;
                }
                yield true;
            }
            default -> false;
        };
    }

    public static boolean isBoolean(Object test) throws ExecutionException {
        Object object = test;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Long.class, Integer.class, Short.class, Byte.class, Character.class, Double.class, Float.class, String.class}, (Object)object, n)) {
            case -1 -> true;
            case 0 -> {
                Boolean ignored1 = (Boolean)object;
                yield true;
            }
            case 1 -> {
                Long ignored = (Long)object;
                yield true;
            }
            case 2 -> {
                Integer ignored = (Integer)object;
                yield true;
            }
            case 3 -> {
                Short ignored = (Short)object;
                yield true;
            }
            case 4 -> {
                Byte ignored = (Byte)object;
                yield true;
            }
            case 5 -> {
                Character ignored = (Character)object;
                yield true;
            }
            case 6 -> {
                Double ignored = (Double)object;
                yield true;
            }
            case 7 -> {
                Float ignored = (Float)object;
                yield true;
            }
            case 8 -> {
                String ignored = (String)object;
                yield true;
            }
            default -> false;
        };
    }

    public static boolean toBoolean(Object test) throws ExecutionException {
        Object object = test;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Long.class, Integer.class, Short.class, Byte.class, Character.class, Double.class, Float.class, String.class}, (Object)object, n)) {
            case -1: {
                return false;
            }
            case 0: {
                Boolean b = (Boolean)object;
                return b;
            }
            case 1: {
                Long l = (Long)object;
                return l != 0L;
            }
            case 2: {
                Integer i = (Integer)object;
                return i != 0;
            }
            case 3: {
                Short s = (Short)object;
                return s != 0;
            }
            case 4: {
                Byte b = (Byte)object;
                return b != 0;
            }
            case 5: {
                Character c = (Character)object;
                return c.charValue() != '\u0000';
            }
            case 6: {
                Double d = (Double)object;
                return d != 0.0;
            }
            case 7: {
                Float f = (Float)object;
                return f.floatValue() != 0.0f;
            }
            case 8: {
                String s = (String)object;
                return s.equals("true");
            }
        }
        throw new ExecutionException("Value '" + String.valueOf(test) + "' cannot be used as a boolean", new Object[0]);
    }

    public static Long toLong(Object obj) throws ExecutionException {
        Long l;
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Short.class, Byte.class, Character.class, Double.class, Float.class, Boolean.class, CharSequence.class, Conditional.class}, (Object)object2, n)) {
            case 0: {
                Long l2;
                Long l3;
                l = l3 = (l2 = (Long)object2);
                break;
            }
            case 1: {
                Long l4;
                Integer i = (Integer)object2;
                l = l4 = Long.valueOf(i.intValue());
                break;
            }
            case 2: {
                Long l5;
                Short sh = (Short)object2;
                l = l5 = Long.valueOf(sh.shortValue());
                break;
            }
            case 3: {
                Long l6;
                Byte b = (Byte)object2;
                l = l6 = Long.valueOf(b.byteValue());
                break;
            }
            case 4: {
                Long l7;
                Character c = (Character)object2;
                l = l7 = Long.valueOf(c.charValue());
                break;
            }
            case 5: {
                Long l8;
                Double d = (Double)object2;
                ExecutionException.when(d > 9.223372036854776E18 || d < -9.223372036854776E18, "Value '%s' cannot be used as a long, too %s", d, d > 0.0 ? "large" : "small");
                ExecutionException.when(d % 1.0 != 0.0, "Value '%s' cannot be used as a long, it has fractions", d);
                l = l8 = Long.valueOf(d.longValue());
                break;
            }
            case 6: {
                Float ignore = (Float)object2;
                throw new ExecutionException("Cannot cast float to number", new Object[0]);
            }
            case 7: {
                Boolean ignore = (Boolean)object2;
                throw new ExecutionException("Cannot cast boolean to number", new Object[0]);
            }
            case 8: {
                CharSequence cs = (CharSequence)object2;
                try {
                    Long l9;
                    l = l9 = Long.valueOf(Long.parseLong(cs.toString()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ExecutionException("Cannot cast string to long", new Object[0]);
                }
            }
            case 9: {
                Conditional ignored = (Conditional)object2;
                throw new ExecutionException("Cannot cast break or return result to number", new Object[0]);
            }
            default: {
                throw new ExecutionException("Cannot cast object of types '" + obj.getClass().getName() + "' to long", new Object[0]);
            }
        }
        return l;
    }

    public static Double toDouble(Object obj) throws ExecutionException {
        Double d;
        Object object = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Short.class, Byte.class, Character.class, Double.class, Float.class, Boolean.class, CharSequence.class, Conditional.class}, (Object)object, n)) {
            case -1: {
                throw new ExecutionException("Cannot cast null to number", new Object[0]);
            }
            case 0: {
                Double d2;
                Long l = (Long)object;
                d = d2 = Double.valueOf(l.longValue());
                break;
            }
            case 1: {
                Double d3;
                Integer i = (Integer)object;
                d = d3 = Double.valueOf(i.intValue());
                break;
            }
            case 2: {
                Double d4;
                Short sh = (Short)object;
                d = d4 = Double.valueOf(sh.shortValue());
                break;
            }
            case 3: {
                Double d5;
                Byte b = (Byte)object;
                d = d5 = Double.valueOf(b.byteValue());
                break;
            }
            case 4: {
                Double d6;
                Character c = (Character)object;
                d = d6 = Double.valueOf(c.charValue());
                break;
            }
            case 5: {
                Double d7;
                Double d8;
                d = d8 = (d7 = (Double)object);
                break;
            }
            case 6: {
                Double d9;
                Float f = (Float)object;
                d = d9 = Double.valueOf(f.floatValue());
                break;
            }
            case 7: {
                Boolean ignore = (Boolean)object;
                throw new ExecutionException("Cannot cast boolean to number", new Object[0]);
            }
            case 8: {
                CharSequence cs = (CharSequence)object;
                try {
                    Double d10;
                    d = d10 = Double.valueOf(Double.parseDouble(cs.toString()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new ExecutionException("Cannot cast string to number", new Object[0]);
                }
            }
            case 9: {
                Conditional ignored = (Conditional)object;
                throw new ExecutionException("Cannot cast break or return result to number", new Object[0]);
            }
            default: {
                throw new ExecutionException("Cannot cast object of types '" + obj.getClass().getName() + "' to number", new Object[0]);
            }
        }
        return d;
    }
}

