/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.HasIndex;
import ch.turic.memory.LeftValue;
import java.util.Objects;
import java.util.function.Function;

public record CalculatedLeftValue(Command expression) implements LeftValue
{
    public CalculatedLeftValue(Command expression) {
        this.expression = Objects.requireNonNull(expression);
    }

    @Override
    public HasFields getObject(Context ctx) {
        Object existing = this.expression.execute(ctx);
        return LeftValue.toObject(existing);
    }

    @Override
    public HasIndex getIndexable(Context ctx, Object indexValue) {
        Object existing = this.expression.execute(ctx);
        return LeftValue.toIndexable(existing, indexValue);
    }

    @Override
    public void assign(Context ctx, Object value) throws ExecutionException {
        throw new ExecutionException("Cannot assign value to calculated left side", new Object[0]);
    }

    @Override
    public Object reassign(Context ctx, Function<Object, Object> newValueCalculator) throws ExecutionException {
        throw new ExecutionException("Cannot modify left value to calculated value", new Object[0]);
    }

    @Override
    public String toString() {
        return "{" + String.valueOf(this.expression) + "}";
    }
}

