/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.analyzer.AssignmentList;
import ch.turic.analyzer.DefaultExpressionAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Pos;
import ch.turic.commands.Command;
import ch.turic.commands.ParameterList;
import ch.turic.commands.TypeDeclaration;
import java.util.ArrayList;

public class ParameterDefinition {
    private final boolean forClosure;
    public static final ParameterDefinition INSTANCE = new ParameterDefinition(false);
    public static final ParameterDefinition FOR_CLOSURE = new ParameterDefinition(true);

    public ParameterDefinition(boolean forClosure) {
        this.forClosure = forClosure;
    }

    public ParameterList analyze(LexList lexes) throws BadSyntax {
        ArrayList<ParameterList.Parameter> commonParameters = new ArrayList<ParameterList.Parameter>();
        String rest = null;
        String meta = null;
        String closure = null;
        Pos position = lexes.position();
        while (lexes.peek().type() == Lex.Type.IDENTIFIER || lexes.is("@", "[", "!", "{", "^")) {
            Command defaultExpression;
            TypeDeclaration[] types;
            String id;
            ParameterList.Parameter.Type type;
            if (lexes.is("!")) {
                type = ParameterList.Parameter.Type.POSITIONAL_ONLY;
                lexes.next();
            } else if (lexes.is("@")) {
                lexes.next();
                type = ParameterList.Parameter.Type.NAMED_ONLY;
            } else {
                type = ParameterList.Parameter.Type.POSITIONAL_OR_NAMED;
            }
            boolean extraParam = lexes.is("[", "{", "^");
            BadSyntax.when(lexes, extraParam && type != ParameterList.Parameter.Type.POSITIONAL_OR_NAMED, "The parameter [rest], {meta} or |closure| cannot be named or positional, do not use ! or @ before it.", new Object[0]);
            if (extraParam) {
                String opening = lexes.next().text();
                BadSyntax.when(lexes, !lexes.isIdentifier(), "[rest], {meta} or |closure| opening character needs an identifier, it is missing", new Object[0]);
                id = lexes.next().text();
                String closing = switch (opening) {
                    case "[" -> {
                        BadSyntax.when(lexes, rest != null, "You cannot have more than one [rest] parameter", new Object[0]);
                        rest = id;
                        BadSyntax.when(lexes, meta != null || closure != null, "[rest] must not come after {meta} or |closure|.", new Object[0]);
                        yield "]";
                    }
                    case "{" -> {
                        BadSyntax.when(lexes, meta != null, "You cannot have more than one {meta} parameter", new Object[0]);
                        meta = id;
                        BadSyntax.when(lexes, closure != null, "{meta} must not come after |closure|.", new Object[0]);
                        yield "}";
                    }
                    case "^" -> {
                        BadSyntax.when(lexes, closure != null, "You cannot have more than one |closure| parameter", new Object[0]);
                        closure = id;
                        yield null;
                    }
                    default -> throw lexes.syntaxError("Something went wrong 7639/a2", new Object[0]);
                };
                if (closing != null) {
                    BadSyntax.when(lexes, lexes.isNot(closing), "'%s%s must be followed by %s", opening, id, closing);
                    lexes.next();
                }
                if (!lexes.is(",")) break;
                lexes.next();
                continue;
            }
            BadSyntax.when(lexes, !lexes.isIdentifier(), "Parameter name is expected", new Object[0]);
            BadSyntax.when(lexes, rest != null || meta != null || closure != null, "[rest], {meta} , and |clore| can stand only at the end of the parameter list.", new Object[0]);
            id = lexes.next().text();
            if (lexes.is(":")) {
                lexes.next();
                types = this.forClosure ? AssignmentList.getTheTypeDefinitionsClosureArgs(lexes) : AssignmentList.getTheTypeDefinitions(lexes);
            } else {
                types = AssignmentList.EMPTY_TYPE;
            }
            if (lexes.is("=")) {
                lexes.next();
                defaultExpression = DefaultExpressionAnalyzer.INSTANCE.analyze(lexes);
            } else {
                defaultExpression = null;
            }
            commonParameters.add(new ParameterList.Parameter(id, type, types, defaultExpression));
            if (!lexes.is(",")) break;
            lexes.next();
            BadSyntax.when(lexes, lexes.peek().type() != Lex.Type.IDENTIFIER && lexes.isNot("@", "[", "!", "{", "^"), "Identifier expected after ',' in parameter list", new Object[0]);
        }
        return new ParameterList((ParameterList.Parameter[])commonParameters.toArray(ParameterList.Parameter[]::new), rest, meta, closure, position);
    }
}

