/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.ExecutionException;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.commands.Command;
import ch.turic.commands.Identifier;
import ch.turic.commands.Pin;
import java.util.ArrayList;

public class PinAnalyzer
extends AbstractAnalyzer {
    public static final PinAnalyzer INSTANCE = new PinAnalyzer();

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        ArrayList<Pin.Item> items = new ArrayList<Pin.Item>();
        while (lexes.isIdentifier() || lexes.is("[", "{")) {
            Pin.Item.Type type;
            if (lexes.isIdentifier()) {
                type = Pin.Item.Type.VARIABLE;
            } else if (lexes.is("{")) {
                type = Pin.Item.Type.OBJECT;
                lexes.next();
            } else if (lexes.is("[")) {
                type = Pin.Item.Type.LIST;
                lexes.next();
            } else {
                throw new RuntimeException("Unreachable 68352");
            }
            if (!lexes.isIdentifier()) {
                throw new ExecutionException("Identifier expected in pin list", new Object[0]);
            }
            Identifier id = new Identifier(lexes.next().text());
            items.add(new Pin.Item(id, type));
            switch (type) {
                case VARIABLE: {
                    break;
                }
                case OBJECT: {
                    ExecutionException.when(lexes.isNot("}"), "} missing after object identifier in pin list", new Object[0]);
                    lexes.next();
                    break;
                }
                case LIST: {
                    ExecutionException.when(lexes.isNot("]"), "] missing after list identifier in pin list", new Object[0]);
                    lexes.next();
                    break;
                }
                default: {
                    throw new ExecutionException("Unreachable 68353", new Object[0]);
                }
            }
            if (lexes.isNot(",")) break;
            lexes.next();
        }
        return new Pin((Pin.Item[])items.toArray(Pin.Item[]::new));
    }
}

