/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.classes;

import ch.turic.ExecutionException;
import ch.turic.LngCallable;
import ch.turic.TuriClass;
import ch.turic.builtins.classes.TuriMethod;
import ch.turic.memory.Channel;
import ch.turic.memory.ChannelIterator;
import java.util.NoSuchElementException;

public class TuriChannel
implements TuriClass {
    @Override
    public Class<?> forClass() {
        return ChannelIterator.class;
    }

    @Override
    public LngCallable getMethod(Object target, String identifier) {
        if (!(target instanceof ChannelIterator)) {
            throw new ExecutionException("Target object is not a Channel, this is an internal error", new Object[0]);
        }
        ChannelIterator channelIterator = (ChannelIterator)target;
        return switch (identifier) {
            case "close" -> new TuriMethod<Object>(() -> {
                channelIterator.close();
                return null;
            });
            case "is_closed" -> new TuriMethod<Boolean>(channelIterator::isClosed);
            case "receive" -> new TuriMethod<Object>(() -> {
                try {
                    return channelIterator.receive().get();
                }
                catch (Exception e) {
                    throw new ExecutionException("Execution exception while reading from queue.", new Object[]{e});
                }
            });
            case "try_receive" -> new TuriMethod<Object>(() -> {
                try {
                    Channel.Message msg = channelIterator.tryReceive();
                    if (msg == null) {
                        return null;
                    }
                    return msg.get();
                }
                catch (NoSuchElementException nse) {
                    return null;
                }
                catch (Exception e) {
                    throw new ExecutionException("Execution exception while reading from queue.", new Object[]{e});
                }
            });
            case "send" -> new TuriMethod<Boolean>(sendArgs -> {
                try {
                    channelIterator.send(Channel.Message.of(sendArgs[0]));
                    return true;
                }
                catch (Exception e) {
                    throw new ExecutionException("Execution exception while sending message to queue %s", e.getMessage());
                }
            });
            case "try_send" -> new TuriMethod<Boolean>(trySendArgs -> {
                try {
                    return channelIterator.trySend(Channel.Message.of(trySendArgs[0]));
                }
                catch (Exception e) {
                    throw new ExecutionException("Execution exception while sending message to queue %s", e.getMessage());
                }
            });
            default -> throw new ExecutionException("Unknown method %s", identifier);
        };
    }
}

