/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.memory.ClassContext;
import ch.turic.memory.LngClass;
import ch.turic.memory.LngObject;

public class IsType
implements TuriFunction {
    @Override
    public String name() {
        return "is_type";
    }

    @Override
    public Object call(Context context, Object[] args) throws ExecutionException {
        FunUtils.twoArgs(this.name(), args);
        Object obj = args[0];
        Object type = args[1];
        if (!(obj instanceof LngObject)) {
            return false;
        }
        LngObject lngObject = (LngObject)obj;
        if (type instanceof String) {
            String typeName = (String)type;
            return IsType.isType(lngObject.lngClass(), typeName);
        }
        if (type instanceof LngClass) {
            LngClass lngClass = (LngClass)type;
            return IsType.isType(lngObject.lngClass(), lngClass);
        }
        return false;
    }

    private static boolean isType(LngClass lngClass, LngClass type) {
        if (lngClass.equals(type)) {
            return true;
        }
        for (LngClass p : ((ClassContext)lngClass.context()).parents()) {
            if (!IsType.isType(p, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isType(LngClass lngClass, String type) {
        if (lngClass.name().equals(type)) {
            return true;
        }
        for (LngClass p : ((ClassContext)lngClass.context()).parents()) {
            if (!IsType.isType(p, type)) continue;
            return true;
        }
        return false;
    }
}

