/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.LngList;
import ch.turic.memory.Range;
import java.util.Iterator;
import java.util.Set;

public class Rng
implements TuriFunction {
    @Override
    public String name() {
        return "rng";
    }

    @Override
    public Object call(Context context, Object[] args) throws ExecutionException {
        long step;
        if (args.length > 3) {
            throw new ExecutionException("%s expects two or three arguments", this.name());
        }
        Long start = Cast.toLong(args[0]);
        Long end = Cast.toLong(args[1]);
        long l = args.length > 2 ? Cast.toLong(args[2]) : (step = (long)(end > start ? 1 : -1));
        if (end > start && step < 0L || end < start && step > 0L) {
            throw new ExecutionException("rng(%s,%s,%s) would never end", start, end, step);
        }
        if (step == 0L && start.equals(end)) {
            return new LongRange(start, end, 1L);
        }
        return new LongRange(start, end, step);
    }

    public static final class LongRange
    extends LngList {
        private final long start;
        private final long end;
        private final long step;
        private final long length;

        public LongRange(long start, long end, long step) {
            if (step == 0L) {
                throw new ExecutionException("rng(%s,%s,%s) has zero step size", start, end, step);
            }
            this.start = start;
            this.end = end;
            this.step = step;
            this.length = (end - start) / step;
        }

        @Override
        public Set<String> fields() {
            return super.fields();
        }

        @Override
        public Object getField(String name) throws ExecutionException {
            switch (name) {
                case "length": {
                    break;
                }
                default: {
                    throw new ExecutionException(name + " is not a valid field name for an array", new Object[0]);
                }
            }
            return this.length;
        }

        @Override
        public Object getIndex(Object index) throws ExecutionException {
            if (Cast.isLong(index)) {
                int indexValue = Cast.toLong(index).intValue();
                ExecutionException.when(indexValue < 0, "Indexing error, %s < 0", indexValue);
                if ((long)indexValue >= this.length) {
                    return null;
                }
                return this.start + (long)indexValue * this.step;
            }
            if (index instanceof Range) {
                Range range = (Range)index;
                int newStart = range.getStart((int)this.length);
                int newEnd = range.getEnd((int)this.length);
                return new LongRange(this.start + (long)newStart * this.step, this.start + (long)newEnd * this.step, this.step);
            }
            throw new ExecutionException("You cannot use '%s' as index", index);
        }

        @Override
        public Iterator<Object> iterator() {
            return new LongIterator(this.start, this.end, this.step);
        }

        @Override
        public void setField(String name, Object value) throws ExecutionException {
            throw new ExecutionException(name + " cannot be set on a number range", new Object[0]);
        }

        @Override
        public void setIndex(Object index, Object value) throws ExecutionException {
            throw new ExecutionException(String.valueOf(index) + " cannot be set on a number range", new Object[0]);
        }

        @Override
        public String toString() {
            if (this.length < 5L) {
                StringBuilder builder = new StringBuilder("[");
                String[] sep = new String[]{""};
                new LongIterator(this.start, this.end, this.step).forEachRemaining(x -> {
                    builder.append(sep[0]).append(x);
                    sep[0] = ", ";
                });
                builder.append(']');
                return builder.toString();
            }
            return "[" + this.start + ", " + (this.start + this.step) + ", " + (this.start + 2L * this.step) + ",..., " + (this.start + (this.length - 2L) * this.step) + ", " + (this.start + (this.length - 1L) * this.step) + "]";
        }

        private static class LongIterator
        implements Iterator<Object> {
            private long current;
            private final long end;
            private final long step;

            private LongIterator(long start, long end, long step) {
                this.current = start;
                this.end = end;
                this.step = step;
            }

            @Override
            public boolean hasNext() {
                if (this.step < 0L) {
                    return this.current > this.end;
                }
                return this.current < this.end;
            }

            @Override
            public Long next() {
                long result = this.current;
                this.current += this.step;
                return result;
            }
        }
    }
}

