/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Command;
import ch.turic.commands.Conditional;
import ch.turic.memory.Context;

public class BlockCommand
extends AbstractCommand {
    public static final BlockCommand EMPTY_BLOCK = new BlockCommand(new Command[0], true);
    final Command[] commands;
    final boolean wrap;

    public Command[] commands() {
        return this.commands;
    }

    public boolean wrap() {
        return this.wrap;
    }

    public BlockCommand(Command[] commands, boolean wrap) {
        this.commands = commands;
        this.wrap = wrap;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        ctx.step();
        if (this.wrap) {
            Context blockContext = ctx.wrap();
            return BlockCommand.conditionalOrResult(this.loop(blockContext));
        }
        return BlockCommand.conditionalOrResult(this.loop(ctx));
    }

    private static Object conditionalOrResult(Conditional cResult) {
        if (cResult instanceof Conditional.BreakResult) {
            return cResult.result();
        }
        return cResult.isDone() ? cResult : cResult.result();
    }

    private Conditional loop(Context context) {
        Object result = null;
        for (Command cmd : this.commands) {
            result = cmd.execute(context);
            if (!(result instanceof Conditional)) continue;
            Conditional cResult = (Conditional)result;
            if (cResult.isDone()) {
                return cResult;
            }
            result = cResult.result();
        }
        return Conditional.result(result);
    }
}

