/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.Command;
import ch.turic.commands.Loop;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.Context;
import ch.turic.memory.LngList;

public class ForLoop
extends Loop {
    public final Command startCommand;
    public final Command loopCondition;
    public final Command exitCondition;
    public final Command stepCommand;
    public final Command body;
    final boolean resultList;

    public Command body() {
        return this.body;
    }

    @Override
    public Command exitCondition() {
        return this.exitCondition;
    }

    public Command loopCondition() {
        return this.loopCondition;
    }

    public Command startCommand() {
        return this.startCommand;
    }

    public Command stepCommand() {
        return this.stepCommand;
    }

    public ForLoop(Command startCommand, Command loopCondition, Command exitCondition, Command stepCommand, boolean resultList, Command body) {
        this.startCommand = startCommand;
        this.loopCondition = loopCondition;
        this.exitCondition = exitCondition;
        this.stepCommand = stepCommand;
        this.resultList = resultList;
        this.body = body;
    }

    @Override
    public Object _execute(Context context) throws ExecutionException {
        Object lp = null;
        LngList listResult = this.resultList ? new LngList() : null;
        context.step();
        Context loopContext = context.wrap();
        if (this.startCommand != null) {
            this.startCommand.execute(loopContext);
        }
        while (Cast.toBoolean(this.loopCondition.execute(loopContext))) {
            Context innerContext = loopContext.wrap();
            try (Context.ContextLock x = loopContext.lock();){
                lp = this.loopCore(this.body, innerContext, listResult);
            }
            if (ForLoop.breakLoop(lp)) {
                return ForLoop.normalize(lp);
            }
            lp = ForLoop.normalize(lp);
            if (this.exitLoop(innerContext)) break;
            if (this.stepCommand == null) continue;
            this.stepCommand.execute(loopContext);
        }
        return this.resultList ? listResult : lp;
    }
}

