/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.analyzer.AssignmentList;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.TypeDeclaration;
import ch.turic.memory.Context;

public class LetAssignment
extends AbstractCommand {
    final AssignmentList.Assignment[] assignments;
    final boolean mut;

    public AssignmentList.Assignment[] assignments() {
        return this.assignments;
    }

    public LetAssignment(AssignmentList.Assignment[] assignments, boolean mut) {
        this.assignments = assignments;
        this.mut = mut;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        Object value = null;
        for (AssignmentList.Assignment assignment : this.assignments) {
            String[] typeNames;
            ctx.step();
            if (assignment.types() == null) {
                typeNames = null;
            } else {
                typeNames = new String[assignment.types().length];
                for (int i = 0; i < assignment.types().length; ++i) {
                    TypeDeclaration type = assignment.types()[i];
                    typeNames[i] = type.calculateTypeName(ctx);
                }
            }
            if (assignment.expression() == null) {
                ctx.define(assignment.identifier(), null, typeNames);
                ctx.local(assignment.identifier(), null);
                if (this.mut) continue;
                ctx.freeze(assignment.identifier());
                continue;
            }
            value = assignment.expression().execute(ctx);
            ctx.defineTypeChecked(assignment.identifier(), value, typeNames);
            if (this.mut) continue;
            ctx.freeze(assignment.identifier());
        }
        return value;
    }
}

