/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.BlockCommand;
import ch.turic.commands.Command;
import ch.turic.commands.Conditional;
import ch.turic.commands.ContinueCommand;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.Context;
import ch.turic.memory.LngList;
import ch.turic.memory.Sentinel;

public abstract class Loop
extends AbstractCommand {
    public abstract Command exitCondition();

    public boolean exitLoop(Context ctx) {
        return Cast.toBoolean(this.exitCondition().execute(ctx));
    }

    public static boolean breakLoop(Object lp) {
        Conditional c;
        return lp instanceof Conditional && (c = (Conditional)lp).isDone();
    }

    public static Object normalize(Object lp) {
        if (lp instanceof Conditional) {
            Conditional c = (Conditional)lp;
            if (c.result() == Sentinel.NO_VALUE) {
                return null;
            }
            if (lp instanceof Conditional.BreakResult) {
                return c.result();
            }
        }
        return lp;
    }

    public Object loopCore(Command body, Context ctx, LngList listResult) {
        if (listResult == null) {
            return this.loopCoreForObject(body, ctx);
        }
        return this.loopCoreList(body, ctx, listResult);
    }

    public Object loopCoreForObject(Command body, Context ctx) {
        if (body instanceof BlockCommand) {
            BlockCommand block = (BlockCommand)body;
            return this.loop(ctx, block, false);
        }
        return Loop.singleCommandExecutionForObject(body, ctx);
    }

    private Object loopCoreList(Command body, Context ctx, LngList listResult) {
        if (body instanceof BlockCommand) {
            BlockCommand block = (BlockCommand)body;
            Conditional conditional = this.loop(ctx, block, true);
            if (conditional != null) {
                if (conditional.result() != Sentinel.NO_VALUE) {
                    listResult.array.add(conditional.result());
                }
                if (conditional.isDone()) {
                    return Conditional.doBreak(listResult);
                }
            }
        } else {
            return Loop.singleCommandExecutionForList(body, ctx, listResult);
        }
        return listResult;
    }

    private Conditional loop(Context context, BlockCommand block, boolean resultList) {
        Object result = null;
        for (Command cmd : block.commands) {
            if (cmd instanceof ContinueCommand) {
                ContinueCommand continueCommand = (ContinueCommand)cmd;
                if (!resultList && continueCommand.expression != null) {
                    throw new ExecutionException("You cannot 'continue' with a value in a non-list resulting loop.", new Object[0]);
                }
                boolean doContinue = continueCommand.condition == null ? true : Cast.toBoolean(continueCommand.condition.execute(context));
                if (doContinue) {
                    if (continueCommand.expression == null) {
                        return null;
                    }
                    return Conditional.result(continueCommand.expression.execute(context));
                }
            } else {
                result = cmd.execute(context);
            }
            if (!(result instanceof Conditional)) continue;
            Conditional cResult = (Conditional)result;
            if (cResult.isDone()) {
                return cResult;
            }
            result = cResult.result();
        }
        return Conditional.result(result);
    }

    private static LngList singleCommandExecutionForList(Command body, Context ctx, LngList listResult) {
        listResult.array.add(body.execute(ctx));
        return listResult;
    }

    private static Object singleCommandExecutionForObject(Command body, Context ctx) {
        return body.execute(ctx);
    }
}

