/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.ExecutionException;
import ch.turic.commands.Command;
import ch.turic.commands.operators.AbstractOperator;
import ch.turic.commands.operators.Cast;
import ch.turic.commands.operators.Operator;
import ch.turic.commands.operators.Reflect;
import ch.turic.memory.Context;

@Operator.Symbol(value="/")
public class Divide
extends AbstractOperator {
    @Override
    public Object binaryOp(Context ctx, Object op1, Command right) throws ExecutionException {
        Object op2 = right.execute(ctx);
        if (Cast.isLong(op1) && Cast.isLong(op2)) {
            Long lop1 = Cast.toLong(op1);
            Long lop2 = Cast.toLong(op2);
            ExecutionException.when(lop2 == 0L, "Cannot divide by zero", new Object[0]);
            if (lop1 % lop2 == 0L) {
                return lop1 / lop2;
            }
        }
        if (Cast.isDouble(op1) || Cast.isDouble(op2)) {
            Double dop1 = Cast.toDouble(op1);
            Double dop2 = Cast.toDouble(op2);
            ExecutionException.when(dop2 == 0.0, "Cannot divide by zero", new Object[0]);
            return dop1 / dop2;
        }
        return Reflect.getBinaryMethod("divide", op1, op2).map(Reflect.Op::callMethod).orElseThrow(() -> new ExecutionException("Cannot '%s' + '%s'", op1, op2));
    }
}

