/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.ExecutionException;
import ch.turic.commands.Command;
import ch.turic.commands.operators.Add;
import ch.turic.commands.operators.And;
import ch.turic.commands.operators.BNot;
import ch.turic.commands.operators.Band;
import ch.turic.commands.operators.Bor;
import ch.turic.commands.operators.Compare;
import ch.turic.commands.operators.Contains;
import ch.turic.commands.operators.Divide;
import ch.turic.commands.operators.Mod;
import ch.turic.commands.operators.Multiply;
import ch.turic.commands.operators.Not;
import ch.turic.commands.operators.Or;
import ch.turic.commands.operators.Pipe;
import ch.turic.commands.operators.RangeOp;
import ch.turic.commands.operators.ShiftLeft;
import ch.turic.commands.operators.ShiftRight;
import ch.turic.commands.operators.ShiftRightSigned;
import ch.turic.commands.operators.Subtract;
import ch.turic.commands.operators.Xor;
import ch.turic.memory.Context;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;

public interface Operator {
    public static final Operator[] OPERATOR_ARRAY = new Operator[]{new Add(), new Subtract(), new Multiply(), new Divide(), new Mod(), new Compare.Equal(), new Compare.Same(), new Compare.NotEqual(), new Compare.LessOrEqual(), new Compare.LessThan(), new Compare.GreaterOrEqual(), new Compare.GreaterThan(), new And(), new Or(), new Not(), new BNot(), new Pipe(), new RangeOp(), new ShiftLeft(), new ShiftRight(), new ShiftRightSigned(), new Contains(), new Xor(), new Bor(), new Band()};
    public static final Map<String, Operator> OPERATORS = Operator.register();

    private static Map<String, Operator> register() {
        HashMap<String, Operator> map = new HashMap<String, Operator>();
        for (Operator operator : OPERATOR_ARRAY) {
            Operator old = map.put(operator.symbol(), operator);
            if (old == null) continue;
            throw new IllegalStateException("Duplicate operator name: " + operator.symbol());
        }
        return map;
    }

    public Object execute(Context var1, Command var2, Command var3) throws ExecutionException;

    default public String symbol() {
        Symbol s = this.getClass().getAnnotation(Symbol.class);
        if (s == null) {
            throw new IllegalArgumentException("No name annotation present");
        }
        return s.value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Symbol {
        public String value();
    }
}

