/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.TuriClass;
import ch.turic.memory.Context;
import ch.turic.memory.Variable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class GlobalContext {
    public Map<String, Variable> heap = new HashMap<String, Variable>();
    private final Context top;
    public final AtomicBoolean isMultiThreading = new AtomicBoolean(false);
    public final int stepLimit;
    public final AtomicInteger steps = new AtomicInteger();
    private final Map<Class<?>, TuriClass> turiClasses = new HashMap();

    public GlobalContext(int stepLimit, Context top) {
        this.stepLimit = stepLimit;
        this.top = top;
    }

    public TuriClass getTuriClass(Class<?> clazz) {
        return this.turiClasses.get(clazz);
    }

    public void addTuriClass(Class<?> clazz, TuriClass turiClass) throws ExecutionException {
        ExecutionException.when(this.turiClasses.containsKey(clazz), "Class " + clazz.getName() + " already exists as a turi class.", new Object[0]);
        this.turiClasses.put(clazz, turiClass);
    }

    public void step() throws ExecutionException {
        if (this.stepLimit < 0) {
            return;
        }
        if (this.stepLimit <= this.steps.get()) {
            throw new ExecutionException("Step limit %d reached", this.stepLimit);
        }
        this.steps.incrementAndGet();
    }

    public void switchToMultithreading() {
        if (this.isMultiThreading.compareAndSet(false, true)) {
            this.heap = new ConcurrentHashMap<String, Variable>(this.heap);
            this.top.frame = this.heap;
        }
    }
}

