/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.memory.LngStackFrame;
import ch.turic.memory.Yielder;
import java.util.ArrayList;
import java.util.List;

public class ThreadContext {
    private Yielder yielder = null;
    private final List<LngStackFrame> trace = new ArrayList<LngStackFrame>();

    public int traceSize() {
        return this.trace.size();
    }

    public void resetTrace(int size) {
        List<LngStackFrame> safe = this.getStackTrace();
        this.trace.clear();
        for (int i = 0; i < size; ++i) {
            this.trace.add(safe.get(i));
        }
    }

    public List<LngStackFrame> getStackTrace() {
        return new ArrayList<LngStackFrame>(this.trace);
    }

    public void push(LngStackFrame frame) {
        this.trace.add(frame);
    }

    public void pop() {
        this.trace.removeLast();
    }

    public Yielder yielder() throws ExecutionException {
        return this.yielder;
    }

    public void addYielder(Yielder yielder) throws ExecutionException {
        this.yielder = yielder;
    }
}

