package ch.turic.utils;

import java.util.HashMap;
import java.util.Map;


public class CaseFolder {

    public static String casefold(String input) {
        if (input == null) return null;

        StringBuilder sb = new StringBuilder();
        input.codePoints().forEach(cp -> {
            String folded = CASEFOLD_MAP.get(cp);
            if (folded != null) {
                sb.append(folded);
            } else {
                sb.appendCodePoint(Character.toLowerCase(cp));
            }
        });

        return sb.toString();
    }

    private static final Map<Integer, String> CASEFOLD_MAP = new HashMap<>();

    static {

        CASEFOLD_MAP.put(0x0041, "\u0061");
        CASEFOLD_MAP.put(0x0042, "\u0062");
        CASEFOLD_MAP.put(0x0043, "\u0063");
        CASEFOLD_MAP.put(0x0044, "\u0064");
        CASEFOLD_MAP.put(0x0045, "\u0065");
        CASEFOLD_MAP.put(0x0046, "\u0066");
        CASEFOLD_MAP.put(0x0047, "\u0067");
        CASEFOLD_MAP.put(0x0048, "\u0068");
        CASEFOLD_MAP.put(0x0049, "\u0069");
        CASEFOLD_MAP.put(0x004A, "\u006A");
        CASEFOLD_MAP.put(0x004B, "\u006B");
        CASEFOLD_MAP.put(0x004C, "\u006C");
        CASEFOLD_MAP.put(0x004D, "\u006D");
        CASEFOLD_MAP.put(0x004E, "\u006E");
        CASEFOLD_MAP.put(0x004F, "\u006F");
        CASEFOLD_MAP.put(0x0050, "\u0070");
        CASEFOLD_MAP.put(0x0051, "\u0071");
        CASEFOLD_MAP.put(0x0052, "\u0072");
        CASEFOLD_MAP.put(0x0053, "\u0073");
        CASEFOLD_MAP.put(0x0054, "\u0074");
        CASEFOLD_MAP.put(0x0055, "\u0075");
        CASEFOLD_MAP.put(0x0056, "\u0076");
        CASEFOLD_MAP.put(0x0057, "\u0077");
        CASEFOLD_MAP.put(0x0058, "\u0078");
        CASEFOLD_MAP.put(0x0059, "\u0079");
        CASEFOLD_MAP.put(0x005A, "\u007A");
        CASEFOLD_MAP.put(0x00B5, "\u03BC");
        CASEFOLD_MAP.put(0x00C0, "\u00E0");
        CASEFOLD_MAP.put(0x00C1, "\u00E1");
        CASEFOLD_MAP.put(0x00C2, "\u00E2");
        CASEFOLD_MAP.put(0x00C3, "\u00E3");
        CASEFOLD_MAP.put(0x00C4, "\u00E4");
        CASEFOLD_MAP.put(0x00C5, "\u00E5");
        CASEFOLD_MAP.put(0x00C6, "\u00E6");
        CASEFOLD_MAP.put(0x00C7, "\u00E7");
        CASEFOLD_MAP.put(0x00C8, "\u00E8");
        CASEFOLD_MAP.put(0x00C9, "\u00E9");
        CASEFOLD_MAP.put(0x00CA, "\u00EA");
        CASEFOLD_MAP.put(0x00CB, "\u00EB");
        CASEFOLD_MAP.put(0x00CC, "\u00EC");
        CASEFOLD_MAP.put(0x00CD, "\u00ED");
        CASEFOLD_MAP.put(0x00CE, "\u00EE");
        CASEFOLD_MAP.put(0x00CF, "\u00EF");
        CASEFOLD_MAP.put(0x00D0, "\u00F0");
        CASEFOLD_MAP.put(0x00D1, "\u00F1");
        CASEFOLD_MAP.put(0x00D2, "\u00F2");
        CASEFOLD_MAP.put(0x00D3, "\u00F3");
        CASEFOLD_MAP.put(0x00D4, "\u00F4");
        CASEFOLD_MAP.put(0x00D5, "\u00F5");
        CASEFOLD_MAP.put(0x00D6, "\u00F6");
        CASEFOLD_MAP.put(0x00D8, "\u00F8");
        CASEFOLD_MAP.put(0x00D9, "\u00F9");
        CASEFOLD_MAP.put(0x00DA, "\u00FA");
        CASEFOLD_MAP.put(0x00DB, "\u00FB");
        CASEFOLD_MAP.put(0x00DC, "\u00FC");
        CASEFOLD_MAP.put(0x00DD, "\u00FD");
        CASEFOLD_MAP.put(0x00DE, "\u00FE");
        CASEFOLD_MAP.put(0x00DF, "\u0073\u0073");
        CASEFOLD_MAP.put(0x0100, "\u0101");
        CASEFOLD_MAP.put(0x0102, "\u0103");
        CASEFOLD_MAP.put(0x0104, "\u0105");
        CASEFOLD_MAP.put(0x0106, "\u0107");
        CASEFOLD_MAP.put(0x0108, "\u0109");
        CASEFOLD_MAP.put(0x010A, "\u010B");
        CASEFOLD_MAP.put(0x010C, "\u010D");
        CASEFOLD_MAP.put(0x010E, "\u010F");
        CASEFOLD_MAP.put(0x0110, "\u0111");
        CASEFOLD_MAP.put(0x0112, "\u0113");
        CASEFOLD_MAP.put(0x0114, "\u0115");
        CASEFOLD_MAP.put(0x0116, "\u0117");
        CASEFOLD_MAP.put(0x0118, "\u0119");
        CASEFOLD_MAP.put(0x011A, "\u011B");
        CASEFOLD_MAP.put(0x011C, "\u011D");
        CASEFOLD_MAP.put(0x011E, "\u011F");
        CASEFOLD_MAP.put(0x0120, "\u0121");
        CASEFOLD_MAP.put(0x0122, "\u0123");
        CASEFOLD_MAP.put(0x0124, "\u0125");
        CASEFOLD_MAP.put(0x0126, "\u0127");
        CASEFOLD_MAP.put(0x0128, "\u0129");
        CASEFOLD_MAP.put(0x012A, "\u012B");
        CASEFOLD_MAP.put(0x012C, "\u012D");
        CASEFOLD_MAP.put(0x012E, "\u012F");
        CASEFOLD_MAP.put(0x0130, "\u0069\u0307");
        CASEFOLD_MAP.put(0x0132, "\u0133");
        CASEFOLD_MAP.put(0x0134, "\u0135");
        CASEFOLD_MAP.put(0x0136, "\u0137");
        CASEFOLD_MAP.put(0x0139, "\u013A");
        CASEFOLD_MAP.put(0x013B, "\u013C");
        CASEFOLD_MAP.put(0x013D, "\u013E");
        CASEFOLD_MAP.put(0x013F, "\u0140");
        CASEFOLD_MAP.put(0x0141, "\u0142");
        CASEFOLD_MAP.put(0x0143, "\u0144");
        CASEFOLD_MAP.put(0x0145, "\u0146");
        CASEFOLD_MAP.put(0x0147, "\u0148");
        CASEFOLD_MAP.put(0x0149, "\u02BC\u006E");
        CASEFOLD_MAP.put(0x014A, "\u014B");
        CASEFOLD_MAP.put(0x014C, "\u014D");
        CASEFOLD_MAP.put(0x014E, "\u014F");
        CASEFOLD_MAP.put(0x0150, "\u0151");
        CASEFOLD_MAP.put(0x0152, "\u0153");
        CASEFOLD_MAP.put(0x0154, "\u0155");
        CASEFOLD_MAP.put(0x0156, "\u0157");
        CASEFOLD_MAP.put(0x0158, "\u0159");
        CASEFOLD_MAP.put(0x015A, "\u015B");
        CASEFOLD_MAP.put(0x015C, "\u015D");
        CASEFOLD_MAP.put(0x015E, "\u015F");
        CASEFOLD_MAP.put(0x0160, "\u0161");
        CASEFOLD_MAP.put(0x0162, "\u0163");
        CASEFOLD_MAP.put(0x0164, "\u0165");
        CASEFOLD_MAP.put(0x0166, "\u0167");
        CASEFOLD_MAP.put(0x0168, "\u0169");
        CASEFOLD_MAP.put(0x016A, "\u016B");
        CASEFOLD_MAP.put(0x016C, "\u016D");
        CASEFOLD_MAP.put(0x016E, "\u016F");
        CASEFOLD_MAP.put(0x0170, "\u0171");
        CASEFOLD_MAP.put(0x0172, "\u0173");
        CASEFOLD_MAP.put(0x0174, "\u0175");
        CASEFOLD_MAP.put(0x0176, "\u0177");
        CASEFOLD_MAP.put(0x0178, "\u00FF");
        CASEFOLD_MAP.put(0x0179, "\u017A");
        CASEFOLD_MAP.put(0x017B, "\u017C");
        CASEFOLD_MAP.put(0x017D, "\u017E");
        CASEFOLD_MAP.put(0x017F, "\u0073");
        CASEFOLD_MAP.put(0x0181, "\u0253");
        CASEFOLD_MAP.put(0x0182, "\u0183");
        CASEFOLD_MAP.put(0x0184, "\u0185");
        CASEFOLD_MAP.put(0x0186, "\u0254");
        CASEFOLD_MAP.put(0x0187, "\u0188");
        CASEFOLD_MAP.put(0x0189, "\u0256");
        CASEFOLD_MAP.put(0x018A, "\u0257");
        CASEFOLD_MAP.put(0x018B, "\u018C");
        CASEFOLD_MAP.put(0x018E, "\u01DD");
        CASEFOLD_MAP.put(0x018F, "\u0259");
        CASEFOLD_MAP.put(0x0190, "\u025B");
        CASEFOLD_MAP.put(0x0191, "\u0192");
        CASEFOLD_MAP.put(0x0193, "\u0260");
        CASEFOLD_MAP.put(0x0194, "\u0263");
        CASEFOLD_MAP.put(0x0196, "\u0269");
        CASEFOLD_MAP.put(0x0197, "\u0268");
        CASEFOLD_MAP.put(0x0198, "\u0199");
        CASEFOLD_MAP.put(0x019C, "\u026F");
        CASEFOLD_MAP.put(0x019D, "\u0272");
        CASEFOLD_MAP.put(0x019F, "\u0275");
        CASEFOLD_MAP.put(0x01A0, "\u01A1");
        CASEFOLD_MAP.put(0x01A2, "\u01A3");
        CASEFOLD_MAP.put(0x01A4, "\u01A5");
        CASEFOLD_MAP.put(0x01A6, "\u0280");
        CASEFOLD_MAP.put(0x01A7, "\u01A8");
        CASEFOLD_MAP.put(0x01A9, "\u0283");
        CASEFOLD_MAP.put(0x01AC, "\u01AD");
        CASEFOLD_MAP.put(0x01AE, "\u0288");
        CASEFOLD_MAP.put(0x01AF, "\u01B0");
        CASEFOLD_MAP.put(0x01B1, "\u028A");
        CASEFOLD_MAP.put(0x01B2, "\u028B");
        CASEFOLD_MAP.put(0x01B3, "\u01B4");
        CASEFOLD_MAP.put(0x01B5, "\u01B6");
        CASEFOLD_MAP.put(0x01B7, "\u0292");
        CASEFOLD_MAP.put(0x01B8, "\u01B9");
        CASEFOLD_MAP.put(0x01BC, "\u01BD");
        CASEFOLD_MAP.put(0x01C4, "\u01C6");
        CASEFOLD_MAP.put(0x01C5, "\u01C6");
        CASEFOLD_MAP.put(0x01C7, "\u01C9");
        CASEFOLD_MAP.put(0x01C8, "\u01C9");
        CASEFOLD_MAP.put(0x01CA, "\u01CC");
        CASEFOLD_MAP.put(0x01CB, "\u01CC");
        CASEFOLD_MAP.put(0x01CD, "\u01CE");
        CASEFOLD_MAP.put(0x01CF, "\u01D0");
        CASEFOLD_MAP.put(0x01D1, "\u01D2");
        CASEFOLD_MAP.put(0x01D3, "\u01D4");
        CASEFOLD_MAP.put(0x01D5, "\u01D6");
        CASEFOLD_MAP.put(0x01D7, "\u01D8");
        CASEFOLD_MAP.put(0x01D9, "\u01DA");
        CASEFOLD_MAP.put(0x01DB, "\u01DC");
        CASEFOLD_MAP.put(0x01DE, "\u01DF");
        CASEFOLD_MAP.put(0x01E0, "\u01E1");
        CASEFOLD_MAP.put(0x01E2, "\u01E3");
        CASEFOLD_MAP.put(0x01E4, "\u01E5");
        CASEFOLD_MAP.put(0x01E6, "\u01E7");
        CASEFOLD_MAP.put(0x01E8, "\u01E9");
        CASEFOLD_MAP.put(0x01EA, "\u01EB");
        CASEFOLD_MAP.put(0x01EC, "\u01ED");
        CASEFOLD_MAP.put(0x01EE, "\u01EF");
        CASEFOLD_MAP.put(0x01F0, "\u006A\u030C");
        CASEFOLD_MAP.put(0x01F1, "\u01F3");
        CASEFOLD_MAP.put(0x01F2, "\u01F3");
        CASEFOLD_MAP.put(0x01F4, "\u01F5");
        CASEFOLD_MAP.put(0x01F6, "\u0195");
        CASEFOLD_MAP.put(0x01F7, "\u01BF");
        CASEFOLD_MAP.put(0x01F8, "\u01F9");
        CASEFOLD_MAP.put(0x01FA, "\u01FB");
        CASEFOLD_MAP.put(0x01FC, "\u01FD");
        CASEFOLD_MAP.put(0x01FE, "\u01FF");
        CASEFOLD_MAP.put(0x0200, "\u0201");
        CASEFOLD_MAP.put(0x0202, "\u0203");
        CASEFOLD_MAP.put(0x0204, "\u0205");
        CASEFOLD_MAP.put(0x0206, "\u0207");
        CASEFOLD_MAP.put(0x0208, "\u0209");
        CASEFOLD_MAP.put(0x020A, "\u020B");
        CASEFOLD_MAP.put(0x020C, "\u020D");
        CASEFOLD_MAP.put(0x020E, "\u020F");
        CASEFOLD_MAP.put(0x0210, "\u0211");
        CASEFOLD_MAP.put(0x0212, "\u0213");
        CASEFOLD_MAP.put(0x0214, "\u0215");
        CASEFOLD_MAP.put(0x0216, "\u0217");
        CASEFOLD_MAP.put(0x0218, "\u0219");
        CASEFOLD_MAP.put(0x021A, "\u021B");
        CASEFOLD_MAP.put(0x021C, "\u021D");
        CASEFOLD_MAP.put(0x021E, "\u021F");
        CASEFOLD_MAP.put(0x0220, "\u019E");
        CASEFOLD_MAP.put(0x0222, "\u0223");
        CASEFOLD_MAP.put(0x0224, "\u0225");
        CASEFOLD_MAP.put(0x0226, "\u0227");
        CASEFOLD_MAP.put(0x0228, "\u0229");
        CASEFOLD_MAP.put(0x022A, "\u022B");
        CASEFOLD_MAP.put(0x022C, "\u022D");
        CASEFOLD_MAP.put(0x022E, "\u022F");
        CASEFOLD_MAP.put(0x0230, "\u0231");
        CASEFOLD_MAP.put(0x0232, "\u0233");
        CASEFOLD_MAP.put(0x023A, "\u2C65");
        CASEFOLD_MAP.put(0x023B, "\u023C");
        CASEFOLD_MAP.put(0x023D, "\u019A");
        CASEFOLD_MAP.put(0x023E, "\u2C66");
        CASEFOLD_MAP.put(0x0241, "\u0242");
        CASEFOLD_MAP.put(0x0243, "\u0180");
        CASEFOLD_MAP.put(0x0244, "\u0289");
        CASEFOLD_MAP.put(0x0245, "\u028C");
        CASEFOLD_MAP.put(0x0246, "\u0247");
        CASEFOLD_MAP.put(0x0248, "\u0249");
        CASEFOLD_MAP.put(0x024A, "\u024B");
        CASEFOLD_MAP.put(0x024C, "\u024D");
        CASEFOLD_MAP.put(0x024E, "\u024F");
        CASEFOLD_MAP.put(0x0345, "\u03B9");
        CASEFOLD_MAP.put(0x0370, "\u0371");
        CASEFOLD_MAP.put(0x0372, "\u0373");
        CASEFOLD_MAP.put(0x0376, "\u0377");
        CASEFOLD_MAP.put(0x037F, "\u03F3");
        CASEFOLD_MAP.put(0x0386, "\u03AC");
        CASEFOLD_MAP.put(0x0388, "\u03AD");
        CASEFOLD_MAP.put(0x0389, "\u03AE");
        CASEFOLD_MAP.put(0x038A, "\u03AF");
        CASEFOLD_MAP.put(0x038C, "\u03CC");
        CASEFOLD_MAP.put(0x038E, "\u03CD");
        CASEFOLD_MAP.put(0x038F, "\u03CE");
        CASEFOLD_MAP.put(0x0390, "\u03B9\u0308\u0301");
        CASEFOLD_MAP.put(0x0391, "\u03B1");
        CASEFOLD_MAP.put(0x0392, "\u03B2");
        CASEFOLD_MAP.put(0x0393, "\u03B3");
        CASEFOLD_MAP.put(0x0394, "\u03B4");
        CASEFOLD_MAP.put(0x0395, "\u03B5");
        CASEFOLD_MAP.put(0x0396, "\u03B6");
        CASEFOLD_MAP.put(0x0397, "\u03B7");
        CASEFOLD_MAP.put(0x0398, "\u03B8");
        CASEFOLD_MAP.put(0x0399, "\u03B9");
        CASEFOLD_MAP.put(0x039A, "\u03BA");
        CASEFOLD_MAP.put(0x039B, "\u03BB");
        CASEFOLD_MAP.put(0x039C, "\u03BC");
        CASEFOLD_MAP.put(0x039D, "\u03BD");
        CASEFOLD_MAP.put(0x039E, "\u03BE");
        CASEFOLD_MAP.put(0x039F, "\u03BF");
        CASEFOLD_MAP.put(0x03A0, "\u03C0");
        CASEFOLD_MAP.put(0x03A1, "\u03C1");
        CASEFOLD_MAP.put(0x03A3, "\u03C3");
        CASEFOLD_MAP.put(0x03A4, "\u03C4");
        CASEFOLD_MAP.put(0x03A5, "\u03C5");
        CASEFOLD_MAP.put(0x03A6, "\u03C6");
        CASEFOLD_MAP.put(0x03A7, "\u03C7");
        CASEFOLD_MAP.put(0x03A8, "\u03C8");
        CASEFOLD_MAP.put(0x03A9, "\u03C9");
        CASEFOLD_MAP.put(0x03AA, "\u03CA");
        CASEFOLD_MAP.put(0x03AB, "\u03CB");
        CASEFOLD_MAP.put(0x03B0, "\u03C5\u0308\u0301");
        CASEFOLD_MAP.put(0x03C2, "\u03C3");
        CASEFOLD_MAP.put(0x03CF, "\u03D7");
        CASEFOLD_MAP.put(0x03D0, "\u03B2");
        CASEFOLD_MAP.put(0x03D1, "\u03B8");
        CASEFOLD_MAP.put(0x03D5, "\u03C6");
        CASEFOLD_MAP.put(0x03D6, "\u03C0");
        CASEFOLD_MAP.put(0x03D8, "\u03D9");
        CASEFOLD_MAP.put(0x03DA, "\u03DB");
        CASEFOLD_MAP.put(0x03DC, "\u03DD");
        CASEFOLD_MAP.put(0x03DE, "\u03DF");
        CASEFOLD_MAP.put(0x03E0, "\u03E1");
        CASEFOLD_MAP.put(0x03E2, "\u03E3");
        CASEFOLD_MAP.put(0x03E4, "\u03E5");
        CASEFOLD_MAP.put(0x03E6, "\u03E7");
        CASEFOLD_MAP.put(0x03E8, "\u03E9");
        CASEFOLD_MAP.put(0x03EA, "\u03EB");
        CASEFOLD_MAP.put(0x03EC, "\u03ED");
        CASEFOLD_MAP.put(0x03EE, "\u03EF");
        CASEFOLD_MAP.put(0x03F0, "\u03BA");
        CASEFOLD_MAP.put(0x03F1, "\u03C1");
        CASEFOLD_MAP.put(0x03F4, "\u03B8");
        CASEFOLD_MAP.put(0x03F5, "\u03B5");
        CASEFOLD_MAP.put(0x03F7, "\u03F8");
        CASEFOLD_MAP.put(0x03F9, "\u03F2");
        CASEFOLD_MAP.put(0x03FA, "\u03FB");
        CASEFOLD_MAP.put(0x03FD, "\u037B");
        CASEFOLD_MAP.put(0x03FE, "\u037C");
        CASEFOLD_MAP.put(0x03FF, "\u037D");
        CASEFOLD_MAP.put(0x0400, "\u0450");
        CASEFOLD_MAP.put(0x0401, "\u0451");
        CASEFOLD_MAP.put(0x0402, "\u0452");
        CASEFOLD_MAP.put(0x0403, "\u0453");
        CASEFOLD_MAP.put(0x0404, "\u0454");
        CASEFOLD_MAP.put(0x0405, "\u0455");
        CASEFOLD_MAP.put(0x0406, "\u0456");
        CASEFOLD_MAP.put(0x0407, "\u0457");
        CASEFOLD_MAP.put(0x0408, "\u0458");
        CASEFOLD_MAP.put(0x0409, "\u0459");
        CASEFOLD_MAP.put(0x040A, "\u045A");
        CASEFOLD_MAP.put(0x040B, "\u045B");
        CASEFOLD_MAP.put(0x040C, "\u045C");
        CASEFOLD_MAP.put(0x040D, "\u045D");
        CASEFOLD_MAP.put(0x040E, "\u045E");
        CASEFOLD_MAP.put(0x040F, "\u045F");
        CASEFOLD_MAP.put(0x0410, "\u0430");
        CASEFOLD_MAP.put(0x0411, "\u0431");
        CASEFOLD_MAP.put(0x0412, "\u0432");
        CASEFOLD_MAP.put(0x0413, "\u0433");
        CASEFOLD_MAP.put(0x0414, "\u0434");
        CASEFOLD_MAP.put(0x0415, "\u0435");
        CASEFOLD_MAP.put(0x0416, "\u0436");
        CASEFOLD_MAP.put(0x0417, "\u0437");
        CASEFOLD_MAP.put(0x0418, "\u0438");
        CASEFOLD_MAP.put(0x0419, "\u0439");
        CASEFOLD_MAP.put(0x041A, "\u043A");
        CASEFOLD_MAP.put(0x041B, "\u043B");
        CASEFOLD_MAP.put(0x041C, "\u043C");
        CASEFOLD_MAP.put(0x041D, "\u043D");
        CASEFOLD_MAP.put(0x041E, "\u043E");
        CASEFOLD_MAP.put(0x041F, "\u043F");
        CASEFOLD_MAP.put(0x0420, "\u0440");
        CASEFOLD_MAP.put(0x0421, "\u0441");
        CASEFOLD_MAP.put(0x0422, "\u0442");
        CASEFOLD_MAP.put(0x0423, "\u0443");
        CASEFOLD_MAP.put(0x0424, "\u0444");
        CASEFOLD_MAP.put(0x0425, "\u0445");
        CASEFOLD_MAP.put(0x0426, "\u0446");
        CASEFOLD_MAP.put(0x0427, "\u0447");
        CASEFOLD_MAP.put(0x0428, "\u0448");
        CASEFOLD_MAP.put(0x0429, "\u0449");
        CASEFOLD_MAP.put(0x042A, "\u044A");
        CASEFOLD_MAP.put(0x042B, "\u044B");
        CASEFOLD_MAP.put(0x042C, "\u044C");
        CASEFOLD_MAP.put(0x042D, "\u044D");
        CASEFOLD_MAP.put(0x042E, "\u044E");
        CASEFOLD_MAP.put(0x042F, "\u044F");
        CASEFOLD_MAP.put(0x0460, "\u0461");
        CASEFOLD_MAP.put(0x0462, "\u0463");
        CASEFOLD_MAP.put(0x0464, "\u0465");
        CASEFOLD_MAP.put(0x0466, "\u0467");
        CASEFOLD_MAP.put(0x0468, "\u0469");
        CASEFOLD_MAP.put(0x046A, "\u046B");
        CASEFOLD_MAP.put(0x046C, "\u046D");
        CASEFOLD_MAP.put(0x046E, "\u046F");
        CASEFOLD_MAP.put(0x0470, "\u0471");
        CASEFOLD_MAP.put(0x0472, "\u0473");
        CASEFOLD_MAP.put(0x0474, "\u0475");
        CASEFOLD_MAP.put(0x0476, "\u0477");
        CASEFOLD_MAP.put(0x0478, "\u0479");
        CASEFOLD_MAP.put(0x047A, "\u047B");
        CASEFOLD_MAP.put(0x047C, "\u047D");
        CASEFOLD_MAP.put(0x047E, "\u047F");
        CASEFOLD_MAP.put(0x0480, "\u0481");
        CASEFOLD_MAP.put(0x048A, "\u048B");
        CASEFOLD_MAP.put(0x048C, "\u048D");
        CASEFOLD_MAP.put(0x048E, "\u048F");
        CASEFOLD_MAP.put(0x0490, "\u0491");
        CASEFOLD_MAP.put(0x0492, "\u0493");
        CASEFOLD_MAP.put(0x0494, "\u0495");
        CASEFOLD_MAP.put(0x0496, "\u0497");
        CASEFOLD_MAP.put(0x0498, "\u0499");
        CASEFOLD_MAP.put(0x049A, "\u049B");
        CASEFOLD_MAP.put(0x049C, "\u049D");
        CASEFOLD_MAP.put(0x049E, "\u049F");
        CASEFOLD_MAP.put(0x04A0, "\u04A1");
        CASEFOLD_MAP.put(0x04A2, "\u04A3");
        CASEFOLD_MAP.put(0x04A4, "\u04A5");
        CASEFOLD_MAP.put(0x04A6, "\u04A7");
        CASEFOLD_MAP.put(0x04A8, "\u04A9");
        CASEFOLD_MAP.put(0x04AA, "\u04AB");
        CASEFOLD_MAP.put(0x04AC, "\u04AD");
        CASEFOLD_MAP.put(0x04AE, "\u04AF");
        CASEFOLD_MAP.put(0x04B0, "\u04B1");
        CASEFOLD_MAP.put(0x04B2, "\u04B3");
        CASEFOLD_MAP.put(0x04B4, "\u04B5");
        CASEFOLD_MAP.put(0x04B6, "\u04B7");
        CASEFOLD_MAP.put(0x04B8, "\u04B9");
        CASEFOLD_MAP.put(0x04BA, "\u04BB");
        CASEFOLD_MAP.put(0x04BC, "\u04BD");
        CASEFOLD_MAP.put(0x04BE, "\u04BF");
        CASEFOLD_MAP.put(0x04C0, "\u04CF");
        CASEFOLD_MAP.put(0x04C1, "\u04C2");
        CASEFOLD_MAP.put(0x04C3, "\u04C4");
        CASEFOLD_MAP.put(0x04C5, "\u04C6");
        CASEFOLD_MAP.put(0x04C7, "\u04C8");
        CASEFOLD_MAP.put(0x04C9, "\u04CA");
        CASEFOLD_MAP.put(0x04CB, "\u04CC");
        CASEFOLD_MAP.put(0x04CD, "\u04CE");
        CASEFOLD_MAP.put(0x04D0, "\u04D1");
        CASEFOLD_MAP.put(0x04D2, "\u04D3");
        CASEFOLD_MAP.put(0x04D4, "\u04D5");
        CASEFOLD_MAP.put(0x04D6, "\u04D7");
        CASEFOLD_MAP.put(0x04D8, "\u04D9");
        CASEFOLD_MAP.put(0x04DA, "\u04DB");
        CASEFOLD_MAP.put(0x04DC, "\u04DD");
        CASEFOLD_MAP.put(0x04DE, "\u04DF");
        CASEFOLD_MAP.put(0x04E0, "\u04E1");
        CASEFOLD_MAP.put(0x04E2, "\u04E3");
        CASEFOLD_MAP.put(0x04E4, "\u04E5");
        CASEFOLD_MAP.put(0x04E6, "\u04E7");
        CASEFOLD_MAP.put(0x04E8, "\u04E9");
        CASEFOLD_MAP.put(0x04EA, "\u04EB");
        CASEFOLD_MAP.put(0x04EC, "\u04ED");
        CASEFOLD_MAP.put(0x04EE, "\u04EF");
        CASEFOLD_MAP.put(0x04F0, "\u04F1");
        CASEFOLD_MAP.put(0x04F2, "\u04F3");
        CASEFOLD_MAP.put(0x04F4, "\u04F5");
        CASEFOLD_MAP.put(0x04F6, "\u04F7");
        CASEFOLD_MAP.put(0x04F8, "\u04F9");
        CASEFOLD_MAP.put(0x04FA, "\u04FB");
        CASEFOLD_MAP.put(0x04FC, "\u04FD");
        CASEFOLD_MAP.put(0x04FE, "\u04FF");
        CASEFOLD_MAP.put(0x0500, "\u0501");
        CASEFOLD_MAP.put(0x0502, "\u0503");
        CASEFOLD_MAP.put(0x0504, "\u0505");
        CASEFOLD_MAP.put(0x0506, "\u0507");
        CASEFOLD_MAP.put(0x0508, "\u0509");
        CASEFOLD_MAP.put(0x050A, "\u050B");
        CASEFOLD_MAP.put(0x050C, "\u050D");
        CASEFOLD_MAP.put(0x050E, "\u050F");
        CASEFOLD_MAP.put(0x0510, "\u0511");
        CASEFOLD_MAP.put(0x0512, "\u0513");
        CASEFOLD_MAP.put(0x0514, "\u0515");
        CASEFOLD_MAP.put(0x0516, "\u0517");
        CASEFOLD_MAP.put(0x0518, "\u0519");
        CASEFOLD_MAP.put(0x051A, "\u051B");
        CASEFOLD_MAP.put(0x051C, "\u051D");
        CASEFOLD_MAP.put(0x051E, "\u051F");
        CASEFOLD_MAP.put(0x0520, "\u0521");
        CASEFOLD_MAP.put(0x0522, "\u0523");
        CASEFOLD_MAP.put(0x0524, "\u0525");
        CASEFOLD_MAP.put(0x0526, "\u0527");
        CASEFOLD_MAP.put(0x0528, "\u0529");
        CASEFOLD_MAP.put(0x052A, "\u052B");
        CASEFOLD_MAP.put(0x052C, "\u052D");
        CASEFOLD_MAP.put(0x052E, "\u052F");
        CASEFOLD_MAP.put(0x0531, "\u0561");
        CASEFOLD_MAP.put(0x0532, "\u0562");
        CASEFOLD_MAP.put(0x0533, "\u0563");
        CASEFOLD_MAP.put(0x0534, "\u0564");
        CASEFOLD_MAP.put(0x0535, "\u0565");
        CASEFOLD_MAP.put(0x0536, "\u0566");
        CASEFOLD_MAP.put(0x0537, "\u0567");
        CASEFOLD_MAP.put(0x0538, "\u0568");
        CASEFOLD_MAP.put(0x0539, "\u0569");
        CASEFOLD_MAP.put(0x053A, "\u056A");
        CASEFOLD_MAP.put(0x053B, "\u056B");
        CASEFOLD_MAP.put(0x053C, "\u056C");
        CASEFOLD_MAP.put(0x053D, "\u056D");
        CASEFOLD_MAP.put(0x053E, "\u056E");
        CASEFOLD_MAP.put(0x053F, "\u056F");
        CASEFOLD_MAP.put(0x0540, "\u0570");
        CASEFOLD_MAP.put(0x0541, "\u0571");
        CASEFOLD_MAP.put(0x0542, "\u0572");
        CASEFOLD_MAP.put(0x0543, "\u0573");
        CASEFOLD_MAP.put(0x0544, "\u0574");
        CASEFOLD_MAP.put(0x0545, "\u0575");
        CASEFOLD_MAP.put(0x0546, "\u0576");
        CASEFOLD_MAP.put(0x0547, "\u0577");
        CASEFOLD_MAP.put(0x0548, "\u0578");
        CASEFOLD_MAP.put(0x0549, "\u0579");
        CASEFOLD_MAP.put(0x054A, "\u057A");
        CASEFOLD_MAP.put(0x054B, "\u057B");
        CASEFOLD_MAP.put(0x054C, "\u057C");
        CASEFOLD_MAP.put(0x054D, "\u057D");
        CASEFOLD_MAP.put(0x054E, "\u057E");
        CASEFOLD_MAP.put(0x054F, "\u057F");
        CASEFOLD_MAP.put(0x0550, "\u0580");
        CASEFOLD_MAP.put(0x0551, "\u0581");
        CASEFOLD_MAP.put(0x0552, "\u0582");
        CASEFOLD_MAP.put(0x0553, "\u0583");
        CASEFOLD_MAP.put(0x0554, "\u0584");
        CASEFOLD_MAP.put(0x0555, "\u0585");
        CASEFOLD_MAP.put(0x0556, "\u0586");
        CASEFOLD_MAP.put(0x0587, "\u0565\u0582");
        CASEFOLD_MAP.put(0x10A0, "\u2D00");
        CASEFOLD_MAP.put(0x10A1, "\u2D01");
        CASEFOLD_MAP.put(0x10A2, "\u2D02");
        CASEFOLD_MAP.put(0x10A3, "\u2D03");
        CASEFOLD_MAP.put(0x10A4, "\u2D04");
        CASEFOLD_MAP.put(0x10A5, "\u2D05");
        CASEFOLD_MAP.put(0x10A6, "\u2D06");
        CASEFOLD_MAP.put(0x10A7, "\u2D07");
        CASEFOLD_MAP.put(0x10A8, "\u2D08");
        CASEFOLD_MAP.put(0x10A9, "\u2D09");
        CASEFOLD_MAP.put(0x10AA, "\u2D0A");
        CASEFOLD_MAP.put(0x10AB, "\u2D0B");
        CASEFOLD_MAP.put(0x10AC, "\u2D0C");
        CASEFOLD_MAP.put(0x10AD, "\u2D0D");
        CASEFOLD_MAP.put(0x10AE, "\u2D0E");
        CASEFOLD_MAP.put(0x10AF, "\u2D0F");
        CASEFOLD_MAP.put(0x10B0, "\u2D10");
        CASEFOLD_MAP.put(0x10B1, "\u2D11");
        CASEFOLD_MAP.put(0x10B2, "\u2D12");
        CASEFOLD_MAP.put(0x10B3, "\u2D13");
        CASEFOLD_MAP.put(0x10B4, "\u2D14");
        CASEFOLD_MAP.put(0x10B5, "\u2D15");
        CASEFOLD_MAP.put(0x10B6, "\u2D16");
        CASEFOLD_MAP.put(0x10B7, "\u2D17");
        CASEFOLD_MAP.put(0x10B8, "\u2D18");
        CASEFOLD_MAP.put(0x10B9, "\u2D19");
        CASEFOLD_MAP.put(0x10BA, "\u2D1A");
        CASEFOLD_MAP.put(0x10BB, "\u2D1B");
        CASEFOLD_MAP.put(0x10BC, "\u2D1C");
        CASEFOLD_MAP.put(0x10BD, "\u2D1D");
        CASEFOLD_MAP.put(0x10BE, "\u2D1E");
        CASEFOLD_MAP.put(0x10BF, "\u2D1F");
        CASEFOLD_MAP.put(0x10C0, "\u2D20");
        CASEFOLD_MAP.put(0x10C1, "\u2D21");
        CASEFOLD_MAP.put(0x10C2, "\u2D22");
        CASEFOLD_MAP.put(0x10C3, "\u2D23");
        CASEFOLD_MAP.put(0x10C4, "\u2D24");
        CASEFOLD_MAP.put(0x10C5, "\u2D25");
        CASEFOLD_MAP.put(0x10C7, "\u2D27");
        CASEFOLD_MAP.put(0x10CD, "\u2D2D");
        CASEFOLD_MAP.put(0x13F8, "\u13F0");
        CASEFOLD_MAP.put(0x13F9, "\u13F1");
        CASEFOLD_MAP.put(0x13FA, "\u13F2");
        CASEFOLD_MAP.put(0x13FB, "\u13F3");
        CASEFOLD_MAP.put(0x13FC, "\u13F4");
        CASEFOLD_MAP.put(0x13FD, "\u13F5");
        CASEFOLD_MAP.put(0x1C80, "\u0432");
        CASEFOLD_MAP.put(0x1C81, "\u0434");
        CASEFOLD_MAP.put(0x1C82, "\u043E");
        CASEFOLD_MAP.put(0x1C83, "\u0441");
        CASEFOLD_MAP.put(0x1C84, "\u0442");
        CASEFOLD_MAP.put(0x1C85, "\u0442");
        CASEFOLD_MAP.put(0x1C86, "\u044A");
        CASEFOLD_MAP.put(0x1C87, "\u0463");
        CASEFOLD_MAP.put(0x1C88, "\uA64B");
        CASEFOLD_MAP.put(0x1C89, "\u1C8A");
        CASEFOLD_MAP.put(0x1C90, "\u10D0");
        CASEFOLD_MAP.put(0x1C91, "\u10D1");
        CASEFOLD_MAP.put(0x1C92, "\u10D2");
        CASEFOLD_MAP.put(0x1C93, "\u10D3");
        CASEFOLD_MAP.put(0x1C94, "\u10D4");
        CASEFOLD_MAP.put(0x1C95, "\u10D5");
        CASEFOLD_MAP.put(0x1C96, "\u10D6");
        CASEFOLD_MAP.put(0x1C97, "\u10D7");
        CASEFOLD_MAP.put(0x1C98, "\u10D8");
        CASEFOLD_MAP.put(0x1C99, "\u10D9");
        CASEFOLD_MAP.put(0x1C9A, "\u10DA");
        CASEFOLD_MAP.put(0x1C9B, "\u10DB");
        CASEFOLD_MAP.put(0x1C9C, "\u10DC");
        CASEFOLD_MAP.put(0x1C9D, "\u10DD");
        CASEFOLD_MAP.put(0x1C9E, "\u10DE");
        CASEFOLD_MAP.put(0x1C9F, "\u10DF");
        CASEFOLD_MAP.put(0x1CA0, "\u10E0");
        CASEFOLD_MAP.put(0x1CA1, "\u10E1");
        CASEFOLD_MAP.put(0x1CA2, "\u10E2");
        CASEFOLD_MAP.put(0x1CA3, "\u10E3");
        CASEFOLD_MAP.put(0x1CA4, "\u10E4");
        CASEFOLD_MAP.put(0x1CA5, "\u10E5");
        CASEFOLD_MAP.put(0x1CA6, "\u10E6");
        CASEFOLD_MAP.put(0x1CA7, "\u10E7");
        CASEFOLD_MAP.put(0x1CA8, "\u10E8");
        CASEFOLD_MAP.put(0x1CA9, "\u10E9");
        CASEFOLD_MAP.put(0x1CAA, "\u10EA");
        CASEFOLD_MAP.put(0x1CAB, "\u10EB");
        CASEFOLD_MAP.put(0x1CAC, "\u10EC");
        CASEFOLD_MAP.put(0x1CAD, "\u10ED");
        CASEFOLD_MAP.put(0x1CAE, "\u10EE");
        CASEFOLD_MAP.put(0x1CAF, "\u10EF");
        CASEFOLD_MAP.put(0x1CB0, "\u10F0");
        CASEFOLD_MAP.put(0x1CB1, "\u10F1");
        CASEFOLD_MAP.put(0x1CB2, "\u10F2");
        CASEFOLD_MAP.put(0x1CB3, "\u10F3");
        CASEFOLD_MAP.put(0x1CB4, "\u10F4");
        CASEFOLD_MAP.put(0x1CB5, "\u10F5");
        CASEFOLD_MAP.put(0x1CB6, "\u10F6");
        CASEFOLD_MAP.put(0x1CB7, "\u10F7");
        CASEFOLD_MAP.put(0x1CB8, "\u10F8");
        CASEFOLD_MAP.put(0x1CB9, "\u10F9");
        CASEFOLD_MAP.put(0x1CBA, "\u10FA");
        CASEFOLD_MAP.put(0x1CBD, "\u10FD");
        CASEFOLD_MAP.put(0x1CBE, "\u10FE");
        CASEFOLD_MAP.put(0x1CBF, "\u10FF");
        CASEFOLD_MAP.put(0x1E00, "\u1E01");
        CASEFOLD_MAP.put(0x1E02, "\u1E03");
        CASEFOLD_MAP.put(0x1E04, "\u1E05");
        CASEFOLD_MAP.put(0x1E06, "\u1E07");
        CASEFOLD_MAP.put(0x1E08, "\u1E09");
        CASEFOLD_MAP.put(0x1E0A, "\u1E0B");
        CASEFOLD_MAP.put(0x1E0C, "\u1E0D");
        CASEFOLD_MAP.put(0x1E0E, "\u1E0F");
        CASEFOLD_MAP.put(0x1E10, "\u1E11");
        CASEFOLD_MAP.put(0x1E12, "\u1E13");
        CASEFOLD_MAP.put(0x1E14, "\u1E15");
        CASEFOLD_MAP.put(0x1E16, "\u1E17");
        CASEFOLD_MAP.put(0x1E18, "\u1E19");
        CASEFOLD_MAP.put(0x1E1A, "\u1E1B");
        CASEFOLD_MAP.put(0x1E1C, "\u1E1D");
        CASEFOLD_MAP.put(0x1E1E, "\u1E1F");
        CASEFOLD_MAP.put(0x1E20, "\u1E21");
        CASEFOLD_MAP.put(0x1E22, "\u1E23");
        CASEFOLD_MAP.put(0x1E24, "\u1E25");
        CASEFOLD_MAP.put(0x1E26, "\u1E27");
        CASEFOLD_MAP.put(0x1E28, "\u1E29");
        CASEFOLD_MAP.put(0x1E2A, "\u1E2B");
        CASEFOLD_MAP.put(0x1E2C, "\u1E2D");
        CASEFOLD_MAP.put(0x1E2E, "\u1E2F");
        CASEFOLD_MAP.put(0x1E30, "\u1E31");
        CASEFOLD_MAP.put(0x1E32, "\u1E33");
        CASEFOLD_MAP.put(0x1E34, "\u1E35");
        CASEFOLD_MAP.put(0x1E36, "\u1E37");
        CASEFOLD_MAP.put(0x1E38, "\u1E39");
        CASEFOLD_MAP.put(0x1E3A, "\u1E3B");
        CASEFOLD_MAP.put(0x1E3C, "\u1E3D");
        CASEFOLD_MAP.put(0x1E3E, "\u1E3F");
        CASEFOLD_MAP.put(0x1E40, "\u1E41");
        CASEFOLD_MAP.put(0x1E42, "\u1E43");
        CASEFOLD_MAP.put(0x1E44, "\u1E45");
        CASEFOLD_MAP.put(0x1E46, "\u1E47");
        CASEFOLD_MAP.put(0x1E48, "\u1E49");
        CASEFOLD_MAP.put(0x1E4A, "\u1E4B");
        CASEFOLD_MAP.put(0x1E4C, "\u1E4D");
        CASEFOLD_MAP.put(0x1E4E, "\u1E4F");
        CASEFOLD_MAP.put(0x1E50, "\u1E51");
        CASEFOLD_MAP.put(0x1E52, "\u1E53");
        CASEFOLD_MAP.put(0x1E54, "\u1E55");
        CASEFOLD_MAP.put(0x1E56, "\u1E57");
        CASEFOLD_MAP.put(0x1E58, "\u1E59");
        CASEFOLD_MAP.put(0x1E5A, "\u1E5B");
        CASEFOLD_MAP.put(0x1E5C, "\u1E5D");
        CASEFOLD_MAP.put(0x1E5E, "\u1E5F");
        CASEFOLD_MAP.put(0x1E60, "\u1E61");
        CASEFOLD_MAP.put(0x1E62, "\u1E63");
        CASEFOLD_MAP.put(0x1E64, "\u1E65");
        CASEFOLD_MAP.put(0x1E66, "\u1E67");
        CASEFOLD_MAP.put(0x1E68, "\u1E69");
        CASEFOLD_MAP.put(0x1E6A, "\u1E6B");
        CASEFOLD_MAP.put(0x1E6C, "\u1E6D");
        CASEFOLD_MAP.put(0x1E6E, "\u1E6F");
        CASEFOLD_MAP.put(0x1E70, "\u1E71");
        CASEFOLD_MAP.put(0x1E72, "\u1E73");
        CASEFOLD_MAP.put(0x1E74, "\u1E75");
        CASEFOLD_MAP.put(0x1E76, "\u1E77");
        CASEFOLD_MAP.put(0x1E78, "\u1E79");
        CASEFOLD_MAP.put(0x1E7A, "\u1E7B");
        CASEFOLD_MAP.put(0x1E7C, "\u1E7D");
        CASEFOLD_MAP.put(0x1E7E, "\u1E7F");
        CASEFOLD_MAP.put(0x1E80, "\u1E81");
        CASEFOLD_MAP.put(0x1E82, "\u1E83");
        CASEFOLD_MAP.put(0x1E84, "\u1E85");
        CASEFOLD_MAP.put(0x1E86, "\u1E87");
        CASEFOLD_MAP.put(0x1E88, "\u1E89");
        CASEFOLD_MAP.put(0x1E8A, "\u1E8B");
        CASEFOLD_MAP.put(0x1E8C, "\u1E8D");
        CASEFOLD_MAP.put(0x1E8E, "\u1E8F");
        CASEFOLD_MAP.put(0x1E90, "\u1E91");
        CASEFOLD_MAP.put(0x1E92, "\u1E93");
        CASEFOLD_MAP.put(0x1E94, "\u1E95");
        CASEFOLD_MAP.put(0x1E96, "\u0068\u0331");
        CASEFOLD_MAP.put(0x1E97, "\u0074\u0308");
        CASEFOLD_MAP.put(0x1E98, "\u0077\u030A");
        CASEFOLD_MAP.put(0x1E99, "\u0079\u030A");
        CASEFOLD_MAP.put(0x1E9A, "\u0061\u02BE");
        CASEFOLD_MAP.put(0x1E9B, "\u1E61");
        CASEFOLD_MAP.put(0x1E9E, "\u0073\u0073");
        CASEFOLD_MAP.put(0x1EA0, "\u1EA1");
        CASEFOLD_MAP.put(0x1EA2, "\u1EA3");
        CASEFOLD_MAP.put(0x1EA4, "\u1EA5");
        CASEFOLD_MAP.put(0x1EA6, "\u1EA7");
        CASEFOLD_MAP.put(0x1EA8, "\u1EA9");
        CASEFOLD_MAP.put(0x1EAA, "\u1EAB");
        CASEFOLD_MAP.put(0x1EAC, "\u1EAD");
        CASEFOLD_MAP.put(0x1EAE, "\u1EAF");
        CASEFOLD_MAP.put(0x1EB0, "\u1EB1");
        CASEFOLD_MAP.put(0x1EB2, "\u1EB3");
        CASEFOLD_MAP.put(0x1EB4, "\u1EB5");
        CASEFOLD_MAP.put(0x1EB6, "\u1EB7");
        CASEFOLD_MAP.put(0x1EB8, "\u1EB9");
        CASEFOLD_MAP.put(0x1EBA, "\u1EBB");
        CASEFOLD_MAP.put(0x1EBC, "\u1EBD");
        CASEFOLD_MAP.put(0x1EBE, "\u1EBF");
        CASEFOLD_MAP.put(0x1EC0, "\u1EC1");
        CASEFOLD_MAP.put(0x1EC2, "\u1EC3");
        CASEFOLD_MAP.put(0x1EC4, "\u1EC5");
        CASEFOLD_MAP.put(0x1EC6, "\u1EC7");
        CASEFOLD_MAP.put(0x1EC8, "\u1EC9");
        CASEFOLD_MAP.put(0x1ECA, "\u1ECB");
        CASEFOLD_MAP.put(0x1ECC, "\u1ECD");
        CASEFOLD_MAP.put(0x1ECE, "\u1ECF");
        CASEFOLD_MAP.put(0x1ED0, "\u1ED1");
        CASEFOLD_MAP.put(0x1ED2, "\u1ED3");
        CASEFOLD_MAP.put(0x1ED4, "\u1ED5");
        CASEFOLD_MAP.put(0x1ED6, "\u1ED7");
        CASEFOLD_MAP.put(0x1ED8, "\u1ED9");
        CASEFOLD_MAP.put(0x1EDA, "\u1EDB");
        CASEFOLD_MAP.put(0x1EDC, "\u1EDD");
        CASEFOLD_MAP.put(0x1EDE, "\u1EDF");
        CASEFOLD_MAP.put(0x1EE0, "\u1EE1");
        CASEFOLD_MAP.put(0x1EE2, "\u1EE3");
        CASEFOLD_MAP.put(0x1EE4, "\u1EE5");
        CASEFOLD_MAP.put(0x1EE6, "\u1EE7");
        CASEFOLD_MAP.put(0x1EE8, "\u1EE9");
        CASEFOLD_MAP.put(0x1EEA, "\u1EEB");
        CASEFOLD_MAP.put(0x1EEC, "\u1EED");
        CASEFOLD_MAP.put(0x1EEE, "\u1EEF");
        CASEFOLD_MAP.put(0x1EF0, "\u1EF1");
        CASEFOLD_MAP.put(0x1EF2, "\u1EF3");
        CASEFOLD_MAP.put(0x1EF4, "\u1EF5");
        CASEFOLD_MAP.put(0x1EF6, "\u1EF7");
        CASEFOLD_MAP.put(0x1EF8, "\u1EF9");
        CASEFOLD_MAP.put(0x1EFA, "\u1EFB");
        CASEFOLD_MAP.put(0x1EFC, "\u1EFD");
        CASEFOLD_MAP.put(0x1EFE, "\u1EFF");
        CASEFOLD_MAP.put(0x1F08, "\u1F00");
        CASEFOLD_MAP.put(0x1F09, "\u1F01");
        CASEFOLD_MAP.put(0x1F0A, "\u1F02");
        CASEFOLD_MAP.put(0x1F0B, "\u1F03");
        CASEFOLD_MAP.put(0x1F0C, "\u1F04");
        CASEFOLD_MAP.put(0x1F0D, "\u1F05");
        CASEFOLD_MAP.put(0x1F0E, "\u1F06");
        CASEFOLD_MAP.put(0x1F0F, "\u1F07");
        CASEFOLD_MAP.put(0x1F18, "\u1F10");
        CASEFOLD_MAP.put(0x1F19, "\u1F11");
        CASEFOLD_MAP.put(0x1F1A, "\u1F12");
        CASEFOLD_MAP.put(0x1F1B, "\u1F13");
        CASEFOLD_MAP.put(0x1F1C, "\u1F14");
        CASEFOLD_MAP.put(0x1F1D, "\u1F15");
        CASEFOLD_MAP.put(0x1F28, "\u1F20");
        CASEFOLD_MAP.put(0x1F29, "\u1F21");
        CASEFOLD_MAP.put(0x1F2A, "\u1F22");
        CASEFOLD_MAP.put(0x1F2B, "\u1F23");
        CASEFOLD_MAP.put(0x1F2C, "\u1F24");
        CASEFOLD_MAP.put(0x1F2D, "\u1F25");
        CASEFOLD_MAP.put(0x1F2E, "\u1F26");
        CASEFOLD_MAP.put(0x1F2F, "\u1F27");
        CASEFOLD_MAP.put(0x1F38, "\u1F30");
        CASEFOLD_MAP.put(0x1F39, "\u1F31");
        CASEFOLD_MAP.put(0x1F3A, "\u1F32");
        CASEFOLD_MAP.put(0x1F3B, "\u1F33");
        CASEFOLD_MAP.put(0x1F3C, "\u1F34");
        CASEFOLD_MAP.put(0x1F3D, "\u1F35");
        CASEFOLD_MAP.put(0x1F3E, "\u1F36");
        CASEFOLD_MAP.put(0x1F3F, "\u1F37");
        CASEFOLD_MAP.put(0x1F48, "\u1F40");
        CASEFOLD_MAP.put(0x1F49, "\u1F41");
        CASEFOLD_MAP.put(0x1F4A, "\u1F42");
        CASEFOLD_MAP.put(0x1F4B, "\u1F43");
        CASEFOLD_MAP.put(0x1F4C, "\u1F44");
        CASEFOLD_MAP.put(0x1F4D, "\u1F45");
        CASEFOLD_MAP.put(0x1F50, "\u03C5\u0313");
        CASEFOLD_MAP.put(0x1F52, "\u03C5\u0313\u0300");
        CASEFOLD_MAP.put(0x1F54, "\u03C5\u0313\u0301");
        CASEFOLD_MAP.put(0x1F56, "\u03C5\u0313\u0342");
        CASEFOLD_MAP.put(0x1F59, "\u1F51");
        CASEFOLD_MAP.put(0x1F5B, "\u1F53");
        CASEFOLD_MAP.put(0x1F5D, "\u1F55");
        CASEFOLD_MAP.put(0x1F5F, "\u1F57");
        CASEFOLD_MAP.put(0x1F68, "\u1F60");
        CASEFOLD_MAP.put(0x1F69, "\u1F61");
        CASEFOLD_MAP.put(0x1F6A, "\u1F62");
        CASEFOLD_MAP.put(0x1F6B, "\u1F63");
        CASEFOLD_MAP.put(0x1F6C, "\u1F64");
        CASEFOLD_MAP.put(0x1F6D, "\u1F65");
        CASEFOLD_MAP.put(0x1F6E, "\u1F66");
        CASEFOLD_MAP.put(0x1F6F, "\u1F67");
        CASEFOLD_MAP.put(0x1F80, "\u1F00\u03B9");
        CASEFOLD_MAP.put(0x1F81, "\u1F01\u03B9");
        CASEFOLD_MAP.put(0x1F82, "\u1F02\u03B9");
        CASEFOLD_MAP.put(0x1F83, "\u1F03\u03B9");
        CASEFOLD_MAP.put(0x1F84, "\u1F04\u03B9");
        CASEFOLD_MAP.put(0x1F85, "\u1F05\u03B9");
        CASEFOLD_MAP.put(0x1F86, "\u1F06\u03B9");
        CASEFOLD_MAP.put(0x1F87, "\u1F07\u03B9");
        CASEFOLD_MAP.put(0x1F88, "\u1F00\u03B9");
        CASEFOLD_MAP.put(0x1F89, "\u1F01\u03B9");
        CASEFOLD_MAP.put(0x1F8A, "\u1F02\u03B9");
        CASEFOLD_MAP.put(0x1F8B, "\u1F03\u03B9");
        CASEFOLD_MAP.put(0x1F8C, "\u1F04\u03B9");
        CASEFOLD_MAP.put(0x1F8D, "\u1F05\u03B9");
        CASEFOLD_MAP.put(0x1F8E, "\u1F06\u03B9");
        CASEFOLD_MAP.put(0x1F8F, "\u1F07\u03B9");
        CASEFOLD_MAP.put(0x1F90, "\u1F20\u03B9");
        CASEFOLD_MAP.put(0x1F91, "\u1F21\u03B9");
        CASEFOLD_MAP.put(0x1F92, "\u1F22\u03B9");
        CASEFOLD_MAP.put(0x1F93, "\u1F23\u03B9");
        CASEFOLD_MAP.put(0x1F94, "\u1F24\u03B9");
        CASEFOLD_MAP.put(0x1F95, "\u1F25\u03B9");
        CASEFOLD_MAP.put(0x1F96, "\u1F26\u03B9");
        CASEFOLD_MAP.put(0x1F97, "\u1F27\u03B9");
        CASEFOLD_MAP.put(0x1F98, "\u1F20\u03B9");
        CASEFOLD_MAP.put(0x1F99, "\u1F21\u03B9");
        CASEFOLD_MAP.put(0x1F9A, "\u1F22\u03B9");
        CASEFOLD_MAP.put(0x1F9B, "\u1F23\u03B9");
        CASEFOLD_MAP.put(0x1F9C, "\u1F24\u03B9");
        CASEFOLD_MAP.put(0x1F9D, "\u1F25\u03B9");
        CASEFOLD_MAP.put(0x1F9E, "\u1F26\u03B9");
        CASEFOLD_MAP.put(0x1F9F, "\u1F27\u03B9");
        CASEFOLD_MAP.put(0x1FA0, "\u1F60\u03B9");
        CASEFOLD_MAP.put(0x1FA1, "\u1F61\u03B9");
        CASEFOLD_MAP.put(0x1FA2, "\u1F62\u03B9");
        CASEFOLD_MAP.put(0x1FA3, "\u1F63\u03B9");
        CASEFOLD_MAP.put(0x1FA4, "\u1F64\u03B9");
        CASEFOLD_MAP.put(0x1FA5, "\u1F65\u03B9");
        CASEFOLD_MAP.put(0x1FA6, "\u1F66\u03B9");
        CASEFOLD_MAP.put(0x1FA7, "\u1F67\u03B9");
        CASEFOLD_MAP.put(0x1FA8, "\u1F60\u03B9");
        CASEFOLD_MAP.put(0x1FA9, "\u1F61\u03B9");
        CASEFOLD_MAP.put(0x1FAA, "\u1F62\u03B9");
        CASEFOLD_MAP.put(0x1FAB, "\u1F63\u03B9");
        CASEFOLD_MAP.put(0x1FAC, "\u1F64\u03B9");
        CASEFOLD_MAP.put(0x1FAD, "\u1F65\u03B9");
        CASEFOLD_MAP.put(0x1FAE, "\u1F66\u03B9");
        CASEFOLD_MAP.put(0x1FAF, "\u1F67\u03B9");
        CASEFOLD_MAP.put(0x1FB2, "\u1F70\u03B9");
        CASEFOLD_MAP.put(0x1FB3, "\u03B1\u03B9");
        CASEFOLD_MAP.put(0x1FB4, "\u03AC\u03B9");
        CASEFOLD_MAP.put(0x1FB6, "\u03B1\u0342");
        CASEFOLD_MAP.put(0x1FB7, "\u03B1\u0342\u03B9");
        CASEFOLD_MAP.put(0x1FB8, "\u1FB0");
        CASEFOLD_MAP.put(0x1FB9, "\u1FB1");
        CASEFOLD_MAP.put(0x1FBA, "\u1F70");
        CASEFOLD_MAP.put(0x1FBB, "\u1F71");
        CASEFOLD_MAP.put(0x1FBC, "\u03B1\u03B9");
        CASEFOLD_MAP.put(0x1FBE, "\u03B9");
        CASEFOLD_MAP.put(0x1FC2, "\u1F74\u03B9");
        CASEFOLD_MAP.put(0x1FC3, "\u03B7\u03B9");
        CASEFOLD_MAP.put(0x1FC4, "\u03AE\u03B9");
        CASEFOLD_MAP.put(0x1FC6, "\u03B7\u0342");
        CASEFOLD_MAP.put(0x1FC7, "\u03B7\u0342\u03B9");
        CASEFOLD_MAP.put(0x1FC8, "\u1F72");
        CASEFOLD_MAP.put(0x1FC9, "\u1F73");
        CASEFOLD_MAP.put(0x1FCA, "\u1F74");
        CASEFOLD_MAP.put(0x1FCB, "\u1F75");
        CASEFOLD_MAP.put(0x1FCC, "\u03B7\u03B9");
        CASEFOLD_MAP.put(0x1FD2, "\u03B9\u0308\u0300");
        CASEFOLD_MAP.put(0x1FD3, "\u03B9\u0308\u0301");
        CASEFOLD_MAP.put(0x1FD6, "\u03B9\u0342");
        CASEFOLD_MAP.put(0x1FD7, "\u03B9\u0308\u0342");
        CASEFOLD_MAP.put(0x1FD8, "\u1FD0");
        CASEFOLD_MAP.put(0x1FD9, "\u1FD1");
        CASEFOLD_MAP.put(0x1FDA, "\u1F76");
        CASEFOLD_MAP.put(0x1FDB, "\u1F77");
        CASEFOLD_MAP.put(0x1FE2, "\u03C5\u0308\u0300");
        CASEFOLD_MAP.put(0x1FE3, "\u03C5\u0308\u0301");
        CASEFOLD_MAP.put(0x1FE4, "\u03C1\u0313");
        CASEFOLD_MAP.put(0x1FE6, "\u03C5\u0342");
        CASEFOLD_MAP.put(0x1FE7, "\u03C5\u0308\u0342");
        CASEFOLD_MAP.put(0x1FE8, "\u1FE0");
        CASEFOLD_MAP.put(0x1FE9, "\u1FE1");
        CASEFOLD_MAP.put(0x1FEA, "\u1F7A");
        CASEFOLD_MAP.put(0x1FEB, "\u1F7B");
        CASEFOLD_MAP.put(0x1FEC, "\u1FE5");
        CASEFOLD_MAP.put(0x1FF2, "\u1F7C\u03B9");
        CASEFOLD_MAP.put(0x1FF3, "\u03C9\u03B9");
        CASEFOLD_MAP.put(0x1FF4, "\u03CE\u03B9");
        CASEFOLD_MAP.put(0x1FF6, "\u03C9\u0342");
        CASEFOLD_MAP.put(0x1FF7, "\u03C9\u0342\u03B9");
        CASEFOLD_MAP.put(0x1FF8, "\u1F78");
        CASEFOLD_MAP.put(0x1FF9, "\u1F79");
        CASEFOLD_MAP.put(0x1FFA, "\u1F7C");
        CASEFOLD_MAP.put(0x1FFB, "\u1F7D");
        CASEFOLD_MAP.put(0x1FFC, "\u03C9\u03B9");
        CASEFOLD_MAP.put(0x2126, "\u03C9");
        CASEFOLD_MAP.put(0x212A, "\u006B");
        CASEFOLD_MAP.put(0x212B, "\u00E5");
        CASEFOLD_MAP.put(0x2132, "\u214E");
        CASEFOLD_MAP.put(0x2160, "\u2170");
        CASEFOLD_MAP.put(0x2161, "\u2171");
        CASEFOLD_MAP.put(0x2162, "\u2172");
        CASEFOLD_MAP.put(0x2163, "\u2173");
        CASEFOLD_MAP.put(0x2164, "\u2174");
        CASEFOLD_MAP.put(0x2165, "\u2175");
        CASEFOLD_MAP.put(0x2166, "\u2176");
        CASEFOLD_MAP.put(0x2167, "\u2177");
        CASEFOLD_MAP.put(0x2168, "\u2178");
        CASEFOLD_MAP.put(0x2169, "\u2179");
        CASEFOLD_MAP.put(0x216A, "\u217A");
        CASEFOLD_MAP.put(0x216B, "\u217B");
        CASEFOLD_MAP.put(0x216C, "\u217C");
        CASEFOLD_MAP.put(0x216D, "\u217D");
        CASEFOLD_MAP.put(0x216E, "\u217E");
        CASEFOLD_MAP.put(0x216F, "\u217F");
        CASEFOLD_MAP.put(0x2183, "\u2184");
        CASEFOLD_MAP.put(0x24B6, "\u24D0");
        CASEFOLD_MAP.put(0x24B7, "\u24D1");
        CASEFOLD_MAP.put(0x24B8, "\u24D2");
        CASEFOLD_MAP.put(0x24B9, "\u24D3");
        CASEFOLD_MAP.put(0x24BA, "\u24D4");
        CASEFOLD_MAP.put(0x24BB, "\u24D5");
        CASEFOLD_MAP.put(0x24BC, "\u24D6");
        CASEFOLD_MAP.put(0x24BD, "\u24D7");
        CASEFOLD_MAP.put(0x24BE, "\u24D8");
        CASEFOLD_MAP.put(0x24BF, "\u24D9");
        CASEFOLD_MAP.put(0x24C0, "\u24DA");
        CASEFOLD_MAP.put(0x24C1, "\u24DB");
        CASEFOLD_MAP.put(0x24C2, "\u24DC");
        CASEFOLD_MAP.put(0x24C3, "\u24DD");
        CASEFOLD_MAP.put(0x24C4, "\u24DE");
        CASEFOLD_MAP.put(0x24C5, "\u24DF");
        CASEFOLD_MAP.put(0x24C6, "\u24E0");
        CASEFOLD_MAP.put(0x24C7, "\u24E1");
        CASEFOLD_MAP.put(0x24C8, "\u24E2");
        CASEFOLD_MAP.put(0x24C9, "\u24E3");
        CASEFOLD_MAP.put(0x24CA, "\u24E4");
        CASEFOLD_MAP.put(0x24CB, "\u24E5");
        CASEFOLD_MAP.put(0x24CC, "\u24E6");
        CASEFOLD_MAP.put(0x24CD, "\u24E7");
        CASEFOLD_MAP.put(0x24CE, "\u24E8");
        CASEFOLD_MAP.put(0x24CF, "\u24E9");
        CASEFOLD_MAP.put(0x2C00, "\u2C30");
        CASEFOLD_MAP.put(0x2C01, "\u2C31");
        CASEFOLD_MAP.put(0x2C02, "\u2C32");
        CASEFOLD_MAP.put(0x2C03, "\u2C33");
        CASEFOLD_MAP.put(0x2C04, "\u2C34");
        CASEFOLD_MAP.put(0x2C05, "\u2C35");
        CASEFOLD_MAP.put(0x2C06, "\u2C36");
        CASEFOLD_MAP.put(0x2C07, "\u2C37");
        CASEFOLD_MAP.put(0x2C08, "\u2C38");
        CASEFOLD_MAP.put(0x2C09, "\u2C39");
        CASEFOLD_MAP.put(0x2C0A, "\u2C3A");
        CASEFOLD_MAP.put(0x2C0B, "\u2C3B");
        CASEFOLD_MAP.put(0x2C0C, "\u2C3C");
        CASEFOLD_MAP.put(0x2C0D, "\u2C3D");
        CASEFOLD_MAP.put(0x2C0E, "\u2C3E");
        CASEFOLD_MAP.put(0x2C0F, "\u2C3F");
        CASEFOLD_MAP.put(0x2C10, "\u2C40");
        CASEFOLD_MAP.put(0x2C11, "\u2C41");
        CASEFOLD_MAP.put(0x2C12, "\u2C42");
        CASEFOLD_MAP.put(0x2C13, "\u2C43");
        CASEFOLD_MAP.put(0x2C14, "\u2C44");
        CASEFOLD_MAP.put(0x2C15, "\u2C45");
        CASEFOLD_MAP.put(0x2C16, "\u2C46");
        CASEFOLD_MAP.put(0x2C17, "\u2C47");
        CASEFOLD_MAP.put(0x2C18, "\u2C48");
        CASEFOLD_MAP.put(0x2C19, "\u2C49");
        CASEFOLD_MAP.put(0x2C1A, "\u2C4A");
        CASEFOLD_MAP.put(0x2C1B, "\u2C4B");
        CASEFOLD_MAP.put(0x2C1C, "\u2C4C");
        CASEFOLD_MAP.put(0x2C1D, "\u2C4D");
        CASEFOLD_MAP.put(0x2C1E, "\u2C4E");
        CASEFOLD_MAP.put(0x2C1F, "\u2C4F");
        CASEFOLD_MAP.put(0x2C20, "\u2C50");
        CASEFOLD_MAP.put(0x2C21, "\u2C51");
        CASEFOLD_MAP.put(0x2C22, "\u2C52");
        CASEFOLD_MAP.put(0x2C23, "\u2C53");
        CASEFOLD_MAP.put(0x2C24, "\u2C54");
        CASEFOLD_MAP.put(0x2C25, "\u2C55");
        CASEFOLD_MAP.put(0x2C26, "\u2C56");
        CASEFOLD_MAP.put(0x2C27, "\u2C57");
        CASEFOLD_MAP.put(0x2C28, "\u2C58");
        CASEFOLD_MAP.put(0x2C29, "\u2C59");
        CASEFOLD_MAP.put(0x2C2A, "\u2C5A");
        CASEFOLD_MAP.put(0x2C2B, "\u2C5B");
        CASEFOLD_MAP.put(0x2C2C, "\u2C5C");
        CASEFOLD_MAP.put(0x2C2D, "\u2C5D");
        CASEFOLD_MAP.put(0x2C2E, "\u2C5E");
        CASEFOLD_MAP.put(0x2C2F, "\u2C5F");
        CASEFOLD_MAP.put(0x2C60, "\u2C61");
        CASEFOLD_MAP.put(0x2C62, "\u026B");
        CASEFOLD_MAP.put(0x2C63, "\u1D7D");
        CASEFOLD_MAP.put(0x2C64, "\u027D");
        CASEFOLD_MAP.put(0x2C67, "\u2C68");
        CASEFOLD_MAP.put(0x2C69, "\u2C6A");
        CASEFOLD_MAP.put(0x2C6B, "\u2C6C");
        CASEFOLD_MAP.put(0x2C6D, "\u0251");
        CASEFOLD_MAP.put(0x2C6E, "\u0271");
        CASEFOLD_MAP.put(0x2C6F, "\u0250");
        CASEFOLD_MAP.put(0x2C70, "\u0252");
        CASEFOLD_MAP.put(0x2C72, "\u2C73");
        CASEFOLD_MAP.put(0x2C75, "\u2C76");
        CASEFOLD_MAP.put(0x2C7E, "\u023F");
        CASEFOLD_MAP.put(0x2C7F, "\u0240");
        CASEFOLD_MAP.put(0x2C80, "\u2C81");
        CASEFOLD_MAP.put(0x2C82, "\u2C83");
        CASEFOLD_MAP.put(0x2C84, "\u2C85");
        CASEFOLD_MAP.put(0x2C86, "\u2C87");
        CASEFOLD_MAP.put(0x2C88, "\u2C89");
        CASEFOLD_MAP.put(0x2C8A, "\u2C8B");
        CASEFOLD_MAP.put(0x2C8C, "\u2C8D");
        CASEFOLD_MAP.put(0x2C8E, "\u2C8F");
        CASEFOLD_MAP.put(0x2C90, "\u2C91");
        CASEFOLD_MAP.put(0x2C92, "\u2C93");
        CASEFOLD_MAP.put(0x2C94, "\u2C95");
        CASEFOLD_MAP.put(0x2C96, "\u2C97");
        CASEFOLD_MAP.put(0x2C98, "\u2C99");
        CASEFOLD_MAP.put(0x2C9A, "\u2C9B");
        CASEFOLD_MAP.put(0x2C9C, "\u2C9D");
        CASEFOLD_MAP.put(0x2C9E, "\u2C9F");
        CASEFOLD_MAP.put(0x2CA0, "\u2CA1");
        CASEFOLD_MAP.put(0x2CA2, "\u2CA3");
        CASEFOLD_MAP.put(0x2CA4, "\u2CA5");
        CASEFOLD_MAP.put(0x2CA6, "\u2CA7");
        CASEFOLD_MAP.put(0x2CA8, "\u2CA9");
        CASEFOLD_MAP.put(0x2CAA, "\u2CAB");
        CASEFOLD_MAP.put(0x2CAC, "\u2CAD");
        CASEFOLD_MAP.put(0x2CAE, "\u2CAF");
        CASEFOLD_MAP.put(0x2CB0, "\u2CB1");
        CASEFOLD_MAP.put(0x2CB2, "\u2CB3");
        CASEFOLD_MAP.put(0x2CB4, "\u2CB5");
        CASEFOLD_MAP.put(0x2CB6, "\u2CB7");
        CASEFOLD_MAP.put(0x2CB8, "\u2CB9");
        CASEFOLD_MAP.put(0x2CBA, "\u2CBB");
        CASEFOLD_MAP.put(0x2CBC, "\u2CBD");
        CASEFOLD_MAP.put(0x2CBE, "\u2CBF");
        CASEFOLD_MAP.put(0x2CC0, "\u2CC1");
        CASEFOLD_MAP.put(0x2CC2, "\u2CC3");
        CASEFOLD_MAP.put(0x2CC4, "\u2CC5");
        CASEFOLD_MAP.put(0x2CC6, "\u2CC7");
        CASEFOLD_MAP.put(0x2CC8, "\u2CC9");
        CASEFOLD_MAP.put(0x2CCA, "\u2CCB");
        CASEFOLD_MAP.put(0x2CCC, "\u2CCD");
        CASEFOLD_MAP.put(0x2CCE, "\u2CCF");
        CASEFOLD_MAP.put(0x2CD0, "\u2CD1");
        CASEFOLD_MAP.put(0x2CD2, "\u2CD3");
        CASEFOLD_MAP.put(0x2CD4, "\u2CD5");
        CASEFOLD_MAP.put(0x2CD6, "\u2CD7");
        CASEFOLD_MAP.put(0x2CD8, "\u2CD9");
        CASEFOLD_MAP.put(0x2CDA, "\u2CDB");
        CASEFOLD_MAP.put(0x2CDC, "\u2CDD");
        CASEFOLD_MAP.put(0x2CDE, "\u2CDF");
        CASEFOLD_MAP.put(0x2CE0, "\u2CE1");
        CASEFOLD_MAP.put(0x2CE2, "\u2CE3");
        CASEFOLD_MAP.put(0x2CEB, "\u2CEC");
        CASEFOLD_MAP.put(0x2CED, "\u2CEE");
        CASEFOLD_MAP.put(0x2CF2, "\u2CF3");
        CASEFOLD_MAP.put(0xA640, "\uA641");
        CASEFOLD_MAP.put(0xA642, "\uA643");
        CASEFOLD_MAP.put(0xA644, "\uA645");
        CASEFOLD_MAP.put(0xA646, "\uA647");
        CASEFOLD_MAP.put(0xA648, "\uA649");
        CASEFOLD_MAP.put(0xA64A, "\uA64B");
        CASEFOLD_MAP.put(0xA64C, "\uA64D");
        CASEFOLD_MAP.put(0xA64E, "\uA64F");
        CASEFOLD_MAP.put(0xA650, "\uA651");
        CASEFOLD_MAP.put(0xA652, "\uA653");
        CASEFOLD_MAP.put(0xA654, "\uA655");
        CASEFOLD_MAP.put(0xA656, "\uA657");
        CASEFOLD_MAP.put(0xA658, "\uA659");
        CASEFOLD_MAP.put(0xA65A, "\uA65B");
        CASEFOLD_MAP.put(0xA65C, "\uA65D");
        CASEFOLD_MAP.put(0xA65E, "\uA65F");
        CASEFOLD_MAP.put(0xA660, "\uA661");
        CASEFOLD_MAP.put(0xA662, "\uA663");
        CASEFOLD_MAP.put(0xA664, "\uA665");
        CASEFOLD_MAP.put(0xA666, "\uA667");
        CASEFOLD_MAP.put(0xA668, "\uA669");
        CASEFOLD_MAP.put(0xA66A, "\uA66B");
        CASEFOLD_MAP.put(0xA66C, "\uA66D");
        CASEFOLD_MAP.put(0xA680, "\uA681");
        CASEFOLD_MAP.put(0xA682, "\uA683");
        CASEFOLD_MAP.put(0xA684, "\uA685");
        CASEFOLD_MAP.put(0xA686, "\uA687");
        CASEFOLD_MAP.put(0xA688, "\uA689");
        CASEFOLD_MAP.put(0xA68A, "\uA68B");
        CASEFOLD_MAP.put(0xA68C, "\uA68D");
        CASEFOLD_MAP.put(0xA68E, "\uA68F");
        CASEFOLD_MAP.put(0xA690, "\uA691");
        CASEFOLD_MAP.put(0xA692, "\uA693");
        CASEFOLD_MAP.put(0xA694, "\uA695");
        CASEFOLD_MAP.put(0xA696, "\uA697");
        CASEFOLD_MAP.put(0xA698, "\uA699");
        CASEFOLD_MAP.put(0xA69A, "\uA69B");
        CASEFOLD_MAP.put(0xA722, "\uA723");
        CASEFOLD_MAP.put(0xA724, "\uA725");
        CASEFOLD_MAP.put(0xA726, "\uA727");
        CASEFOLD_MAP.put(0xA728, "\uA729");
        CASEFOLD_MAP.put(0xA72A, "\uA72B");
        CASEFOLD_MAP.put(0xA72C, "\uA72D");
        CASEFOLD_MAP.put(0xA72E, "\uA72F");
        CASEFOLD_MAP.put(0xA732, "\uA733");
        CASEFOLD_MAP.put(0xA734, "\uA735");
        CASEFOLD_MAP.put(0xA736, "\uA737");
        CASEFOLD_MAP.put(0xA738, "\uA739");
        CASEFOLD_MAP.put(0xA73A, "\uA73B");
        CASEFOLD_MAP.put(0xA73C, "\uA73D");
        CASEFOLD_MAP.put(0xA73E, "\uA73F");
        CASEFOLD_MAP.put(0xA740, "\uA741");
        CASEFOLD_MAP.put(0xA742, "\uA743");
        CASEFOLD_MAP.put(0xA744, "\uA745");
        CASEFOLD_MAP.put(0xA746, "\uA747");
        CASEFOLD_MAP.put(0xA748, "\uA749");
        CASEFOLD_MAP.put(0xA74A, "\uA74B");
        CASEFOLD_MAP.put(0xA74C, "\uA74D");
        CASEFOLD_MAP.put(0xA74E, "\uA74F");
        CASEFOLD_MAP.put(0xA750, "\uA751");
        CASEFOLD_MAP.put(0xA752, "\uA753");
        CASEFOLD_MAP.put(0xA754, "\uA755");
        CASEFOLD_MAP.put(0xA756, "\uA757");
        CASEFOLD_MAP.put(0xA758, "\uA759");
        CASEFOLD_MAP.put(0xA75A, "\uA75B");
        CASEFOLD_MAP.put(0xA75C, "\uA75D");
        CASEFOLD_MAP.put(0xA75E, "\uA75F");
        CASEFOLD_MAP.put(0xA760, "\uA761");
        CASEFOLD_MAP.put(0xA762, "\uA763");
        CASEFOLD_MAP.put(0xA764, "\uA765");
        CASEFOLD_MAP.put(0xA766, "\uA767");
        CASEFOLD_MAP.put(0xA768, "\uA769");
        CASEFOLD_MAP.put(0xA76A, "\uA76B");
        CASEFOLD_MAP.put(0xA76C, "\uA76D");
        CASEFOLD_MAP.put(0xA76E, "\uA76F");
        CASEFOLD_MAP.put(0xA779, "\uA77A");
        CASEFOLD_MAP.put(0xA77B, "\uA77C");
        CASEFOLD_MAP.put(0xA77D, "\u1D79");
        CASEFOLD_MAP.put(0xA77E, "\uA77F");
        CASEFOLD_MAP.put(0xA780, "\uA781");
        CASEFOLD_MAP.put(0xA782, "\uA783");
        CASEFOLD_MAP.put(0xA784, "\uA785");
        CASEFOLD_MAP.put(0xA786, "\uA787");
        CASEFOLD_MAP.put(0xA78B, "\uA78C");
        CASEFOLD_MAP.put(0xA78D, "\u0265");
        CASEFOLD_MAP.put(0xA790, "\uA791");
        CASEFOLD_MAP.put(0xA792, "\uA793");
        CASEFOLD_MAP.put(0xA796, "\uA797");
        CASEFOLD_MAP.put(0xA798, "\uA799");
        CASEFOLD_MAP.put(0xA79A, "\uA79B");
        CASEFOLD_MAP.put(0xA79C, "\uA79D");
        CASEFOLD_MAP.put(0xA79E, "\uA79F");
        CASEFOLD_MAP.put(0xA7A0, "\uA7A1");
        CASEFOLD_MAP.put(0xA7A2, "\uA7A3");
        CASEFOLD_MAP.put(0xA7A4, "\uA7A5");
        CASEFOLD_MAP.put(0xA7A6, "\uA7A7");
        CASEFOLD_MAP.put(0xA7A8, "\uA7A9");
        CASEFOLD_MAP.put(0xA7AA, "\u0266");
        CASEFOLD_MAP.put(0xA7AB, "\u025C");
        CASEFOLD_MAP.put(0xA7AC, "\u0261");
        CASEFOLD_MAP.put(0xA7AD, "\u026C");
        CASEFOLD_MAP.put(0xA7AE, "\u026A");
        CASEFOLD_MAP.put(0xA7B0, "\u029E");
        CASEFOLD_MAP.put(0xA7B1, "\u0287");
        CASEFOLD_MAP.put(0xA7B2, "\u029D");
        CASEFOLD_MAP.put(0xA7B3, "\uAB53");
        CASEFOLD_MAP.put(0xA7B4, "\uA7B5");
        CASEFOLD_MAP.put(0xA7B6, "\uA7B7");
        CASEFOLD_MAP.put(0xA7B8, "\uA7B9");
        CASEFOLD_MAP.put(0xA7BA, "\uA7BB");
        CASEFOLD_MAP.put(0xA7BC, "\uA7BD");
        CASEFOLD_MAP.put(0xA7BE, "\uA7BF");
        CASEFOLD_MAP.put(0xA7C0, "\uA7C1");
        CASEFOLD_MAP.put(0xA7C2, "\uA7C3");
        CASEFOLD_MAP.put(0xA7C4, "\uA794");
        CASEFOLD_MAP.put(0xA7C5, "\u0282");
        CASEFOLD_MAP.put(0xA7C6, "\u1D8E");
        CASEFOLD_MAP.put(0xA7C7, "\uA7C8");
        CASEFOLD_MAP.put(0xA7C9, "\uA7CA");
        CASEFOLD_MAP.put(0xA7CB, "\u0264");
        CASEFOLD_MAP.put(0xA7CC, "\uA7CD");
        CASEFOLD_MAP.put(0xA7D0, "\uA7D1");
        CASEFOLD_MAP.put(0xA7D6, "\uA7D7");
        CASEFOLD_MAP.put(0xA7D8, "\uA7D9");
        CASEFOLD_MAP.put(0xA7DA, "\uA7DB");
        CASEFOLD_MAP.put(0xA7DC, "\u019B");
        CASEFOLD_MAP.put(0xA7F5, "\uA7F6");
        CASEFOLD_MAP.put(0xAB70, "\u13A0");
        CASEFOLD_MAP.put(0xAB71, "\u13A1");
        CASEFOLD_MAP.put(0xAB72, "\u13A2");
        CASEFOLD_MAP.put(0xAB73, "\u13A3");
        CASEFOLD_MAP.put(0xAB74, "\u13A4");
        CASEFOLD_MAP.put(0xAB75, "\u13A5");
        CASEFOLD_MAP.put(0xAB76, "\u13A6");
        CASEFOLD_MAP.put(0xAB77, "\u13A7");
        CASEFOLD_MAP.put(0xAB78, "\u13A8");
        CASEFOLD_MAP.put(0xAB79, "\u13A9");
        CASEFOLD_MAP.put(0xAB7A, "\u13AA");
        CASEFOLD_MAP.put(0xAB7B, "\u13AB");
        CASEFOLD_MAP.put(0xAB7C, "\u13AC");
        CASEFOLD_MAP.put(0xAB7D, "\u13AD");
        CASEFOLD_MAP.put(0xAB7E, "\u13AE");
        CASEFOLD_MAP.put(0xAB7F, "\u13AF");
        CASEFOLD_MAP.put(0xAB80, "\u13B0");
        CASEFOLD_MAP.put(0xAB81, "\u13B1");
        CASEFOLD_MAP.put(0xAB82, "\u13B2");
        CASEFOLD_MAP.put(0xAB83, "\u13B3");
        CASEFOLD_MAP.put(0xAB84, "\u13B4");
        CASEFOLD_MAP.put(0xAB85, "\u13B5");
        CASEFOLD_MAP.put(0xAB86, "\u13B6");
        CASEFOLD_MAP.put(0xAB87, "\u13B7");
        CASEFOLD_MAP.put(0xAB88, "\u13B8");
        CASEFOLD_MAP.put(0xAB89, "\u13B9");
        CASEFOLD_MAP.put(0xAB8A, "\u13BA");
        CASEFOLD_MAP.put(0xAB8B, "\u13BB");
        CASEFOLD_MAP.put(0xAB8C, "\u13BC");
        CASEFOLD_MAP.put(0xAB8D, "\u13BD");
        CASEFOLD_MAP.put(0xAB8E, "\u13BE");
        CASEFOLD_MAP.put(0xAB8F, "\u13BF");
        CASEFOLD_MAP.put(0xAB90, "\u13C0");
        CASEFOLD_MAP.put(0xAB91, "\u13C1");
        CASEFOLD_MAP.put(0xAB92, "\u13C2");
        CASEFOLD_MAP.put(0xAB93, "\u13C3");
        CASEFOLD_MAP.put(0xAB94, "\u13C4");
        CASEFOLD_MAP.put(0xAB95, "\u13C5");
        CASEFOLD_MAP.put(0xAB96, "\u13C6");
        CASEFOLD_MAP.put(0xAB97, "\u13C7");
        CASEFOLD_MAP.put(0xAB98, "\u13C8");
        CASEFOLD_MAP.put(0xAB99, "\u13C9");
        CASEFOLD_MAP.put(0xAB9A, "\u13CA");
        CASEFOLD_MAP.put(0xAB9B, "\u13CB");
        CASEFOLD_MAP.put(0xAB9C, "\u13CC");
        CASEFOLD_MAP.put(0xAB9D, "\u13CD");
        CASEFOLD_MAP.put(0xAB9E, "\u13CE");
        CASEFOLD_MAP.put(0xAB9F, "\u13CF");
        CASEFOLD_MAP.put(0xABA0, "\u13D0");
        CASEFOLD_MAP.put(0xABA1, "\u13D1");
        CASEFOLD_MAP.put(0xABA2, "\u13D2");
        CASEFOLD_MAP.put(0xABA3, "\u13D3");
        CASEFOLD_MAP.put(0xABA4, "\u13D4");
        CASEFOLD_MAP.put(0xABA5, "\u13D5");
        CASEFOLD_MAP.put(0xABA6, "\u13D6");
        CASEFOLD_MAP.put(0xABA7, "\u13D7");
        CASEFOLD_MAP.put(0xABA8, "\u13D8");
        CASEFOLD_MAP.put(0xABA9, "\u13D9");
        CASEFOLD_MAP.put(0xABAA, "\u13DA");
        CASEFOLD_MAP.put(0xABAB, "\u13DB");
        CASEFOLD_MAP.put(0xABAC, "\u13DC");
        CASEFOLD_MAP.put(0xABAD, "\u13DD");
        CASEFOLD_MAP.put(0xABAE, "\u13DE");
        CASEFOLD_MAP.put(0xABAF, "\u13DF");
        CASEFOLD_MAP.put(0xABB0, "\u13E0");
        CASEFOLD_MAP.put(0xABB1, "\u13E1");
        CASEFOLD_MAP.put(0xABB2, "\u13E2");
        CASEFOLD_MAP.put(0xABB3, "\u13E3");
        CASEFOLD_MAP.put(0xABB4, "\u13E4");
        CASEFOLD_MAP.put(0xABB5, "\u13E5");
        CASEFOLD_MAP.put(0xABB6, "\u13E6");
        CASEFOLD_MAP.put(0xABB7, "\u13E7");
        CASEFOLD_MAP.put(0xABB8, "\u13E8");
        CASEFOLD_MAP.put(0xABB9, "\u13E9");
        CASEFOLD_MAP.put(0xABBA, "\u13EA");
        CASEFOLD_MAP.put(0xABBB, "\u13EB");
        CASEFOLD_MAP.put(0xABBC, "\u13EC");
        CASEFOLD_MAP.put(0xABBD, "\u13ED");
        CASEFOLD_MAP.put(0xABBE, "\u13EE");
        CASEFOLD_MAP.put(0xABBF, "\u13EF");
        CASEFOLD_MAP.put(0xFB00, "\u0066\u0066");
        CASEFOLD_MAP.put(0xFB01, "\u0066\u0069");
        CASEFOLD_MAP.put(0xFB02, "\u0066\u006C");
        CASEFOLD_MAP.put(0xFB03, "\u0066\u0066\u0069");
        CASEFOLD_MAP.put(0xFB04, "\u0066\u0066\u006C");
        CASEFOLD_MAP.put(0xFB05, "\u0073\u0074");
        CASEFOLD_MAP.put(0xFB06, "\u0073\u0074");
        CASEFOLD_MAP.put(0xFB13, "\u0574\u0576");
        CASEFOLD_MAP.put(0xFB14, "\u0574\u0565");
        CASEFOLD_MAP.put(0xFB15, "\u0574\u056B");
        CASEFOLD_MAP.put(0xFB16, "\u057E\u0576");
        CASEFOLD_MAP.put(0xFB17, "\u0574\u056D");
        CASEFOLD_MAP.put(0xFF21, "\uFF41");
        CASEFOLD_MAP.put(0xFF22, "\uFF42");
        CASEFOLD_MAP.put(0xFF23, "\uFF43");
        CASEFOLD_MAP.put(0xFF24, "\uFF44");
        CASEFOLD_MAP.put(0xFF25, "\uFF45");
        CASEFOLD_MAP.put(0xFF26, "\uFF46");
        CASEFOLD_MAP.put(0xFF27, "\uFF47");
        CASEFOLD_MAP.put(0xFF28, "\uFF48");
        CASEFOLD_MAP.put(0xFF29, "\uFF49");
        CASEFOLD_MAP.put(0xFF2A, "\uFF4A");
        CASEFOLD_MAP.put(0xFF2B, "\uFF4B");
        CASEFOLD_MAP.put(0xFF2C, "\uFF4C");
        CASEFOLD_MAP.put(0xFF2D, "\uFF4D");
        CASEFOLD_MAP.put(0xFF2E, "\uFF4E");
        CASEFOLD_MAP.put(0xFF2F, "\uFF4F");
        CASEFOLD_MAP.put(0xFF30, "\uFF50");
        CASEFOLD_MAP.put(0xFF31, "\uFF51");
        CASEFOLD_MAP.put(0xFF32, "\uFF52");
        CASEFOLD_MAP.put(0xFF33, "\uFF53");
        CASEFOLD_MAP.put(0xFF34, "\uFF54");
        CASEFOLD_MAP.put(0xFF35, "\uFF55");
        CASEFOLD_MAP.put(0xFF36, "\uFF56");
        CASEFOLD_MAP.put(0xFF37, "\uFF57");
        CASEFOLD_MAP.put(0xFF38, "\uFF58");
        CASEFOLD_MAP.put(0xFF39, "\uFF59");
        CASEFOLD_MAP.put(0xFF3A, "\uFF5A");
        CASEFOLD_MAP.put(0x10400, "\uD801\uDC28");
        CASEFOLD_MAP.put(0x10401, "\uD801\uDC29");
        CASEFOLD_MAP.put(0x10402, "\uD801\uDC2A");
        CASEFOLD_MAP.put(0x10403, "\uD801\uDC2B");
        CASEFOLD_MAP.put(0x10404, "\uD801\uDC2C");
        CASEFOLD_MAP.put(0x10405, "\uD801\uDC2D");
        CASEFOLD_MAP.put(0x10406, "\uD801\uDC2E");
        CASEFOLD_MAP.put(0x10407, "\uD801\uDC2F");
        CASEFOLD_MAP.put(0x10408, "\uD801\uDC30");
        CASEFOLD_MAP.put(0x10409, "\uD801\uDC31");
        CASEFOLD_MAP.put(0x1040A, "\uD801\uDC32");
        CASEFOLD_MAP.put(0x1040B, "\uD801\uDC33");
        CASEFOLD_MAP.put(0x1040C, "\uD801\uDC34");
        CASEFOLD_MAP.put(0x1040D, "\uD801\uDC35");
        CASEFOLD_MAP.put(0x1040E, "\uD801\uDC36");
        CASEFOLD_MAP.put(0x1040F, "\uD801\uDC37");
        CASEFOLD_MAP.put(0x10410, "\uD801\uDC38");
        CASEFOLD_MAP.put(0x10411, "\uD801\uDC39");
        CASEFOLD_MAP.put(0x10412, "\uD801\uDC3A");
        CASEFOLD_MAP.put(0x10413, "\uD801\uDC3B");
        CASEFOLD_MAP.put(0x10414, "\uD801\uDC3C");
        CASEFOLD_MAP.put(0x10415, "\uD801\uDC3D");
        CASEFOLD_MAP.put(0x10416, "\uD801\uDC3E");
        CASEFOLD_MAP.put(0x10417, "\uD801\uDC3F");
        CASEFOLD_MAP.put(0x10418, "\uD801\uDC40");
        CASEFOLD_MAP.put(0x10419, "\uD801\uDC41");
        CASEFOLD_MAP.put(0x1041A, "\uD801\uDC42");
        CASEFOLD_MAP.put(0x1041B, "\uD801\uDC43");
        CASEFOLD_MAP.put(0x1041C, "\uD801\uDC44");
        CASEFOLD_MAP.put(0x1041D, "\uD801\uDC45");
        CASEFOLD_MAP.put(0x1041E, "\uD801\uDC46");
        CASEFOLD_MAP.put(0x1041F, "\uD801\uDC47");
        CASEFOLD_MAP.put(0x10420, "\uD801\uDC48");
        CASEFOLD_MAP.put(0x10421, "\uD801\uDC49");
        CASEFOLD_MAP.put(0x10422, "\uD801\uDC4A");
        CASEFOLD_MAP.put(0x10423, "\uD801\uDC4B");
        CASEFOLD_MAP.put(0x10424, "\uD801\uDC4C");
        CASEFOLD_MAP.put(0x10425, "\uD801\uDC4D");
        CASEFOLD_MAP.put(0x10426, "\uD801\uDC4E");
        CASEFOLD_MAP.put(0x10427, "\uD801\uDC4F");
        CASEFOLD_MAP.put(0x104B0, "\uD801\uDCD8");
        CASEFOLD_MAP.put(0x104B1, "\uD801\uDCD9");
        CASEFOLD_MAP.put(0x104B2, "\uD801\uDCDA");
        CASEFOLD_MAP.put(0x104B3, "\uD801\uDCDB");
        CASEFOLD_MAP.put(0x104B4, "\uD801\uDCDC");
        CASEFOLD_MAP.put(0x104B5, "\uD801\uDCDD");
        CASEFOLD_MAP.put(0x104B6, "\uD801\uDCDE");
        CASEFOLD_MAP.put(0x104B7, "\uD801\uDCDF");
        CASEFOLD_MAP.put(0x104B8, "\uD801\uDCE0");
        CASEFOLD_MAP.put(0x104B9, "\uD801\uDCE1");
        CASEFOLD_MAP.put(0x104BA, "\uD801\uDCE2");
        CASEFOLD_MAP.put(0x104BB, "\uD801\uDCE3");
        CASEFOLD_MAP.put(0x104BC, "\uD801\uDCE4");
        CASEFOLD_MAP.put(0x104BD, "\uD801\uDCE5");
        CASEFOLD_MAP.put(0x104BE, "\uD801\uDCE6");
        CASEFOLD_MAP.put(0x104BF, "\uD801\uDCE7");
        CASEFOLD_MAP.put(0x104C0, "\uD801\uDCE8");
        CASEFOLD_MAP.put(0x104C1, "\uD801\uDCE9");
        CASEFOLD_MAP.put(0x104C2, "\uD801\uDCEA");
        CASEFOLD_MAP.put(0x104C3, "\uD801\uDCEB");
        CASEFOLD_MAP.put(0x104C4, "\uD801\uDCEC");
        CASEFOLD_MAP.put(0x104C5, "\uD801\uDCED");
        CASEFOLD_MAP.put(0x104C6, "\uD801\uDCEE");
        CASEFOLD_MAP.put(0x104C7, "\uD801\uDCEF");
        CASEFOLD_MAP.put(0x104C8, "\uD801\uDCF0");
        CASEFOLD_MAP.put(0x104C9, "\uD801\uDCF1");
        CASEFOLD_MAP.put(0x104CA, "\uD801\uDCF2");
        CASEFOLD_MAP.put(0x104CB, "\uD801\uDCF3");
        CASEFOLD_MAP.put(0x104CC, "\uD801\uDCF4");
        CASEFOLD_MAP.put(0x104CD, "\uD801\uDCF5");
        CASEFOLD_MAP.put(0x104CE, "\uD801\uDCF6");
        CASEFOLD_MAP.put(0x104CF, "\uD801\uDCF7");
        CASEFOLD_MAP.put(0x104D0, "\uD801\uDCF8");
        CASEFOLD_MAP.put(0x104D1, "\uD801\uDCF9");
        CASEFOLD_MAP.put(0x104D2, "\uD801\uDCFA");
        CASEFOLD_MAP.put(0x104D3, "\uD801\uDCFB");
        CASEFOLD_MAP.put(0x10570, "\uD801\uDD97");
        CASEFOLD_MAP.put(0x10571, "\uD801\uDD98");
        CASEFOLD_MAP.put(0x10572, "\uD801\uDD99");
        CASEFOLD_MAP.put(0x10573, "\uD801\uDD9A");
        CASEFOLD_MAP.put(0x10574, "\uD801\uDD9B");
        CASEFOLD_MAP.put(0x10575, "\uD801\uDD9C");
        CASEFOLD_MAP.put(0x10576, "\uD801\uDD9D");
        CASEFOLD_MAP.put(0x10577, "\uD801\uDD9E");
        CASEFOLD_MAP.put(0x10578, "\uD801\uDD9F");
        CASEFOLD_MAP.put(0x10579, "\uD801\uDDA0");
        CASEFOLD_MAP.put(0x1057A, "\uD801\uDDA1");
        CASEFOLD_MAP.put(0x1057C, "\uD801\uDDA3");
        CASEFOLD_MAP.put(0x1057D, "\uD801\uDDA4");
        CASEFOLD_MAP.put(0x1057E, "\uD801\uDDA5");
        CASEFOLD_MAP.put(0x1057F, "\uD801\uDDA6");
        CASEFOLD_MAP.put(0x10580, "\uD801\uDDA7");
        CASEFOLD_MAP.put(0x10581, "\uD801\uDDA8");
        CASEFOLD_MAP.put(0x10582, "\uD801\uDDA9");
        CASEFOLD_MAP.put(0x10583, "\uD801\uDDAA");
        CASEFOLD_MAP.put(0x10584, "\uD801\uDDAB");
        CASEFOLD_MAP.put(0x10585, "\uD801\uDDAC");
        CASEFOLD_MAP.put(0x10586, "\uD801\uDDAD");
        CASEFOLD_MAP.put(0x10587, "\uD801\uDDAE");
        CASEFOLD_MAP.put(0x10588, "\uD801\uDDAF");
        CASEFOLD_MAP.put(0x10589, "\uD801\uDDB0");
        CASEFOLD_MAP.put(0x1058A, "\uD801\uDDB1");
        CASEFOLD_MAP.put(0x1058C, "\uD801\uDDB3");
        CASEFOLD_MAP.put(0x1058D, "\uD801\uDDB4");
        CASEFOLD_MAP.put(0x1058E, "\uD801\uDDB5");
        CASEFOLD_MAP.put(0x1058F, "\uD801\uDDB6");
        CASEFOLD_MAP.put(0x10590, "\uD801\uDDB7");
        CASEFOLD_MAP.put(0x10591, "\uD801\uDDB8");
        CASEFOLD_MAP.put(0x10592, "\uD801\uDDB9");
        CASEFOLD_MAP.put(0x10594, "\uD801\uDDBB");
        CASEFOLD_MAP.put(0x10595, "\uD801\uDDBC");
        CASEFOLD_MAP.put(0x10C80, "\uD803\uDCC0");
        CASEFOLD_MAP.put(0x10C81, "\uD803\uDCC1");
        CASEFOLD_MAP.put(0x10C82, "\uD803\uDCC2");
        CASEFOLD_MAP.put(0x10C83, "\uD803\uDCC3");
        CASEFOLD_MAP.put(0x10C84, "\uD803\uDCC4");
        CASEFOLD_MAP.put(0x10C85, "\uD803\uDCC5");
        CASEFOLD_MAP.put(0x10C86, "\uD803\uDCC6");
        CASEFOLD_MAP.put(0x10C87, "\uD803\uDCC7");
        CASEFOLD_MAP.put(0x10C88, "\uD803\uDCC8");
        CASEFOLD_MAP.put(0x10C89, "\uD803\uDCC9");
        CASEFOLD_MAP.put(0x10C8A, "\uD803\uDCCA");
        CASEFOLD_MAP.put(0x10C8B, "\uD803\uDCCB");
        CASEFOLD_MAP.put(0x10C8C, "\uD803\uDCCC");
        CASEFOLD_MAP.put(0x10C8D, "\uD803\uDCCD");
        CASEFOLD_MAP.put(0x10C8E, "\uD803\uDCCE");
        CASEFOLD_MAP.put(0x10C8F, "\uD803\uDCCF");
        CASEFOLD_MAP.put(0x10C90, "\uD803\uDCD0");
        CASEFOLD_MAP.put(0x10C91, "\uD803\uDCD1");
        CASEFOLD_MAP.put(0x10C92, "\uD803\uDCD2");
        CASEFOLD_MAP.put(0x10C93, "\uD803\uDCD3");
        CASEFOLD_MAP.put(0x10C94, "\uD803\uDCD4");
        CASEFOLD_MAP.put(0x10C95, "\uD803\uDCD5");
        CASEFOLD_MAP.put(0x10C96, "\uD803\uDCD6");
        CASEFOLD_MAP.put(0x10C97, "\uD803\uDCD7");
        CASEFOLD_MAP.put(0x10C98, "\uD803\uDCD8");
        CASEFOLD_MAP.put(0x10C99, "\uD803\uDCD9");
        CASEFOLD_MAP.put(0x10C9A, "\uD803\uDCDA");
        CASEFOLD_MAP.put(0x10C9B, "\uD803\uDCDB");
        CASEFOLD_MAP.put(0x10C9C, "\uD803\uDCDC");
        CASEFOLD_MAP.put(0x10C9D, "\uD803\uDCDD");
        CASEFOLD_MAP.put(0x10C9E, "\uD803\uDCDE");
        CASEFOLD_MAP.put(0x10C9F, "\uD803\uDCDF");
        CASEFOLD_MAP.put(0x10CA0, "\uD803\uDCE0");
        CASEFOLD_MAP.put(0x10CA1, "\uD803\uDCE1");
        CASEFOLD_MAP.put(0x10CA2, "\uD803\uDCE2");
        CASEFOLD_MAP.put(0x10CA3, "\uD803\uDCE3");
        CASEFOLD_MAP.put(0x10CA4, "\uD803\uDCE4");
        CASEFOLD_MAP.put(0x10CA5, "\uD803\uDCE5");
        CASEFOLD_MAP.put(0x10CA6, "\uD803\uDCE6");
        CASEFOLD_MAP.put(0x10CA7, "\uD803\uDCE7");
        CASEFOLD_MAP.put(0x10CA8, "\uD803\uDCE8");
        CASEFOLD_MAP.put(0x10CA9, "\uD803\uDCE9");
        CASEFOLD_MAP.put(0x10CAA, "\uD803\uDCEA");
        CASEFOLD_MAP.put(0x10CAB, "\uD803\uDCEB");
        CASEFOLD_MAP.put(0x10CAC, "\uD803\uDCEC");
        CASEFOLD_MAP.put(0x10CAD, "\uD803\uDCED");
        CASEFOLD_MAP.put(0x10CAE, "\uD803\uDCEE");
        CASEFOLD_MAP.put(0x10CAF, "\uD803\uDCEF");
        CASEFOLD_MAP.put(0x10CB0, "\uD803\uDCF0");
        CASEFOLD_MAP.put(0x10CB1, "\uD803\uDCF1");
        CASEFOLD_MAP.put(0x10CB2, "\uD803\uDCF2");
        CASEFOLD_MAP.put(0x10D50, "\uD803\uDD70");
        CASEFOLD_MAP.put(0x10D51, "\uD803\uDD71");
        CASEFOLD_MAP.put(0x10D52, "\uD803\uDD72");
        CASEFOLD_MAP.put(0x10D53, "\uD803\uDD73");
        CASEFOLD_MAP.put(0x10D54, "\uD803\uDD74");
        CASEFOLD_MAP.put(0x10D55, "\uD803\uDD75");
        CASEFOLD_MAP.put(0x10D56, "\uD803\uDD76");
        CASEFOLD_MAP.put(0x10D57, "\uD803\uDD77");
        CASEFOLD_MAP.put(0x10D58, "\uD803\uDD78");
        CASEFOLD_MAP.put(0x10D59, "\uD803\uDD79");
        CASEFOLD_MAP.put(0x10D5A, "\uD803\uDD7A");
        CASEFOLD_MAP.put(0x10D5B, "\uD803\uDD7B");
        CASEFOLD_MAP.put(0x10D5C, "\uD803\uDD7C");
        CASEFOLD_MAP.put(0x10D5D, "\uD803\uDD7D");
        CASEFOLD_MAP.put(0x10D5E, "\uD803\uDD7E");
        CASEFOLD_MAP.put(0x10D5F, "\uD803\uDD7F");
        CASEFOLD_MAP.put(0x10D60, "\uD803\uDD80");
        CASEFOLD_MAP.put(0x10D61, "\uD803\uDD81");
        CASEFOLD_MAP.put(0x10D62, "\uD803\uDD82");
        CASEFOLD_MAP.put(0x10D63, "\uD803\uDD83");
        CASEFOLD_MAP.put(0x10D64, "\uD803\uDD84");
        CASEFOLD_MAP.put(0x10D65, "\uD803\uDD85");
        CASEFOLD_MAP.put(0x118A0, "\uD806\uDCC0");
        CASEFOLD_MAP.put(0x118A1, "\uD806\uDCC1");
        CASEFOLD_MAP.put(0x118A2, "\uD806\uDCC2");
        CASEFOLD_MAP.put(0x118A3, "\uD806\uDCC3");
        CASEFOLD_MAP.put(0x118A4, "\uD806\uDCC4");
        CASEFOLD_MAP.put(0x118A5, "\uD806\uDCC5");
        CASEFOLD_MAP.put(0x118A6, "\uD806\uDCC6");
        CASEFOLD_MAP.put(0x118A7, "\uD806\uDCC7");
        CASEFOLD_MAP.put(0x118A8, "\uD806\uDCC8");
        CASEFOLD_MAP.put(0x118A9, "\uD806\uDCC9");
        CASEFOLD_MAP.put(0x118AA, "\uD806\uDCCA");
        CASEFOLD_MAP.put(0x118AB, "\uD806\uDCCB");
        CASEFOLD_MAP.put(0x118AC, "\uD806\uDCCC");
        CASEFOLD_MAP.put(0x118AD, "\uD806\uDCCD");
        CASEFOLD_MAP.put(0x118AE, "\uD806\uDCCE");
        CASEFOLD_MAP.put(0x118AF, "\uD806\uDCCF");
        CASEFOLD_MAP.put(0x118B0, "\uD806\uDCD0");
        CASEFOLD_MAP.put(0x118B1, "\uD806\uDCD1");
        CASEFOLD_MAP.put(0x118B2, "\uD806\uDCD2");
        CASEFOLD_MAP.put(0x118B3, "\uD806\uDCD3");
        CASEFOLD_MAP.put(0x118B4, "\uD806\uDCD4");
        CASEFOLD_MAP.put(0x118B5, "\uD806\uDCD5");
        CASEFOLD_MAP.put(0x118B6, "\uD806\uDCD6");
        CASEFOLD_MAP.put(0x118B7, "\uD806\uDCD7");
        CASEFOLD_MAP.put(0x118B8, "\uD806\uDCD8");
        CASEFOLD_MAP.put(0x118B9, "\uD806\uDCD9");
        CASEFOLD_MAP.put(0x118BA, "\uD806\uDCDA");
        CASEFOLD_MAP.put(0x118BB, "\uD806\uDCDB");
        CASEFOLD_MAP.put(0x118BC, "\uD806\uDCDC");
        CASEFOLD_MAP.put(0x118BD, "\uD806\uDCDD");
        CASEFOLD_MAP.put(0x118BE, "\uD806\uDCDE");
        CASEFOLD_MAP.put(0x118BF, "\uD806\uDCDF");
        CASEFOLD_MAP.put(0x16E40, "\uD81B\uDE60");
        CASEFOLD_MAP.put(0x16E41, "\uD81B\uDE61");
        CASEFOLD_MAP.put(0x16E42, "\uD81B\uDE62");
        CASEFOLD_MAP.put(0x16E43, "\uD81B\uDE63");
        CASEFOLD_MAP.put(0x16E44, "\uD81B\uDE64");
        CASEFOLD_MAP.put(0x16E45, "\uD81B\uDE65");
        CASEFOLD_MAP.put(0x16E46, "\uD81B\uDE66");
        CASEFOLD_MAP.put(0x16E47, "\uD81B\uDE67");
        CASEFOLD_MAP.put(0x16E48, "\uD81B\uDE68");
        CASEFOLD_MAP.put(0x16E49, "\uD81B\uDE69");
        CASEFOLD_MAP.put(0x16E4A, "\uD81B\uDE6A");
        CASEFOLD_MAP.put(0x16E4B, "\uD81B\uDE6B");
        CASEFOLD_MAP.put(0x16E4C, "\uD81B\uDE6C");
        CASEFOLD_MAP.put(0x16E4D, "\uD81B\uDE6D");
        CASEFOLD_MAP.put(0x16E4E, "\uD81B\uDE6E");
        CASEFOLD_MAP.put(0x16E4F, "\uD81B\uDE6F");
        CASEFOLD_MAP.put(0x16E50, "\uD81B\uDE70");
        CASEFOLD_MAP.put(0x16E51, "\uD81B\uDE71");
        CASEFOLD_MAP.put(0x16E52, "\uD81B\uDE72");
        CASEFOLD_MAP.put(0x16E53, "\uD81B\uDE73");
        CASEFOLD_MAP.put(0x16E54, "\uD81B\uDE74");
        CASEFOLD_MAP.put(0x16E55, "\uD81B\uDE75");
        CASEFOLD_MAP.put(0x16E56, "\uD81B\uDE76");
        CASEFOLD_MAP.put(0x16E57, "\uD81B\uDE77");
        CASEFOLD_MAP.put(0x16E58, "\uD81B\uDE78");
        CASEFOLD_MAP.put(0x16E59, "\uD81B\uDE79");
        CASEFOLD_MAP.put(0x16E5A, "\uD81B\uDE7A");
        CASEFOLD_MAP.put(0x16E5B, "\uD81B\uDE7B");
        CASEFOLD_MAP.put(0x16E5C, "\uD81B\uDE7C");
        CASEFOLD_MAP.put(0x16E5D, "\uD81B\uDE7D");
        CASEFOLD_MAP.put(0x16E5E, "\uD81B\uDE7E");
        CASEFOLD_MAP.put(0x16E5F, "\uD81B\uDE7F");
        CASEFOLD_MAP.put(0x1E900, "\uD83A\uDD22");
        CASEFOLD_MAP.put(0x1E901, "\uD83A\uDD23");
        CASEFOLD_MAP.put(0x1E902, "\uD83A\uDD24");
        CASEFOLD_MAP.put(0x1E903, "\uD83A\uDD25");
        CASEFOLD_MAP.put(0x1E904, "\uD83A\uDD26");
        CASEFOLD_MAP.put(0x1E905, "\uD83A\uDD27");
        CASEFOLD_MAP.put(0x1E906, "\uD83A\uDD28");
        CASEFOLD_MAP.put(0x1E907, "\uD83A\uDD29");
        CASEFOLD_MAP.put(0x1E908, "\uD83A\uDD2A");
        CASEFOLD_MAP.put(0x1E909, "\uD83A\uDD2B");
        CASEFOLD_MAP.put(0x1E90A, "\uD83A\uDD2C");
        CASEFOLD_MAP.put(0x1E90B, "\uD83A\uDD2D");
        CASEFOLD_MAP.put(0x1E90C, "\uD83A\uDD2E");
        CASEFOLD_MAP.put(0x1E90D, "\uD83A\uDD2F");
        CASEFOLD_MAP.put(0x1E90E, "\uD83A\uDD30");
        CASEFOLD_MAP.put(0x1E90F, "\uD83A\uDD31");
        CASEFOLD_MAP.put(0x1E910, "\uD83A\uDD32");
        CASEFOLD_MAP.put(0x1E911, "\uD83A\uDD33");
        CASEFOLD_MAP.put(0x1E912, "\uD83A\uDD34");
        CASEFOLD_MAP.put(0x1E913, "\uD83A\uDD35");
        CASEFOLD_MAP.put(0x1E914, "\uD83A\uDD36");
        CASEFOLD_MAP.put(0x1E915, "\uD83A\uDD37");
        CASEFOLD_MAP.put(0x1E916, "\uD83A\uDD38");
        CASEFOLD_MAP.put(0x1E917, "\uD83A\uDD39");
        CASEFOLD_MAP.put(0x1E918, "\uD83A\uDD3A");
        CASEFOLD_MAP.put(0x1E919, "\uD83A\uDD3B");
        CASEFOLD_MAP.put(0x1E91A, "\uD83A\uDD3C");
        CASEFOLD_MAP.put(0x1E91B, "\uD83A\uDD3D");
        CASEFOLD_MAP.put(0x1E91C, "\uD83A\uDD3E");
        CASEFOLD_MAP.put(0x1E91D, "\uD83A\uDD3F");
        CASEFOLD_MAP.put(0x1E91E, "\uD83A\uDD40");
        CASEFOLD_MAP.put(0x1E91F, "\uD83A\uDD41");
        CASEFOLD_MAP.put(0x1E920, "\uD83A\uDD42");
        CASEFOLD_MAP.put(0x1E921, "\uD83A\uDD43");
    }

}