/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.builtins.functions.JavaMethodCall;
import ch.turic.memory.LngList;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JavaMethodCallVararg
implements TuriFunction {
    @Override
    public String name() {
        return "java_call_vararg";
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        FunUtils.ArgumentsHolder args = FunUtils.args(this.name(), arguments, Object.class, String.class, Object[].class);
        LngList varargList = args.last().as(LngList.class);
        String methodName = args.at(1).as(String.class);
        JavaMethodCall.Tuple tuple = JavaMethodCall.getKlassAndObject(args);
        Class<?> klass = tuple.klass();
        Object object = tuple.object();
        for (Method method : klass.getMethods()) {
            Class<?> pType;
            if (!method.getName().equals(methodName) || method.isSynthetic() || !method.isVarArgs() || method.getParameterCount() != args.N - 2) continue;
            int i = 2;
            int j = 0;
            while (j < method.getParameterTypes().length - 1 && (pType = method.getParameterTypes()[j]).isAssignableFrom(args.at((int)i).type)) {
                TypeDescriptor.OfField lastPType = method.getParameterTypes()[method.getParameterTypes().length - 1].arrayType();
                while (i < args.N - 1 && ((Class)lastPType).isAssignableFrom(args.at((int)i).type)) {
                    ++i;
                }
                ++j;
                ++i;
            }
            if (i != args.N - 1) continue;
            try {
                Object[] javaArgs = new Object[method.getParameterCount()];
                int k = 2;
                int h = 0;
                while (h < method.getParameterCount() - 1) {
                    javaArgs[h++] = args.at(k++).get();
                }
                Class<?> varargComponentType = method.getParameterTypes()[method.getParameterCount() - 1].getComponentType();
                Object varargs = Array.newInstance(varargComponentType, varargList.array.size());
                for (int v = 0; v < varargList.array.size(); ++v) {
                    Object vararg = varargList.array.get(v);
                    Array.set(varargs, v, vararg);
                }
                javaArgs[h] = varargs;
                return method.invoke(object, javaArgs);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ExecutionException("Cannot invoke method '" + methodName + "'.", new Object[]{e});
            }
        }
        throw new ExecutionException("Cannot find method '" + methodName + "'.", new Object[0]);
    }
}

