/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class JavaNewObject
implements TuriFunction {
    @Override
    public String name() {
        return "java_object";
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        FunUtils.ArgumentsHolder args = FunUtils.args(this.name(), arguments, String.class, Object[].class);
        String className = args.at(0).as(String.class);
        try {
            Class<?> klass = Class.forName(className);
            for (Constructor<?> constructor : klass.getConstructors()) {
                if (constructor.getParameterCount() != args.N - 1 || constructor.isSynthetic()) continue;
                int i = 1;
                for (Class<?> pType : constructor.getParameterTypes()) {
                    if (!pType.isAssignableFrom(args.at((int)i).type)) break;
                    ++i;
                }
                if (i != args.N) continue;
                Object[] javaArgs = args.tail(1);
                return constructor.newInstance(javaArgs);
            }
            throw new ExecutionException("No suitable constructor found for class " + className, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new ExecutionException("Could not load class " + className, new Object[]{e});
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("Could not invoke constructor " + className, new Object[]{e.getCause()});
        }
        catch (InstantiationException e) {
            throw new ExecutionException("Could not instantiate class " + className, new Object[]{e});
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Could not access constructor " + className, new Object[]{e});
        }
    }
}

