/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.classes.TuriMethod;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TuriHttpClient
implements TuriFunction {
    @Override
    public String name() {
        return "http_client";
    }

    private static String str(Object s) {
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    @Override
    public Object call(Context context, Object[] arguments) throws ExecutionException {
        ch.turic.memory.Context ctx = FunUtils.ctx(context);
        LngObject parameters = FunUtils.arg(this.name(), arguments, LngObject.class);
        Boolean streamMode = parameters.getField("stream", true);
        HttpRequest request = this.buildRequest(parameters);
        try {
            HttpClient client = this.buildClient(parameters);
            HttpResponse<Object> response = streamMode != false ? client.send(request, HttpResponse.BodyHandlers.ofInputStream()) : client.send(request, HttpResponse.BodyHandlers.ofString());
            LngObject result = LngObject.newEmpty(ctx);
            InputStream inputStream = (InputStream)(streamMode != false ? response.body() : null);
            InputStreamReader inputStreamReader = streamMode != false ? new InputStreamReader(inputStream) : null;
            TuriMethod<Object> resourceCloser = new TuriMethod<Object>(args -> {
                if (inputStream != null) {
                    inputStream.readAllBytes();
                }
                client.close();
                return null;
            });
            result.setField("status", response.statusCode());
            result.setField("body", streamMode != false ? null : response.body());
            result.setField("input", inputStream);
            result.setField("stream", inputStreamReader);
            result.setField("uri", TuriHttpClient.str(response.uri()));
            this.setHeaders(ctx, result, response);
            result.setField("version", response.version().toString());
            result.setField("close", resourceCloser);
            result.setField("exit", resourceCloser);
            result.setField("entry", new TuriMethod<LngObject>(args -> result));
            return result;
        }
        catch (Exception e) {
            throw new ExecutionException("HTTP request failed: " + e.getMessage(), new Object[0]);
        }
    }

    private void setHeaders(ch.turic.memory.Context context, LngObject result, HttpResponse<?> response) {
        LngObject headers = LngObject.newEmpty(context);
        for (Map.Entry<String, List<String>> header : response.headers().map().entrySet()) {
            LngList headerValues = new LngList();
            headerValues.addAll((Collection)header.getValue());
            headers.setField(header.getKey(), headerValues);
        }
        result.setField("headers", headers);
    }

    private HttpClient buildClient(LngObject parameters) {
        Object timeout;
        HttpClient.Builder builder = HttpClient.newBuilder();
        String redirect = TuriHttpClient.str(parameters.getField("redirect_policy"));
        if (redirect != null) {
            try {
                builder.followRedirects(HttpClient.Redirect.valueOf(redirect));
            }
            catch (IllegalArgumentException e) {
                throw new ExecutionException("Invalid redirect policy: " + redirect, new Object[0]);
            }
        }
        if ((timeout = parameters.getField("timeout")) != null) {
            if (timeout instanceof Duration) {
                Duration dur = (Duration)timeout;
                builder.connectTimeout(dur);
            } else {
                throw new ExecutionException("Invalid timeout value: " + String.valueOf(timeout), new Object[0]);
            }
        }
        return builder.build();
    }

    private HttpRequest buildRequest(LngObject parameters) {
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        String method = TuriHttpClient.str(parameters.getField("method", "GET"));
        Set<String> validMethods = Set.of("GET", "POST", "PUT", "DELETE", "PATCH", "HEAD", "OPTIONS");
        if (!validMethods.contains(method.toUpperCase())) {
            throw new ExecutionException("Invalid HTTP method: " + method, new Object[0]);
        }
        String body = TuriHttpClient.str(parameters.getField("body"));
        HttpRequest.BodyPublisher bodyPublisher = body == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(body);
        Object headers = parameters.getField("headers");
        if (headers != null) {
            if (headers instanceof LngObject) {
                LngObject lngHeaders = (LngObject)headers;
                for (String header : lngHeaders.fields()) {
                    Iterator<Object> iterator = lngHeaders.getField(header);
                    if (iterator instanceof LngList) {
                        LngList lngList = (LngList)((Object)iterator);
                        for (Object h : lngList.array) {
                            builder.header(header, TuriHttpClient.str(h));
                        }
                        continue;
                    }
                    builder.header(header, TuriHttpClient.str(lngHeaders.getField(header)));
                }
            } else {
                throw new ExecutionException("Field 'headers' has to be an object, it is '%s'.", headers);
            }
        }
        builder.method(method, bodyPublisher);
        String url = TuriHttpClient.str(parameters.getField("url"));
        if (url == null) {
            throw new ExecutionException("Missing 'url' parameter", new Object[0]);
        }
        try {
            builder.uri(URI.create(url));
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Invalid URL: " + url, new Object[0]);
        }
        return builder.build();
    }
}

